<?php

// ****************************** BLOG ******************************

function writeGetContentLink($id) {
	return "javascript:getContent(\"blog\",\"" . $id . "\");";
};

function writeShiftPostLink($id) {
	return "javascript:shiftPost(\"blog\",\"" . $id . "\");";
};

function writeFilterLink($year, $month, $day, $category, $tag, $anchor) {
	return "javascript:setFilter(\"" . $year . "\",\"" . $month . "\",\"" . $day . "\",\"" . $category . "\",\"" . $tag . "\", \"" . $anchor . "\");";
};

function decodeEntities($str) {
	//str_replace("&amp;lt;br&amp;gt;", "<br />", $str);
	//$str = str_replace("&lt;", "<", $str);
	//$str = str_replace("&gt;", ">", $str);
	$str = htmlspecialchars_decode($str);
	$str = html_entity_decode($str, ENT_QUOTES, 'UTF-8');
	//$str = mb_convert_encoding($str, 'HTML-ENTITIES', 'UTF-8');
	return $str;
};

function encodeEntities($str) {
	$str = str_replace(PHP_EOL, "<br>", $str);
	$str = htmlspecialchars($str, ENT_QUOTES);
	$str = mb_convert_encoding($str, "HTML-ENTITIES", "UTF-8");
	$str = htmlentities($str);
	return $str;
};

function writeFrontpagePost($id, $title, $time, $year, $month, $day, $category, $commentcount, $body) {
	echo "<p style='margin-top:0;margin-bottom:0;margin-left:-1pt;' class='singleSpace'><a class='sectionTitle' href='" . writeGetContentLink($id) . "'>" . decodeEntities($title) . "</a></p>
	<p style='margin-top:0;margin-bottom:0;margin-left:-1pt;' class='eight'>posted on " . $day . " " . month_convertToWords($month) . ", " . $year . " " . findDay($day, $month, $year, TRUE) . " " . $time . " / <a href='" . writeFilterLink("", "", "", $category, "", "") . "'>" . $category . "</a></p>";
	echo "<p>" . decodeEntities($body) . "</p>";
	echo "<p class='eight' align='right'><a href='" . writeGetContentLink($id) . "'>" . commentCountLine($commentcount) . "</a></p>";
	echo "<hr>";
};

function writePostInfo($day, $month, $year, $time, $writeTime) {
if ($writeTime == True)
	return $day . " " . month_convertToWords($month) . ", " . $year . " " . findDay($day, $month, $year, TRUE) . "<br>" . $time;
else
	return $day . " " . month_convertToWords($month) . ", " . $year;
};

function commentCountLine($commentcount) {
	switch ($commentcount) {
		case (0) :
			return 'add comments';
			break;
		case (1) :
			return 'one comment';
			break;
		default :
			return $commentcount . " comments";
	};
};

function writePostList($type, $target) {
	$con = mysqli_connect("localhost", "chezjeff", "thwaouthbo");
	mysqli_select_db($con, "chezjeff01");
    if ($type == "t") { #if want to list posts from categories
        $result_list = mysqli_query($con, "select day(`blog12`.`dop`) as 'day', month(`blog12`.`dop`) as 'month', year(`blog12`.`dop`) as 'year', `title`, `id`, (select count(*) from `comment12` where `comment12`.`id` = `blog12`.`id`) as 'commentcount' from `blog12` where `tag` like '%" . $target . "%' order by `dop` desc;");
        
	while ($result = mysqli_fetch_array($result_list))
		echo "<a class='archive' href='" . writeGetContentLink($result['id']) . "'>" . $result['title'] . "</a> - ". writePostInfo($result['day'], $result['month'], $result['year'], '0', false) ."<br />";
	mysqli_close($con);

    } else {#if want to list posts from tags
	$result_list = mysqli_query($con, "select `title`, `id`, (select count(*) from `comment12` where `comment12`.`id` = `blog12`.`id`) as 'commentcount' from `blog12` where `category` = '" . $target . "' order by `dop` desc;");
	while ($result = mysqli_fetch_array($result_list))
		echo "<a class='archive' href='" . writeGetContentLink($result['id']) . "'>" . $result['title'] . "</a> /" . $result['commentcount'] . "<br />";
	mysqli_close($con);
};
};

function loadComments($postId) {
	$con = mysqli_connect("localhost", "chezjeff", "thwaouthbo");
	mysqli_select_db($con, "chezjeff01");
	$comment_result = mysqli_query($con, "select `name`, `link`, `body`, year(`timestamp`) as 'year', month(`timestamp`) as 'month', day(`timestamp`) as 'date', hour(`timestamp`) as 'hour', minute(`timestamp`) as 'minute' from `comment12` where `id` = '" . $postId . "' order by `timestamp`;");
	echo "<p><b>" . commentCountLine(mysqli_num_rows($comment_result)) . "</b></p>";
	while ($comment = mysqli_fetch_array($comment_result)) {
		echo "<p style='margin-bottom: 0px;margin-left: 20px'>" . decodeEntities($comment['body']) . "</p>";
		if ($comment["link"] == "http://")
			echo "<p style='margin-top: 0px;' class='eight'>posted by <b>" . $comment['name'] . "</b>, " . writeTextTimeStamp($comment['year'], $comment['month'], $comment['date'], $comment['hour'], $comment['minute']) . "</p>";
		else
			echo "<p style='margin-top: 0px;' class='eight'>posted by <b><a href='" . $comment['link'] . "'>" . $comment['name'] . "</a></b>, " . writeTextTimeStamp($comment['year'], $comment['month'], $comment['date'], $comment['hour'], $comment['minute']) . "</p>";
	};
	mysqli_close($con);
};

function buildFilteredQuery($year, $month, $day, $category, $tag, $anchor) {
	$and = "";
	$condStatement = "where ";
	if ($year != "") {
		$condStatement = $condStatement . "year(`dop`) = " . $year . " ";
		$and = "and ";
	};
	if ($month != "") {
		$condStatement = $condStatement . $and . "month(`dop`) = " . $month . " ";
		$and = "and ";
	};
	if ($day != "") {
		$condStatement = $condStatement . $and . "day(`dop`) = " . $day . " ";
		$and = "and ";
	};
	if ($category != "") {
		$condStatement = $condStatement . $and . "`category` = " . $category . " ";
		$and = "and ";
	};
	if ($tag != "") {
		// break down multiple tags and build them into the SQL query
		$arrayTag = explode(",", $tag);
		for ($n = 0; $n < count($arrayTag) - 1; $n++) {
			$condStatement = $condStatement . $and . "`tag` like '%" . $arrayTag[$n] . "%' ";
			$and = "and ";
		};
	};
};

// ****************************** HOUSE-KEEPING *********************************************

function writeTextTimeStamp($year, $month, $date, $hour, $minute) {
	// this function outputs timestamp in format: 1 January, 2015 Thursday 11:30pm
	return $date . " " . month_convertToWords($month) . ", " . $year . " " . findDay($date, $month, $year, TRUE) . " " . AMPMdecider($hour, $minute);
};

function AMPMdecider($hour, $minute) {
	if ($hour <= 12)
		return $hour . ":" . $minute . "am";
	else
		return ($hour - 12) . ":" . $minute . "pm";
};

function connectSql() {
	/* this function connects to the mysql server */
	/* initialise MySQL session */
	$con = mysqli_connect("localhost", "chezjeff", "thwaouthbo");
	mysqli_select_db($con, "chezjeff01");
};

function disconnectSql() {
	mysqli_close($con);
};

function replaceSpace($target) {
	return str_replace(" ", "%", $target);
};

function revertSpace($target) {
	return str_replace("%", " ", $target);
};

function daysInMonth($month, $year) {
	/* determine the number of days there are in a given month */
	if (($month == 1) || ($month == 3) || ($month == 5) || ($month == 7) || ($month == 8) || ($month == 10) || ($month == 12))
		return 31;
	elseif ($month == 2) {
		if (fmod($year, 4) == 0)/* leap year */
			return 29;
		else
			return 28;
	} else
		return 30;
}

function findDay($thisDay, $thisMonth, $thisYear, $convert)
/* finds the date of week of a particular date */
{
	$nDay2k = 0;
	/* work out how many days have elasped since Dec 31, 2000 */
	for ($n = 1; $n <= ($thisYear - 2001); $n++) {
		if (fmod($n, 4) == 0)/* leap year */
			$nDay2k += 366;
		else
			$nDay2k += 365;
	};
	/* work out how many days have elasped since start of year */
	for ($n = 1; $n <= ($thisMonth - 1); $n++) {
		if (($n == 1) || ($n == 3) || ($n == 5) || ($n == 7) || ($n == 8) || ($n == 10) || ($n == 12))
			$nDay2k += 31;
		elseif ($n == 2) {
			if (fmod($thisYear, 4) == 0)/* leap year */
				$nDay2k += 29;
			else
				$nDay2k += 28;
		} else
			$nDay2k += 30;
	};
	$nDay2k += $thisDay;
	if ($convert == TRUE)
		return dayofweek_convertToWords(fmod($nDay2k, 7));
	else
		return fmod($nDay2k, 7);
};

function dayofweek_convertToWords($dayOfWeek) {
	switch ($dayOfWeek) {
		case (0) :
			return 'Sunday';
			break;
		case (1) :
			return 'Monday';
			break;
		case (2) :
			return 'Tuesday';
			break;
		case (3) :
			return 'Wednesday';
			break;
		case (4) :
			return 'Thursday';
			break;
		case (5) :
			return 'Friday';
			break;
		case (6) :
			return 'Saturday';
			break;
	};
};

function month_convertToWords($month) {
	switch ($month) {
		case (1) :
			return 'January';
			break;
		case (2) :
			return 'February';
			break;
		case (3) :
			return 'March';
			break;
		case (4) :
			return 'April';
			break;
		case (5) :
			return 'May';
			break;
		case (6) :
			return 'June';
			break;
		case (7) :
			return 'July';
			break;
		case (8) :
			return 'August';
			break;
		case (9) :
			return 'September';
			break;
		case (10) :
			return 'October';
			break;
		case (11) :
			return 'Novmeber';
			break;
		case (12) :
			return 'December';
			break;
	};
};
?>
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    