<?php

/* retrieve list of tags from database */
$sqlTagList_temp = mysqli_query($con, "select `tag` from `blog12` where `tag` <> '';");

$tagList = array(); /* for storing the entire tag list */
$tempTagList = array(); /* for storing the tag list of one entry */

while ($sqlTagList = mysqli_fetch_array($sqlTagList_temp)) { # for each blog entry
	$tempTagList = explode(",",strtolower($sqlTagList["tag"])); # split the tags by comma, then save to an array
	$tagList = array_merge($tagList, $tempTagList); # and then merge the array with the array containing the tags from all entries
};

/* sort the list ascending alphabetically */
sort($tagList);

/* START OUTPUTTING tagcloud.htm */
/* initalise tagcloud.htm */

$tcFile = fopen("../tagcloud.htm", "w");
fwrite($tcFile, "<p align=right style=margin-right:10px;>".chr(13));
$activeTag = $tagList[0];

$tempCount = 0;
/* count the number of instances of each tag, then output tag along with size level */
for ($m=0;$m<=((count($tagList))-1);$m++) {
	if ($activeTag == $tagList[$m])
		/* if this tag is the same as the tag that is being counted, increment the tag count by 1 */
		$tempCount += 1;
	else {
		/* if this tag is not the same, output the previous tag */
		
		/* determine which style to use */
		switch ($tempCount) {
			case ($tempCount <= 10):
				$styleStr = "font-size: 8pt;";
				break;
			case (($tempCount >= 11) && ($tempCount <= 40)):
				$styleStr = "font-size: 12pt;font-weight: bold;";
				break;
			case (($tempCount >= 41) && ($tempCount <= 100)):
				$styleStr = "font-size: 16pt;";
				break;
			case ($tempCount > 100):
				$styleStr = "font-size: 16pt;font-weight: bold;";
				break;
		};
		
		/* output tags to tagcloud.htm */
		/* doTags are placeholders, used for referring to functions in the output page */
		$jsScript = 'doTags("'.$tagList[($m-1)].'");';
		fwrite($tcFile, "<span style='".$styleStr."'><a href=javascript:; onClick='".$jsScript."'>".$tagList[($m-1)]."</a></span> ".chr(13));
		
		/* tempCount resetted to 1 to take the current item (i.e. $tagList[m]) into account */
		$tempCount = 1;
		$activeTag = $tagList[$m];
	};
};

fwrite($tcFile, "</p>");
fclose($tcFile);


?>