<?php defined( 'ABSPATH' ) or die( 'No script kiddies please!' );
/**
 * Plugin Name: TeslaThemes posts
 * Plugin URI: http://teslathemes.com/live/?item=unik
 * Description: Teslathemes custom posts
 * Version: 0.8
 * Author: TeslaThemes
 * Author URI: http://teslathemes.com
 * Text Domain: tt
 * Domain Path: /lang/
 * License: GPL
 */

/* Include core post generator */

require_once(plugin_dir_path( __FILE__ ) . 'core-tt-posts.php');
(!class_exists('GenerateCustomMeta')) ? require_once(plugin_dir_path( __FILE__ ) . 'custom_meta_box.php') : '';


if ( is_admin() ) {
 	add_action( 'admin_enqueue_scripts', 'tt_add_goods' );

	function tt_add_goods () {
		 wp_enqueue_style( 'tt-posts' , plugin_dir_url( __FILE__ ) . 'css/tt-posts.css');
		 wp_enqueue_script('tt-posts.js', plugin_dir_url( __FILE__ ) . 'js/tt-posts.js', array('jquery'), false, true);
	}
}

$tt_post = new TTGeneratePost();
$meta = new GenerateCustomMeta();


/* Create Portfolio custom post*/
$tt_post->tt_add_post(
		array('portfolio' 	=> array(
				'supports'	=> array( 'title', 'editor', 'thumbnail' ),
				'menu_icon' => 'dashicons-images-alt2'
			)),
		array('filters' => array(
				'hierarchical' => true
			))
	);

$meta->add_meta_box('page_meta_portfolio', array(
            'post_type' => array('portfolio'),
            'title'     => __('Portfolio big image', 'tt'),
            'position'  => 'side',
            'fields'    => array(
                    'lg_img' => array('image',__('', 'tt')),
                    'video_url' => array('text',__('or, provide URL to your video (YouTube / Vimeo)', 'tt'))
                )
        ));


$tt_post->tt_add_post(
		array('timeline' => array(
				'supports'	=> array( 'title', 'editor', 'thumbnail' ),
				'menu_icon' => 'dashicons-networking'
			)),
		array('periode' => array())
	);

$meta->add_meta_box('page_meta_timeline', array(
            'post_type' => array('timeline'),
            'title'     => __('Event date', 'tt'),
            'position'  => 'side',
            'fields'    => array(
                    'timeline_date' => array('date',__('', 'tt'))
                )
        ));

$tt_post->tt_add_post(
		array('testimonials' => array(
				'supports'	=> array( 'title', 'editor', 'thumbnail' ),
				'menu_icon' => 'dashicons-format-chat'
			))
	);

$meta->add_meta_box('page_meta_testimonials', array(
            'post_type' => array('testimonials'),
            'title'     => __('Client meta', 'tt'),
            'position'  => 'side',
            'fields'    => array(
                    'client_url' => array('text',__('Provide client URL', 'tt')),
                    'client_info' => array('text',__('Provide client info', 'tt')),
                )
        ));

/* Helper functions */

function tt_get_post($post_type = 'post', $config = false) {
    $args = array(
        'posts_per_page'   => -1,
        'offset'           => 0,
        'category'         => '',
        'category_name'    => '',
        'orderby'          => 'post_date',
        'order'            => 'DESC',
        'include'          => '',
        'exclude'          => '',
        'meta_key'         => '',
        'meta_value'       => '',
        'post_type'        => $post_type,
        'post_mime_type'   => '',
        'post_parent'      => '',
        'post_status'      => 'publish',
        'suppress_filters' => true 
    );

    if(!empty($config)) {
        $args = wp_parse_args( $config, $args );            
    }

    return get_posts($args);
}

function lazy_img($img, $alt=null, $width=null, $height=null) {

    if(is_array($img)) {
        $img = $img[0];
        $width = $img[1];
        $height = $img[2];
    }

    $width = !empty($width) ? sprintf('width="%s"', $width) : '';
    $height = !empty($height) ? sprintf('height="%s"', $height) : '';
    $holder = plugin_dir_url( __FILE__ ) . '/images/load.svg';

    return sprintf('<img src="%s" data-src="%s" alt="%s" %s %s>', $holder, $img, $alt, $width, $height);
}

function tt_view($name = null, array $params = array(), $folder=false) {
    global $posts, $post, $wp_did_header, $wp_query, $wp_rewrite, $wpdb, $wp_version, $wp, $id, $comment, $user_ID;

    do_action("get_template_part_tt", 'tt', $name);

    $template;
    if (isset($name)) {
        $template_container = !empty($folder) ? 'views/'.$folder : 'views';
        $template = $template_container."/tt-{$name}.php";
    }

    $_template_file = plugin_dir_path( __FILE__ ) .$template;

    if (is_array($wp_query->query_vars)) {
        extract($wp_query->query_vars, EXTR_SKIP);
    }
    extract($params, EXTR_SKIP);

    require($_template_file);
}

/* Shortcodes */

add_shortcode('tt_portfolio', 'tt_portfolio');

function tt_portfolio($atts, $content = null) {
	$defaults = shortcode_atts(array(
		'count'		=> '',
		'columns'	=> '4',
		'fit'		=> '',
		'el_class' 	=> ''
	), $atts);

	$loop_settings = array();

	!empty($defaults['count']) ? $loop_settings['posts_per_page'] = $defaults['count'] : '';

	$defaults['portfolio'] = tt_get_post('portfolio', $loop_settings);

	foreach ($defaults['portfolio'] as $key => $value) {
		$thumb_array = wp_get_attachment_image_src(get_post_thumbnail_id($value->ID), 'full', true);
		$portfolio_thumb[$value->ID] = lazy_img($thumb_array[0], $thumb_array[1], $thumb_array[2]);

		$meta_array = get_post_meta($value->ID);
		$portfolio_meta[$value->ID] = !empty($meta_array['page_meta_portfolio'][0]) ? unserialize($meta_array['page_meta_portfolio'][0]) : array();

		$categories[$value->ID] = wp_get_post_terms($value->ID, 'filters_tax');

		if(!empty($categories[$value->ID])) {
			foreach ($categories[$value->ID] as $key => $category) {
				$category_name[] = $category->name;
			}			
		} else {
			$category_name = array();
		}

		$portfolio_cat[$value->ID] = $category_name;	
		$category_name = array();
	}

	if(!empty($portfolio_cat)) {

		$filters = call_user_func_array('array_merge', $portfolio_cat);
		$filters = array_unique($filters);
		$defaults['portfolio_filters'] = $filters;
	}

	$defaults['portfolio_thumb'] = $portfolio_thumb;
	$defaults['portfolio_meta'] = $portfolio_meta;
	$defaults['portfolio_cat'] = $portfolio_cat;

	switch ($defaults['columns']) { 
		case '1': $defaults['column'] = 12; break;
		case '2': $defaults['column'] = 6; break;
		case '3': $defaults['column'] = 4; break;
		case '4': $defaults['column'] = 3; break;
		case '6': $defaults['column'] = 2; break;
		default:  $defaults['column'] = 3; break;
	}

	ob_start();
	tt_view('portfolio', $defaults);
	return ob_get_clean();

}

add_shortcode('tt_timeline', 'tt_timeline');

function tt_timeline($atts, $content = null) {

	$defaults = shortcode_atts(array(
		'count'		=> '',
		'el_class' 	=> ''
	), $atts);

	$loop_settings = array();
	$timeline_arr = array();


	!empty($defaults['count']) ? $loop_settings['posts_per_page'] = $defaults['count'] : '';

	$defaults['timeline'] = tt_get_post('timeline', $loop_settings);


	foreach ($defaults['timeline'] as $key => $value) {

		$time_item = array();

		$time_item['id'] = $value->ID;
		$time_item['title'] = $value->post_title;
		$time_item['content'] = $value->post_content;

		$meta_array = get_post_meta($value->ID);
		$meta = !empty($meta_array['page_meta_timeline'][0]) ? unserialize($meta_array['page_meta_timeline'][0]) : array();

		$time_item['date'] = !empty($meta['timeline_date']) ? $meta['timeline_date'] : '';
		$time_item['date'] = date('j M', strtotime( $time_item['date'] ));

		$categories = wp_get_post_terms($value->ID, 'periode_tax');
		$categories = !empty($categories) ? $categories[0] : '';
		if(empty($categories)) {
			return '';
		}
		$year = $categories->name;
		$timeline_arr[$year][] = $time_item;
	}

	krsort($timeline_arr, SORT_NUMERIC);

	$defaults['timeline'] = $timeline_arr;

	ob_start();
	tt_view('timeline', $defaults);
	return ob_get_clean();

}

add_shortcode('tt_testimonials', 'tt_testimonials');

function tt_testimonials($atts, $content = null) {
	$defaults = shortcode_atts(array(
		'count'		=> '',
		'light'		=> '',
		'el_class' 	=> ''
	), $atts);

	$loop_settings = array();

	!empty($defaults['count']) ? $loop_settings['posts_per_page'] = $defaults['count'] : '';

	$defaults['testimonials'] = tt_get_post('testimonials', $loop_settings);

	foreach ($defaults['testimonials'] as $key => $value) {
		$thumb_array = wp_get_attachment_image_src(get_post_thumbnail_id($value->ID), 'testimonials-thumb', true);
		$testimonials_thumb[$value->ID] = lazy_img($thumb_array[0], $thumb_array[1], $thumb_array[2]);

		$meta_array = get_post_meta($value->ID);
		$testimonials_meta[$value->ID] = !empty($meta_array['page_meta_testimonials'][0]) ? unserialize($meta_array['page_meta_testimonials'][0]) : array();		
	}

	$defaults['testimonials_thumb'] = $testimonials_thumb;
	$defaults['testimonials_meta'] = $testimonials_meta;

	ob_start();
	tt_view('testimonials', $defaults);
	return ob_get_clean();

}

if(class_exists('Vc_Manager')) {

/* TT Portfolio */

vc_map( array(
	'name' => __( 'Portfolio', 'js_composer' ),
	'base' => 'tt_portfolio',
	'icon' => 'icon-wpb',
	'category' => __( 'Teslathemes', 'js_composer' ),
	'description' => __( 'Show portfolio', 'js_composer' ),
	"params" => array(
		array(
			'type' => 'textfield',
			'heading' => __( 'Portfolio items to display', 'js_composer' ),
			'param_name' => 'count',
			'description' => __( '', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => __( 'Porfolio columns', 'js_composer' ),
			'param_name' => 'columns',
			'value' => array(
				__( '1 column', 'js_composer' )  => '1',
				__( '2 columns', 'js_composer' ) => '2',
				__( '3 columns', 'js_composer' ) => "3",
				__( '4 columns', 'js_composer' ) => "4",
				__( '6 columns', 'js_composer' ) => "5"
			),
			'description' => __( '', 'js_composer' )
		),
		array(
			'type' => 'checkbox',
			'heading' => __( 'Fit columns', 'js_composer' ),
			'param_name' => 'fit',
			'description' => __( 'If selected, the space between columns will disapear', 'js_composer' ),
			'value' => array( __( 'Yes, please', 'js_composer' ) => 'yes' )
		),
		array(
			'type' => 'textfield',
			'heading' => __( 'Extra class name', 'js_composer' ),
			'param_name' => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'js_composer' )
		)
	)
) );

/* TT Timeline */

vc_map( array(
	'name' => __( 'Timeline', 'js_composer' ),
	'base' => 'tt_timeline',
	'icon' => 'icon-wpb',
	'category' => __( 'Teslathemes', 'js_composer' ),
	'description' => __( 'Show timeline', 'js_composer' ),
	"params" => array(
		array(
			'type' => 'textfield',
			'heading' => __( 'Timeline items to display', 'js_composer' ),
			'param_name' => 'count',
			'description' => __( '', 'js_composer' ),
		),
		array(
			'type' => 'textfield',
			'heading' => __( 'Extra class name', 'js_composer' ),
			'param_name' => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'js_composer' )
		)
	)
) );

/* TT Testimonials */

vc_map( array(
	'name' => __( 'Testimonials', 'js_composer' ),
	'base' => 'tt_testimonials',
	'icon' => 'icon-wpb',
	'category' => __( 'Teslathemes', 'js_composer' ),
	'description' => __( 'Show testimonials', 'js_composer' ),
	"params" => array(
		array(
			'type' => 'textfield',
			'heading' => __( 'Tetsimonials to display', 'js_composer' ),
			'param_name' => 'count',
			'description' => __( '', 'js_composer' ),
		),
		array(
			'type' => 'checkbox',
			'heading' => __( 'Use light version', 'js_composer' ),
			'param_name' => 'light',
			'description' => __( '', 'js_composer' ),
			'value' => array( __( 'Yes, please', 'js_composer' ) => 'yes' )
		),
		array(
			'type' => 'textfield',
			'heading' => __( 'Extra class name', 'js_composer' ),
			'param_name' => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'js_composer' )
		)
	)
) );

}