/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class HeapRecordId {
    private int pgno;
    private short indx;

    public HeapRecordId(int n, short s) {
        this.pgno = n;
        this.indx = s;
    }

    public static HeapRecordId fromArray(byte[] byArray) throws IllegalArgumentException {
        return HeapRecordId.fromArray(byArray, ByteOrder.LITTLE_ENDIAN);
    }

    public static HeapRecordId fromArray(byte[] byArray, ByteOrder byteOrder) throws IllegalArgumentException {
        if (byArray.length < 6) {
            throw new IllegalArgumentException("Invalid buffer size.");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(byteOrder);
        int n = byteBuffer.getInt();
        short s = byteBuffer.getShort();
        return new HeapRecordId(n, s);
    }

    public byte[] toArray() {
        return this.toArray(ByteOrder.LITTLE_ENDIAN);
    }

    public byte[] toArray(ByteOrder byteOrder) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(6);
        byteBuffer.order(byteOrder);
        byteBuffer.putInt(this.pgno).putShort(this.indx);
        return byteBuffer.array();
    }

    public int getPageNumber() {
        return this.pgno;
    }

    public void setPageNumber(int n) {
        this.pgno = n;
    }

    public short getIndex() {
        return this.indx;
    }

    public void setIndex(short s) {
        this.indx = s;
    }
}

