/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Defaults {
    public Checkbox disableAccount;
    public Checkbox forcePasswordChange;
    public Checkbox allowPostdatedTix;
    public Checkbox allowForwardableTix;
    public Checkbox allowRenewableTix;
    public Checkbox allowProxiableTix;
    public Checkbox allowServiceTix;
    public Checkbox allowTGTAuth;
    public Checkbox allowDupAuth;
    public Checkbox requirePreauth;
    public Checkbox requireHWAuth;
    public Checkbox serverSide;
    public TextField maxTicketLife;
    public TextField maxTicketRenewableLife;
    public TextField accountExpiryDate;
    public Label maxTicketLifeLabel;
    public Label maxTicketRenewableLifeLabel;
    public Label accountExpiryDateLabel;
    public Checkbox showLists;
    public Checkbox staticLists;
    public TextField cacheTime;
    public Label cacheTimeLabel;
    public Button lifeMoreButton;
    public Button renewalMoreButton;
    public Button dateMoreButton;
    public Button cacheMoreButton;
    public Button saveButton;
    public Button applyButton;
    public Button cancelButton;
    public MenuItem csHelp;
    private Flags flags;
    private boolean serverSideValue;
    private int maxTicketLifeValue;
    private int maxTicketRenewableLifeValue;
    private Date accountExpiryDateValue;
    private boolean showListsValue;
    private boolean staticListsValue;
    private long cacheTimeValue;
    private String defaultsFile;
    private Color background;
    private EditingFrame frame = null;
    private boolean helpMode = false;
    private static DateFormat df = DateFormat.getDateTimeInstance(2, 2);
    private static NumberFormat nf = NumberFormat.getInstance();
    private static ResourceBundle rb = ResourceBundle.getBundle("GuiResource");
    private static String neverString = Defaults.getString("Never");
    Color SEPERATOR_COLOR = Color.blue;
    Color CHECKBOX_COLOR = Color.orange;
    Color LABEL_COLOR = Color.pink;
    Color PANEL_COLOR1 = Color.lightGray;
    Color PANEL_COLOR2 = Color.darkGray;

    Defaults(String string, Color color) {
        this.defaultsFile = string;
        this.background = color;
        this.flags = new Flags();
        this.serverSideValue = true;
        this.maxTicketLifeValue = 144000;
        this.maxTicketRenewableLifeValue = 144000;
        Calendar calendar = Calendar.getInstance();
        calendar.roll(1, true);
        this.accountExpiryDateValue = calendar.getTime();
        this.showListsValue = true;
        this.staticListsValue = false;
        this.cacheTimeValue = 300L;
        this.readFromFile();
    }

    Defaults(Defaults defaults) {
        this.defaultsFile = defaults.defaultsFile;
        this.background = defaults.background;
        this.flags = new Flags(defaults.flags.getBits());
        this.maxTicketLifeValue = defaults.maxTicketLifeValue;
        this.maxTicketRenewableLifeValue = defaults.maxTicketRenewableLifeValue;
        this.accountExpiryDateValue = defaults.accountExpiryDateValue;
        this.showListsValue = defaults.showListsValue;
        this.staticListsValue = defaults.staticListsValue;
        this.cacheTimeValue = defaults.cacheTimeValue;
    }

    public void restoreValues(Defaults defaults) {
        this.flags = new Flags(defaults.flags.getBits());
        this.maxTicketLifeValue = defaults.maxTicketLifeValue;
        this.maxTicketRenewableLifeValue = defaults.maxTicketRenewableLifeValue;
        this.accountExpiryDateValue = defaults.accountExpiryDateValue;
        this.showListsValue = defaults.showListsValue;
        this.staticListsValue = defaults.staticListsValue;
        this.cacheTimeValue = defaults.cacheTimeValue;
        this.updateGuiComponents();
    }

    public Frame getEditingFrame() {
        if (this.frame == null) {
            this.frame = new EditingFrame();
            this.updateGuiComponents();
            this.frame.setSize(500, 680);
            this.frame.setResizable(true);
            this.frame.setBackground(this.background);
        }
        return this.frame;
    }

    public void refreshDefaults() {
        this.readFromFile();
        this.updateGuiComponents();
    }

    public final boolean updateFromGui() {
        return this.setMaxTicketLife() && this.setMaxTicketRenewableLife() && this.setAccountExpiryDate() && this.setCacheTime();
    }

    boolean setServerSide() {
        this.serverSideValue = this.serverSide.getState();
        this.enableTicketLifeFields(this.serverSideValue);
        return true;
    }

    private void enableTicketLifeFields(boolean bl) {
        this.maxTicketLifeLabel.setEnabled(!bl);
        this.maxTicketLife.setEnabled(!bl);
        this.maxTicketRenewableLifeLabel.setEnabled(!bl);
        this.maxTicketRenewableLife.setEnabled(!bl);
        this.lifeMoreButton.setEnabled(!bl);
        this.renewalMoreButton.setEnabled(!bl);
    }

    boolean setMaxTicketLife() {
        try {
            this.maxTicketLifeValue = nf.parse(this.maxTicketLife.getText().trim()).intValue();
        }
        catch (ParseException parseException) {
            KdcGui.showDataFormatError(this.maxTicketLife, 1);
            return false;
        }
        return true;
    }

    boolean setMaxTicketRenewableLife() {
        try {
            this.maxTicketRenewableLifeValue = nf.parse(this.maxTicketRenewableLife.getText().trim()).intValue();
        }
        catch (ParseException parseException) {
            KdcGui.showDataFormatError(this.maxTicketRenewableLife, 1);
            return false;
        }
        return true;
    }

    boolean setAccountExpiryDate() {
        String string = this.accountExpiryDate.getText().trim();
        if (string.equalsIgnoreCase(neverString)) {
            this.accountExpiryDateValue = new Date(0L);
        } else {
            try {
                this.accountExpiryDateValue = df.parse(string);
            }
            catch (ParseException parseException) {
                KdcGui.showDataFormatError(this.accountExpiryDate, 2);
                return false;
            }
            catch (NullPointerException nullPointerException) {
                KdcGui.showDataFormatError(this.accountExpiryDate, 2);
                return false;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                KdcGui.showDataFormatError(this.accountExpiryDate, 2);
                return false;
            }
        }
        return true;
    }

    boolean setCacheTime() {
        try {
            this.cacheTimeValue = nf.parse(this.cacheTime.getText().trim()).intValue();
        }
        catch (ParseException parseException) {
            KdcGui.showDataFormatError(this.cacheTime, 1);
            return false;
        }
        return true;
    }

    boolean setShowLists() {
        this.showListsValue = this.showLists.getState();
        return true;
    }

    boolean setStaticLists() {
        this.staticListsValue = this.staticLists.getState();
        this.enableCacheTimeFields(this.staticListsValue);
        return true;
    }

    private void enableCacheTimeFields(boolean bl) {
        this.cacheTime.setEnabled(!bl);
        this.cacheTimeLabel.setEnabled(!bl);
        this.cacheMoreButton.setEnabled(!bl);
    }

    public boolean getServerSide() {
        return this.serverSideValue;
    }

    public Integer getMaxTicketLife() {
        return new Integer(this.maxTicketLifeValue);
    }

    public Integer getMaxTicketRenewableLife() {
        return new Integer(this.maxTicketRenewableLifeValue);
    }

    public Date getAccountExpiryDate() {
        return new Date(this.accountExpiryDateValue.getTime());
    }

    public boolean getShowLists() {
        return this.showListsValue;
    }

    public boolean getStaticLists() {
        return this.staticListsValue;
    }

    public boolean getCacheLists() {
        return this.staticListsValue;
    }

    public long getCacheTime() {
        return this.cacheTimeValue;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public void toggleFlag(int n) {
        this.flags.toggleFlags(n);
    }

    public void close(boolean bl) {
        if (this.frame != null) {
            this.frame.close(bl);
        }
    }

    private void saveToFile() {
        try {
            PrintWriter printWriter = null;
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.defaultsFile)));
            printWriter.println(this.flags.getBits());
            printWriter.println(this.maxTicketRenewableLifeValue);
            printWriter.println(df.format(this.accountExpiryDateValue));
            printWriter.println(new Boolean(this.showListsValue).toString());
            printWriter.println(new Boolean(this.staticListsValue).toString());
            printWriter.println(new Long(this.cacheTimeValue).toString());
            printWriter.println(this.serverSideValue);
            printWriter.println(this.maxTicketLifeValue);
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readFromFile() {
        try {
            BufferedReader bufferedReader = null;
            bufferedReader = new BufferedReader(new FileReader(this.defaultsFile));
            this.flags = new Flags(new Integer(bufferedReader.readLine()));
            this.maxTicketRenewableLifeValue = new Integer(bufferedReader.readLine());
            this.accountExpiryDateValue = df.parse(bufferedReader.readLine());
            String string = bufferedReader.readLine();
            this.showListsValue = string == null ? true : new Boolean(string);
            string = bufferedReader.readLine();
            this.staticListsValue = string == null ? false : new Boolean(string);
            string = bufferedReader.readLine();
            if (string == null) {
                this.cacheTimeValue = 300L;
            } else {
                try {
                    this.cacheTimeValue = nf.parse(string).longValue();
                }
                catch (ParseException parseException) {
                    this.cacheTimeValue = 300L;
                }
            }
            this.serverSideValue = new Boolean(bufferedReader.readLine());
            this.maxTicketLifeValue = new Integer(bufferedReader.readLine());
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (ParseException parseException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void updateGuiComponents() {
        if (this.frame == null) {
            this.getEditingFrame();
        } else {
            this.updateFlags();
            this.serverSide.setState(this.serverSideValue);
            this.enableTicketLifeFields(this.serverSideValue);
            this.maxTicketLife.setText(nf.format(this.maxTicketLifeValue));
            this.maxTicketRenewableLife.setText(nf.format(this.maxTicketRenewableLifeValue));
            String string = this.accountExpiryDateValue.getTime() == 0L ? neverString : df.format(this.accountExpiryDateValue);
            this.accountExpiryDate.setText(string);
            this.showLists.setState(this.showListsValue);
            this.staticLists.setState(this.staticListsValue);
            this.enableCacheTimeFields(this.staticListsValue);
            this.cacheTime.setText(new Long(this.cacheTimeValue).toString());
        }
    }

    private void updateFlags() {
        this.disableAccount.setState(this.flags.getFlag(64));
        this.forcePasswordChange.setState(this.flags.getFlag(512));
        this.allowPostdatedTix.setState(!this.flags.getFlag(1));
        this.allowForwardableTix.setState(!this.flags.getFlag(2));
        this.allowRenewableTix.setState(!this.flags.getFlag(8));
        this.allowProxiableTix.setState(!this.flags.getFlag(16));
        this.allowServiceTix.setState(!this.flags.getFlag(4096));
        this.allowTGTAuth.setState(!this.flags.getFlag(4));
        this.allowDupAuth.setState(!this.flags.getFlag(32));
        this.requirePreauth.setState(this.flags.getFlag(128));
        this.requireHWAuth.setState(this.flags.getFlag(256));
    }

    private static final String getString(String string) {
        try {
            String string2 = rb.getString(string);
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource " + string + ", using English.");
            return string;
        }
    }

    public static void main(String[] stringArray) {
        Defaults defaults = new Defaults("SomeFile", Color.white);
        Frame frame = defaults.getEditingFrame();
        defaults.showLists.setSize(new Dimension(18, 22));
        defaults.staticLists.setSize(new Dimension(18, 22));
        frame.setVisible(true);
        System.out.println(defaults.disableAccount.getSize().toString());
        System.out.println(defaults.showLists.getSize().toString());
    }

    private class EditingFrame
    extends Frame {
        public EditingFrame() {
            super(Defaults.getString("Properties"));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 0;
            Label label = new Label(Defaults.getString("Defaults for New Principals"), 1);
            label.setFont(new Font("Dialog", 0, 16));
            gridBagConstraints.insets = new Insets(10, 10, 0, 10);
            this.add((Component)label, gridBagConstraints);
            this.addFlags();
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            this.add((Component)new LineSeparator(), gridBagConstraints);
            this.addTextFields();
            this.add((Component)new LineSeparator(), gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 10, 10, 10);
            label = new Label(Defaults.getString("List Controls"), 1);
            label.setFont(new Font("Dialog", 0, 16));
            this.add((Component)label, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 10, 10, 10);
            this.add((Component)new LineSeparator(), gridBagConstraints);
            this.addListFields();
            this.addButtons();
            this.addWindowListener(new WindowCloseListener());
            this.addHelpMenu();
        }

        private void addFlags() {
            Panel panel = new Panel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(0, 10, 0, 10);
            panel.setLayout(new GridBagLayout());
            this.add((Component)panel, gridBagConstraints);
            Defaults.this.disableAccount = new Checkbox();
            Defaults.this.forcePasswordChange = new Checkbox();
            Defaults.this.allowPostdatedTix = new Checkbox();
            Defaults.this.allowForwardableTix = new Checkbox();
            Defaults.this.allowRenewableTix = new Checkbox();
            Defaults.this.allowProxiableTix = new Checkbox();
            Defaults.this.allowServiceTix = new Checkbox();
            Defaults.this.allowTGTAuth = new Checkbox();
            Defaults.this.allowDupAuth = new Checkbox();
            Defaults.this.requirePreauth = new Checkbox();
            Defaults.this.requireHWAuth = new Checkbox();
            this.addSeperatorPanel(Defaults.getString("Security"), panel);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            this.addFlag(Defaults.this.disableAccount, 64, panel, gridBagConstraints, false);
            this.addFlag(Defaults.this.forcePasswordChange, 512, panel, gridBagConstraints, true);
            this.addSeperatorPanel(Defaults.getString("Ticket"), panel);
            this.addFlag(Defaults.this.allowPostdatedTix, 1, panel, gridBagConstraints, false);
            this.addFlag(Defaults.this.allowForwardableTix, 2, panel, gridBagConstraints, true);
            this.addFlag(Defaults.this.allowRenewableTix, 8, panel, gridBagConstraints, false);
            this.addFlag(Defaults.this.allowProxiableTix, 16, panel, gridBagConstraints, true);
            this.addFlag(Defaults.this.allowServiceTix, 4096, panel, gridBagConstraints, true);
            this.addSeperatorPanel(Defaults.getString("Miscellaneous"), panel);
            this.addFlag(Defaults.this.allowTGTAuth, 4, panel, gridBagConstraints, false);
            this.addFlag(Defaults.this.allowDupAuth, 32, panel, gridBagConstraints, true);
            this.addFlag(Defaults.this.requirePreauth, 128, panel, gridBagConstraints, false);
            this.addFlag(Defaults.this.requireHWAuth, 256, panel, gridBagConstraints, true);
        }

        private void addSeperatorPanel(String string, Panel panel) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(7, 0, 7, 0);
            Panel panel2 = new Panel();
            panel2.setLayout(new GridBagLayout());
            panel.add((Component)panel2, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 0.02;
            gridBagConstraints.weightx = 0.02;
            panel2.add((Component)new LineSeparator(), gridBagConstraints);
            gridBagConstraints.weighty = 0.001;
            gridBagConstraints.weightx = 0.001;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            Label label = new Label(string);
            label.setFont(new Font("Dialog", 2, 12));
            panel2.add((Component)label, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            panel2.add((Component)new LineSeparator(), gridBagConstraints);
        }

        private void addFlag(Checkbox checkbox, int n, Panel panel, GridBagConstraints gridBagConstraints, boolean bl) {
            checkbox.setState(Defaults.this.flags.getFlag(n));
            checkbox.setLabel(Flags.getLabel(n));
            gridBagConstraints.gridwidth = bl ? 0 : 1;
            panel.add((Component)checkbox, gridBagConstraints);
        }

        private void addTextFields() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            Panel panel = new Panel();
            panel.setLayout(new GridBagLayout());
            gridBagConstraints.fill = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 10, 0, 10);
            this.add((Component)panel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            Defaults.this.accountExpiryDateLabel = new Label(Defaults.getString("Account Expiry:"));
            panel.add((Component)Defaults.this.accountExpiryDateLabel, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            Defaults.this.maxTicketLifeLabel = new Label(Defaults.getString("Maximum Ticket Lifetime (seconds):"));
            panel.add((Component)Defaults.this.maxTicketLifeLabel, gridBagConstraints);
            gridBagConstraints.gridy = 3;
            Defaults.this.maxTicketRenewableLifeLabel = new Label(Defaults.getString("Maximum Ticket Renewal (seconds):"));
            panel.add((Component)Defaults.this.maxTicketRenewableLifeLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            Defaults.this.accountExpiryDate = new TextField("1-Jan-70 00:00:00 PM");
            Defaults.this.accountExpiryDate.setColumns(22);
            panel.add((Component)Defaults.this.accountExpiryDate, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            Defaults.this.maxTicketLife = new TextField("144000");
            Defaults.this.maxTicketLife.setColumns(22);
            panel.add((Component)Defaults.this.maxTicketLife, gridBagConstraints);
            gridBagConstraints.gridy = 3;
            Defaults.this.maxTicketRenewableLife = new TextField("144000");
            Defaults.this.maxTicketRenewableLife.setColumns(22);
            panel.add((Component)Defaults.this.maxTicketRenewableLife, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            Defaults.this.dateMoreButton = new Button("...");
            panel.add((Component)Defaults.this.dateMoreButton, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            Defaults.this.lifeMoreButton = new Button("...");
            panel.add((Component)Defaults.this.lifeMoreButton, gridBagConstraints);
            gridBagConstraints.gridy = 3;
            Defaults.this.renewalMoreButton = new Button("...");
            panel.add((Component)Defaults.this.renewalMoreButton, gridBagConstraints);
            Defaults.this.serverSide = new Checkbox();
            Defaults.this.serverSide.setLabel(Defaults.getString("Let the KDC control the ticket lifetime values"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            panel.add((Component)Defaults.this.serverSide, gridBagConstraints);
        }

        private void addListFields() {
            Panel panel = new Panel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 3;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(0, 10, 0, 10);
            panel.setLayout(new GridBagLayout());
            this.add((Component)panel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            Defaults.this.showLists = new Checkbox();
            Defaults.this.showLists.setLabel(Defaults.getString("Show Lists"));
            panel.add((Component)Defaults.this.showLists, gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            Defaults.this.staticLists = new Checkbox();
            Defaults.this.staticLists.setLabel(Defaults.getString("Cache Lists Forever"));
            panel.add((Component)Defaults.this.staticLists, gridBagConstraints);
            gridBagConstraints.anchor = 13;
            Defaults.this.cacheTimeLabel = new Label(Defaults.getString("List Cache Timeout (seconds):"));
            panel.add((Component)Defaults.this.cacheTimeLabel, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            Defaults.this.cacheTime = new TextField("300", 8);
            panel.add((Component)Defaults.this.cacheTime, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            Defaults.this.cacheMoreButton = new Button("...");
            panel.add((Component)Defaults.this.cacheMoreButton, gridBagConstraints);
        }

        private void addButtons() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            Panel panel = new Panel();
            panel.setLayout(new GridBagLayout());
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            this.add((Component)new LineSeparator(), gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 10, 0);
            this.add((Component)panel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            Defaults.this.saveButton = new Button(Defaults.getString("Save"));
            panel.add((Component)Defaults.this.saveButton, gridBagConstraints);
            Defaults.this.applyButton = new Button(Defaults.getString("Apply"));
            panel.add((Component)Defaults.this.applyButton, gridBagConstraints);
            Defaults.this.cancelButton = new Button(Defaults.getString("Cancel"));
            panel.add((Component)Defaults.this.cancelButton, gridBagConstraints);
        }

        private void addHelpMenu() {
            MenuBar menuBar = new MenuBar();
            this.setMenuBar(menuBar);
            Menu menu = new Menu(Defaults.getString("Help"));
            menuBar.setHelpMenu(menu);
            Defaults.this.csHelp = new MenuItem(Defaults.getString("Context-Sensitive Help"));
            menu.add(Defaults.this.csHelp);
        }

        public void close(boolean bl) {
            if (bl) {
                if (!Defaults.this.updateFromGui()) {
                    return;
                }
                Defaults.this.saveToFile();
            }
            this.setVisible(false);
        }

        private class WindowCloseListener
        extends WindowAdapter {
            private WindowCloseListener() {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                EditingFrame.this.close(false);
            }
        }
    }
}

