/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class EncListDialog
extends Dialog {
    private boolean save;
    private int i;
    private Frame parent;
    private Button ok;
    private Button clear;
    private Button cancel;
    private Button help;
    private HelpDialog hd = null;
    private Panel topPanel;
    private Panel bottomPanel;
    private static Toolkit toolkit = Toolkit.getDefaultToolkit();
    private Kadmin kadmin;
    private Checkbox[] cb;
    private Integer[] grp_num;
    private String encList = "";
    private static ResourceBundle rb = ResourceBundle.getBundle("GuiResource");
    private static ResourceBundle hrb = ResourceBundle.getBundle("HelpData");

    public EncListDialog(Frame frame, Color color, Color color2, Kadmin kadmin) {
        super(frame, EncListDialog.getString("SEAM Encryption Type List Helper"), true);
        this.parent = frame;
        this.kadmin = kadmin;
        this.setLayout(new GridBagLayout());
        this.addCheckboxes();
        this.addButtons();
        this.setSize(250, 300);
        this.setResizable(true);
        this.addWindowListener(new DCWindowListener());
    }

    private void addCheckboxes() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        this.topPanel = new Panel();
        this.topPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.topPanel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        String[] stringArray = this.kadmin.getEncList();
        this.cb = new Checkbox[stringArray.length];
        this.grp_num = new Integer[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(" ");
            this.cb[i] = new Checkbox(stringArray2[1]);
            CBListener cBListener = new CBListener();
            this.cb[i].addItemListener(cBListener);
            this.grp_num[i] = new Integer(stringArray2[0]);
            gridBagConstraints.gridy = i;
            this.topPanel.add((Component)this.cb[i], gridBagConstraints);
        }
    }

    private void addButtons() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)new LineSeparator(), gridBagConstraints);
        this.bottomPanel = new Panel();
        this.ok = new Button(EncListDialog.getString("OK"));
        this.clear = new Button(EncListDialog.getString("Clear"));
        this.cancel = new Button(EncListDialog.getString("Cancel"));
        this.help = new Button(EncListDialog.getString("Help"));
        this.bottomPanel.add(this.ok);
        this.bottomPanel.add(this.clear);
        this.bottomPanel.add(this.cancel);
        this.bottomPanel.add(this.help);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.bottomPanel, gridBagConstraints);
        DCButtonListener dCButtonListener = new DCButtonListener();
        this.ok.addActionListener(dCButtonListener);
        this.clear.addActionListener(dCButtonListener);
        this.cancel.addActionListener(dCButtonListener);
        this.help.addActionListener(dCButtonListener);
    }

    private void encListDialogClose(boolean bl) {
        this.save = bl;
        this.setVisible(false);
    }

    public boolean isSaved() {
        return this.save;
    }

    public void setEncTypes(String string) {
        if (string.compareTo("") == 0) {
            return;
        }
        String[] stringArray = string.split(" ");
        block0: for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < this.cb.length; ++j) {
                if (this.cb[j].getLabel().compareTo(stringArray[i]) != 0) continue;
                this.cb[j].setState(true);
                continue block0;
            }
        }
    }

    @Override
    public String toString() {
        for (int i = 0; i < this.cb.length; ++i) {
            if (!this.cb[i].getState()) continue;
            this.encList = this.encList.concat(this.cb[i].getLabel() + " ");
        }
        return this.encList;
    }

    private static final String getString(String string) {
        return EncListDialog.getString(rb, string);
    }

    private static final String getString(ResourceBundle resourceBundle, String string) {
        try {
            String string2 = resourceBundle.getString(string);
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource " + string + ", using English.");
            return string;
        }
    }

    private class DCButtonListener
    implements ActionListener {
        private DCButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == EncListDialog.this.ok) {
                EncListDialog.this.encListDialogClose(true);
            } else if (actionEvent.getSource() == EncListDialog.this.cancel) {
                EncListDialog.this.encListDialogClose(false);
            } else if (actionEvent.getSource() == EncListDialog.this.clear) {
                for (int i = 0; i < EncListDialog.this.cb.length; ++i) {
                    EncListDialog.this.cb[i].setState(false);
                }
            } else if (actionEvent.getSource() == EncListDialog.this.help) {
                if (EncListDialog.this.hd != null) {
                    EncListDialog.this.hd.show();
                } else {
                    EncListDialog.this.hd = new HelpDialog(EncListDialog.this.parent, EncListDialog.getString("Help for Encryption Type Dialog"), false);
                    EncListDialog.this.hd.setVisible(true);
                    EncListDialog.this.hd.setText(EncListDialog.getString(hrb, "EncryptionTypeDialogHelp"));
                }
            }
        }
    }

    private class DCWindowListener
    extends WindowAdapter {
        private DCWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            EncListDialog.this.encListDialogClose(false);
        }
    }

    private class CBListener
    implements ItemListener {
        private CBListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Checkbox checkbox = (Checkbox)itemEvent.getItemSelectable();
            if (itemEvent.getStateChange() == 2) {
                checkbox.setState(false);
            } else if (itemEvent.getStateChange() == 1) {
                for (int i = 0; i < EncListDialog.this.cb.length; ++i) {
                    if (checkbox != EncListDialog.this.cb[i]) continue;
                    for (int j = 0; j < EncListDialog.this.cb.length; ++j) {
                        if (!EncListDialog.this.grp_num[j].equals(EncListDialog.this.grp_num[i])) continue;
                        EncListDialog.this.cb[j].setState(false);
                    }
                    break;
                }
                checkbox.setState(true);
            }
        }
    }
}

