/*
 * Decompiled with CFR 0.152.
 */
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class Principal {
    private static DateFormat df;
    private static NumberFormat nf;
    private static String neverString;
    private static Integer INFINITE_LIFE;
    Flags flags;
    private static ResourceBundle rb;
    String PrName = new String("");
    Date PrExpireTime;
    String Policy;
    Date LastPwChange;
    Date PwExpireTime;
    Integer MaxLife;
    Integer MaxRenew;
    Date ModTime;
    String ModName;
    Date LastSuccess;
    Date LastFailure;
    Integer NumFailures;
    String Comments;
    Integer Kvno;
    Integer Mkvno;
    String PrPasswd = new String("");
    Kadmin Kadmin;
    boolean isNew = true;
    boolean dummy = true;
    boolean newComments = false;
    String EncTypes;

    public Principal() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(1, 1);
        this.PrExpireTime = calendar.getTime();
        this.Policy = new String("");
        this.LastPwChange = new Date(0L);
        this.PwExpireTime = null;
        this.MaxLife = null;
        this.MaxRenew = null;
        this.ModTime = new Date();
        this.ModName = System.getProperty("user.name");
        this.LastSuccess = new Date(0L);
        this.LastFailure = new Date(0L);
        this.NumFailures = new Integer(0);
        this.Comments = new String("");
        this.Kvno = new Integer(0);
        this.Mkvno = new Integer(0);
        this.flags = new Flags();
        this.EncTypes = new String("");
    }

    public Principal(String string) {
        this();
        this.isNew = false;
        this.PrName = string;
        this.PwExpireTime = new Date(0L);
        this.loadPrincipal(string);
    }

    public Principal(Principal principal) {
        this();
        Principal.copyPrincipal(principal, this);
    }

    public Principal(Kadmin kadmin, Defaults defaults) {
        this();
        this.dummy = false;
        this.Kadmin = kadmin;
        this.setDefaults(defaults);
    }

    public Principal(Kadmin kadmin, String string) {
        this();
        this.isNew = false;
        this.dummy = false;
        this.Kadmin = kadmin;
        this.PrName = string;
        this.PwExpireTime = new Date(0L);
        this.loadPrincipal(string);
    }

    public Principal(Kadmin kadmin, Principal principal) {
        this(principal);
        this.dummy = false;
        this.Kadmin = kadmin;
    }

    public void setDefaults(Defaults defaults) {
        this.flags = new Flags(defaults.getFlags().getBits());
        if (!defaults.getServerSide()) {
            this.MaxLife = defaults.getMaxTicketLife();
            this.MaxRenew = defaults.getMaxTicketRenewableLife();
        }
        this.PrExpireTime = defaults.getAccountExpiryDate();
    }

    public static void copyPrincipal(Principal principal, Principal principal2) {
        principal2.PrName = new String("");
        principal2.PrPasswd = new String("");
        principal2.PrExpireTime = new Date(principal.PrExpireTime.getTime());
        principal2.Policy = new String(principal.Policy);
        principal2.EncTypes = new String(principal.EncTypes);
        principal2.LastPwChange = new Date(0L);
        principal2.PwExpireTime = principal.PwExpireTime == null ? null : new Date(principal.PwExpireTime.getTime());
        principal2.MaxLife = new Integer(principal.MaxLife);
        principal2.MaxRenew = new Integer(principal.MaxRenew);
        principal2.ModTime = new Date();
        principal2.ModName = System.getProperty("user.name");
        principal2.LastSuccess = new Date(0L);
        principal2.LastFailure = new Date(0L);
        principal2.NumFailures = new Integer(0);
        principal2.Comments = new String(principal.Comments);
        principal2.Kvno = new Integer(principal.Kvno);
        principal2.Mkvno = new Integer(principal.Mkvno);
        principal2.flags = new Flags(principal.flags.getBits());
    }

    public boolean loadPrincipal(String string) {
        if (this.dummy) {
            return true;
        }
        boolean bl = this.Kadmin.loadPrincipal(string, this);
        return bl;
    }

    public boolean savePrincipal() {
        if (this.dummy) {
            return true;
        }
        if (this.MaxLife == null) {
            this.MaxLife = INFINITE_LIFE;
        }
        if (this.MaxRenew == null) {
            this.MaxRenew = INFINITE_LIFE;
        }
        if (this.isNew) {
            return this.Kadmin.createPrincipal(this);
        }
        return this.Kadmin.savePrincipal(this);
    }

    public boolean setName(String string) {
        this.PrName = string;
        return true;
    }

    public boolean setComments(String string) {
        this.Comments = string;
        this.newComments = true;
        return true;
    }

    public boolean setPolicy(String string) {
        this.Policy = string;
        return true;
    }

    public boolean setPassword(String string) {
        this.PrPasswd = string;
        return true;
    }

    public boolean setEncType(String string) {
        this.EncTypes = string;
        return true;
    }

    public boolean setExpiry(String string) {
        if ((string = string.trim()).equalsIgnoreCase(neverString)) {
            this.PrExpireTime = new Date(0L);
        } else {
            try {
                this.PrExpireTime = df.parse(string);
            }
            catch (ParseException parseException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                return false;
            }
        }
        return true;
    }

    public boolean setPwExpiry(String string) {
        if ((string = string.trim()).equals("")) {
            this.PwExpireTime = null;
        } else if (string.equalsIgnoreCase(neverString)) {
            this.PwExpireTime = new Date(0L);
        } else {
            try {
                this.PwExpireTime = df.parse(string);
            }
            catch (ParseException parseException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                return false;
            }
        }
        return true;
    }

    public String getModTime() {
        if (this.ModTime.getTime() == 0L) {
            return neverString;
        }
        return df.format(this.ModTime);
    }

    public String getEncType() {
        return this.EncTypes;
    }

    public String getExpiry() {
        if (this.PrExpireTime.getTime() == 0L) {
            return neverString;
        }
        return df.format(this.PrExpireTime);
    }

    public String getLastSuccess() {
        if (this.LastSuccess.getTime() == 0L) {
            return neverString;
        }
        return df.format(this.LastSuccess);
    }

    public String getLastFailure() {
        if (this.LastFailure.getTime() == 0L) {
            return neverString;
        }
        return df.format(this.LastFailure);
    }

    public String getLastPwChange() {
        if (this.LastPwChange.getTime() == 0L) {
            return neverString;
        }
        return df.format(this.LastPwChange);
    }

    public String getPwExpireTime() {
        if (this.PwExpireTime == null) {
            return new String("");
        }
        if (this.PwExpireTime.getTime() == 0L) {
            return neverString;
        }
        return df.format(this.PwExpireTime);
    }

    public String getMaxLife() {
        if (this.MaxLife != null) {
            return nf.format(this.MaxLife.longValue());
        }
        return "";
    }

    public String getMaxRenew() {
        if (this.MaxRenew != null) {
            return nf.format(this.MaxRenew.longValue());
        }
        return "";
    }

    public boolean setKvno(String string) {
        try {
            this.Kvno = new Integer(nf.parse(string.trim()).intValue());
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    public boolean setMaxlife(String string) {
        try {
            String string2 = string.trim();
            if (string2.length() == 0) {
                return true;
            }
            this.MaxLife = new Integer(nf.parse(string2).intValue());
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    public boolean setMaxrenew(String string) {
        try {
            String string2 = string.trim();
            if (string2.length() == 0) {
                return true;
            }
            this.MaxRenew = new Integer(nf.parse(string2).intValue());
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    public boolean setFlag(int n) {
        this.flags.toggleFlags(n);
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Principal.getString("Principal Name:") + "  " + this.PrName).append('\n');
        stringBuffer.append(Principal.getString("Account Expires:") + "  " + this.getExpiry()).append('\n');
        stringBuffer.append(Principal.getString("Policy:") + "  " + this.Policy).append('\n');
        stringBuffer.append(Principal.getString("Enc Types:") + "  " + this.EncTypes).append('\n');
        stringBuffer.append(Principal.getString("Comments:") + "  " + this.Comments).append('\n');
        stringBuffer.append(Principal.getString("Key Version:") + "\t" + this.Kvno).append('\t');
        stringBuffer.append(Principal.getString("Password Expires:") + "  " + this.getPwExpireTime()).append('\n');
        stringBuffer.append(Principal.getString("Maximum Lifetime (seconds):") + "\t " + this.getMaxLife()).append('\t');
        stringBuffer.append(Principal.getString("Maximum Renewal (seconds):") + "\t " + this.getMaxRenew()).append('\n');
        stringBuffer.append(Principal.getString("Flags:")).append('\n').append(this.flags.toString());
        return stringBuffer.toString();
    }

    private static final String getString(String string) {
        try {
            String string2 = rb.getString(string);
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource " + string + ", using English.");
            return string;
        }
    }

    static {
        INFINITE_LIFE = new Integer(Integer.MAX_VALUE);
        rb = ResourceBundle.getBundle("GuiResource");
        df = DateFormat.getDateTimeInstance(2, 2);
        nf = NumberFormat.getInstance();
        neverString = Principal.getString("Never");
    }
}

