/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class PrintUtil {
    private static ResourceBundle rb = ResourceBundle.getBundle("GuiResource");
    private static ResourceBundle hrb = ResourceBundle.getBundle("HelpData");

    public static void dump(Frame frame, Object object) {
        String string = object.toString();
        PrintFrame printFrame = new PrintFrame(frame, string);
        printFrame.setVisible(true);
    }

    private static final String getString(String string) {
        return PrintUtil.getString(rb, string);
    }

    private static final String getString(ResourceBundle resourceBundle, String string) {
        try {
            String string2 = resourceBundle.getString(string);
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource " + string + ", using English.");
            return string;
        }
    }

    public static final void reinitialize() {
        PrintFrame.fileName = null;
        PrintFrame.command = null;
    }

    private static class PrintFrame
    extends Frame {
        private String text;
        static TextField command = null;
        static TextField fileName = null;
        private CheckboxGroup options;
        private Checkbox printer;
        private Checkbox file;
        private Frame parent;
        private static String defaultFileName = "/tmp/.SEAM_temp.txt";

        public PrintFrame(Frame frame, String string) {
            super(rb.getString("SEAM Print Helper"));
            this.text = string;
            this.parent = frame;
            this.setLayout(new GridBagLayout());
            this.addLabelsAndFields();
            this.addCheckboxGroup();
            this.addButtons();
            this.setBackground(frame.getBackground());
            this.setForeground(frame.getForeground());
            this.setSize(340, 160);
            this.setResizable(false);
            this.printer.setState(true);
            command.setEditable(true);
            fileName.setEditable(false);
        }

        private void addLabelsAndFields() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            this.add((Component)new Label(PrintUtil.getString("Print Command")), gridBagConstraints);
            if (command == null) {
                command = new TextField("lp", 10);
            }
            gridBagConstraints.gridx = 3;
            this.add((Component)command, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            this.add((Component)new Label(PrintUtil.getString("File Name")), gridBagConstraints);
            if (fileName == null) {
                fileName = new TextField("", 10);
            }
            gridBagConstraints.gridx = 3;
            this.add((Component)fileName, gridBagConstraints);
            StartPrintingListener startPrintingListener = new StartPrintingListener();
            command.addActionListener(startPrintingListener);
            fileName.addActionListener(startPrintingListener);
        }

        private void addCheckboxGroup() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            this.options = new CheckboxGroup();
            this.printer = new Checkbox();
            this.file = new Checkbox();
            this.printer.setCheckboxGroup(this.options);
            this.file.setCheckboxGroup(this.options);
            this.options.setSelectedCheckbox(this.printer);
            this.printer.addItemListener(new PrintSelectedListener());
            this.file.addItemListener(new FileSelectedListener());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.printer, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.add((Component)this.file, gridBagConstraints);
        }

        private void addButtons() {
            Button button = new Button("...");
            Button button2 = new Button(PrintUtil.getString("Print"));
            Button button3 = new Button(PrintUtil.getString("Cancel"));
            Button button4 = new Button(PrintUtil.getString("Help"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 5;
            gridBagConstraints.gridy = 1;
            this.add((Component)button, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 1;
            Panel panel = new Panel();
            gridBagConstraints.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints.gridy = 2;
            this.add((Component)panel, gridBagConstraints);
            panel.setLayout(new GridBagLayout());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            panel.add((Component)button2, gridBagConstraints);
            panel.add((Component)button3, gridBagConstraints);
            panel.add((Component)button4, gridBagConstraints);
            button2.addActionListener(new StartPrintingListener());
            button3.addActionListener(new CancelButtonListener());
            button4.addActionListener(new HelpButtonListener());
            button.addActionListener(new FileMoreButtonListener());
            this.addWindowListener(new WindowCloseListener());
        }

        private void close(boolean bl) {
            if (bl) {
                Checkbox checkbox = this.options.getSelectedCheckbox();
                String string = null;
                try {
                    if (checkbox == this.printer) {
                        string = command.getText().trim();
                        if (string.length() == 0) {
                            return;
                        }
                        this.print(string);
                    } else {
                        string = fileName.getText().trim();
                        if (string.length() == 0) {
                            return;
                        }
                        this.saveToFile(string);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.dispose();
        }

        private void print(String string) throws IOException {
            PrintThread printThread = new PrintThread(string);
            printThread.start();
            this.saveToFile(defaultFileName);
        }

        private void saveToFile(String string) throws IOException {
            PrintWriter printWriter = null;
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
            printWriter.print(this.text);
            printWriter.flush();
            printWriter.close();
        }

        private class WindowCloseListener
        extends WindowAdapter {
            private WindowCloseListener() {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PrintFrame.this.close(false);
            }
        }

        private class PrintThread
        extends Thread {
            private String command;
            private long TIME_OUT = 30000L;

            public PrintThread(String string) {
                this.command = string;
            }

            @Override
            public void run() {
                try {
                    Process process = Runtime.getRuntime().exec(this.command + " " + defaultFileName);
                    try {
                        PrintThread.sleep(this.TIME_OUT);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    process.destroy();
                    PrintThread printThread = this;
                    File file = new File(defaultFileName);
                    file.delete();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private class FileMoreButtonListener
        implements ActionListener {
            private FileMoreButtonListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintFrame.this.options.setSelectedCheckbox(PrintFrame.this.file);
                command.setEditable(false);
                fileName.setEditable(true);
                FileDialog fileDialog = new FileDialog((Frame)PrintFrame.this, PrintUtil.getString("SEAM File Helper"), 1);
                fileDialog.setDirectory(System.getProperty("user.dir"));
                String string = fileName.getText();
                if (string != null) {
                    File file = new File(string);
                    if (file.isDirectory()) {
                        fileDialog.setDirectory(string);
                    } else {
                        fileDialog.setFile(string);
                        String string2 = file.getParent();
                        if (string2 != null) {
                            fileDialog.setDirectory(string2);
                        }
                    }
                }
                fileDialog.setVisible(true);
                if (fileDialog.getFile() != null && fileDialog.getFile().length() > 0) {
                    fileName.setText(fileDialog.getDirectory() + fileDialog.getFile());
                }
            }
        }

        private class HelpButtonListener
        implements ActionListener {
            private HelpButtonListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpDialog helpDialog = new HelpDialog(PrintFrame.this, PrintUtil.getString("Help for Date/Time Helper"), false);
                helpDialog.setVisible(true);
                helpDialog.setText(PrintUtil.getString(hrb, "PrintUtilHelp"));
            }
        }

        private class CancelButtonListener
        implements ActionListener {
            private CancelButtonListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintFrame.this.close(false);
            }
        }

        private class StartPrintingListener
        implements ActionListener {
            private StartPrintingListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintFrame.this.close(true);
            }
        }

        private class FileSelectedListener
        implements ItemListener {
            private FileSelectedListener() {
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                command.setEditable(false);
                fileName.setEditable(true);
            }
        }

        private class PrintSelectedListener
        implements ItemListener {
            private PrintSelectedListener() {
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                command.setEditable(true);
                fileName.setEditable(false);
            }
        }
    }
}

