/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.Serializable;
import java.util.Vector;
import sunsoft.jws.visual.rt.awt.CLIconLabel;
import sunsoft.jws.visual.rt.awt.TextList;
import sunsoft.jws.visual.rt.base.Global;

public class CLChoice
extends CLIconLabel {
    public static final int APPLY = 87001;
    private Vector items = new Vector();
    private int selectedIndex = -1;
    private int itemsVisible = 12;
    private boolean allowSuffix;
    private boolean dragging;
    private int dragX;
    private int dragY;
    private Window menuWindow;
    private int menuWindowX;
    private int menuWindowY;
    private TextList menu;
    private boolean forwarding;

    public CLChoice() {
        this(null, -1, null);
    }

    public CLChoice(String[] stringArray) {
        this(stringArray, 0, null);
    }

    public CLChoice(String[] stringArray, int n) {
        this(stringArray, n, null);
    }

    public CLChoice(String[] stringArray, String string) {
        this(stringArray, string, null);
    }

    public CLChoice(String[] stringArray, int n, Image image) {
        super(null, image);
        if (stringArray == null) {
            super.setText("");
            this.selectedIndex = 0;
        } else {
            this.setItems(stringArray);
            this.select(n);
        }
    }

    public CLChoice(String[] stringArray, String string, Image image) {
        super(null, image);
        if (stringArray == null) {
            super.setText("");
            this.selectedIndex = 0;
        } else {
            this.setItems(stringArray);
            this.select(string);
        }
    }

    public CLChoice(String[] stringArray, String string, Image image, boolean bl) {
        super(null, image);
        this.allowSuffix = bl;
        if (stringArray == null) {
            super.setText("");
            this.selectedIndex = 0;
        } else {
            this.setItems(stringArray);
            this.select(string);
        }
    }

    public void setItemsVisible(int n) {
        if (n <= 0) {
            n = 1;
        }
        this.itemsVisible = n;
    }

    public int getItemsVisible() {
        return this.itemsVisible;
    }

    public void addItem(String string) {
        this.items.addElement(string);
        if (this.menu != null) {
            this.menu.addItem(string);
        }
    }

    public int countItems() {
        return this.items.size();
    }

    public String[] getItems() {
        int n = this.items.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)this.items.elementAt(i);
        }
        return stringArray;
    }

    public void setItems(String[] stringArray) {
        this.items.removeAllElements();
        if (this.menu != null) {
            this.menu.clear();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.addItem(stringArray[i]);
        }
    }

    public String getItem(int n) {
        return (String)this.items.elementAt(n);
    }

    public void removeItem(String string) {
        this.removeItem(this.items.indexOf(string));
    }

    public void removeItem(int n) {
        int n2;
        if (n < 0 || n >= this.items.size()) {
            return;
        }
        this.items.removeElementAt(n);
        if (this.menu != null) {
            this.menu.items().removeElementAt(n);
            this.menu.updateView();
        }
        if ((n2 = this.getSelectedIndex()) != -1) {
            if (n2 == n) {
                this.select(0);
            } else if (n2 > n) {
                this.select(n2 - 1);
            }
        }
    }

    public int getSelectedIndex() {
        if (this.items.size() == 0) {
            return -1;
        }
        return this.selectedIndex;
    }

    public String getSelectedItem() {
        if (this.items.size() == 0) {
            return null;
        }
        return (String)this.items.elementAt(this.selectedIndex);
    }

    public void select(int n) {
        this.select(n, null);
    }

    public void select(String string) {
        if (this.items == null) {
            return;
        }
        int n = -1;
        String string2 = null;
        if (string != null) {
            if (this.allowSuffix) {
                int n2 = this.items.size();
                for (int i = 0; i < n2; ++i) {
                    String string3 = (String)this.items.elementAt(i);
                    if (!string.startsWith(string3)) continue;
                    string2 = string;
                    n = i;
                    break;
                }
            } else {
                n = this.items.indexOf(string);
            }
        }
        this.select(n, string2);
    }

    private void select(int n, String string) {
        if (n >= this.items.size()) {
            n = this.items.size() - 1;
        }
        if (n < 0) {
            n = 0;
        }
        if (n != this.selectedIndex) {
            this.selectedIndex = n;
            if (this.items.size() == 0) {
                super.setText("");
            } else {
                if (string == null) {
                    string = (String)this.items.elementAt(n);
                }
                super.setText(string);
            }
        }
    }

    @Override
    public void setText(String string, boolean bl) {
        super.setText(string, bl);
        this.select(string);
    }

    @Override
    public String getText() {
        return this.getSelectedItem();
    }

    public void setAllowSuffix(boolean bl) {
        this.allowSuffix = bl;
    }

    public boolean getAllowSuffix() {
        return this.allowSuffix;
    }

    @Override
    public boolean mouseDown(Event event) {
        if (this.canvas == null) {
            return false;
        }
        if (event.clickCount == 1 && this.canvas.getSelectedRow() == this.row && this.canvas.startEdit(this.column)) {
            this.showMenu();
            this.dragging = true;
            this.dragX = event.x + this.canvas.columnX(this.column);
            this.dragY = event.y + this.canvas.rowY(this.row);
            return true;
        }
        return false;
    }

    void cancelEdit() {
        if (this.canvas != null) {
            this.hideMenu();
        }
    }

    public boolean handleEvent(Event event) {
        if (this.canvas == null) {
            return false;
        }
        if (event.target == this.menu && event.id == 701) {
            this.dragging = false;
            String string = this.menu.getSelectedItem();
            this.hideMenu();
            this.canvas.postEvent(new Event(this, 87001, string));
        } else if (this.dragging) {
            this.forwardToMenu(event, this.canvas.getEditRow(), this.canvas.getEditColumn());
            if (event.id == 502 && this.dragging && event.x != -1 && event.y != -1) {
                this.dragging = false;
                if (Math.abs(event.x - this.dragX) + Math.abs(event.y - this.dragY) > 4) {
                    this.canvas.cancelEdit();
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private void showMenu() {
        Object object;
        if (this.menu == null) {
            this.menu = this.canvas.choiceMenu;
            this.menuWindow = this.canvas.choiceMenuWindow;
            if (this.menu == null) {
                this.menu = new TextList();
                this.menu.setBackground(this.canvas.getParent().getBackground());
                this.menu.setRelief(10);
                this.menu.setBorderWidth(1);
                this.menu.setMinimumColumns(0);
                this.menu.setMinimumRows(0);
                this.canvas.choiceMenu = this.menu;
                if (Global.isMotif()) {
                    this.menu.hide();
                    this.canvas.add(this.menu);
                } else {
                    this.canvas.choiceMenuWindow = this.menuWindow = new Window(this.findFrame(this.canvas));
                    this.canvas.add(this.menuWindow);
                    this.menuWindow.add("Center", this.menu);
                }
            } else {
                this.menu.clear();
                if (Global.isMotif()) {
                    this.canvas.add(this.menu);
                }
            }
            object = this.items.elements();
            while (object.hasMoreElements()) {
                this.menu.addItem((String)object.nextElement());
            }
        }
        if (Global.isMotif()) {
            object = this.getMenuBounds(this.menu);
            this.menu.reshape(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
            this.menu.select(this.selectedIndex);
            this.menu.validate();
            this.menu.makeVisible(this.selectedIndex);
            this.menu.menuMode(null);
            this.menu.show();
        } else {
            object = this.getWindowMenuBounds(this.menu);
            this.menuWindow.reshape(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
            this.menuWindow.validate();
            this.menu.select(this.selectedIndex);
            this.menu.makeVisible(this.selectedIndex);
            this.menu.menuMode(this);
            this.menuWindow.show();
            this.findFrame(this.canvas).requestFocus();
        }
    }

    private void hideMenu() {
        if (this.menu != null) {
            if (Global.isMotif()) {
                this.menu.reshape(0, 0, 0, 0);
                this.menu.hide();
                if (Global.isMotif()) {
                    this.canvas.remove(this.menu);
                }
                this.menu = null;
            } else {
                this.menuWindow.hide();
                this.menuWindow = null;
                this.menuWindowX = 0;
                this.menuWindowY = 0;
                this.menu = null;
            }
        }
    }

    private synchronized void forwardToMenu(Event event, int n, int n2) {
        Serializable serializable;
        if (this.forwarding) {
            return;
        }
        Point point = new Point(0, 0);
        if (Global.isMotif()) {
            serializable = this.menu.location();
            Point point2 = this.menu.view.location();
            point.x = serializable.x + point2.x;
            point.y = serializable.y + point2.y;
        } else {
            if (event.id != 506) {
                return;
            }
            point.x = this.menuWindowX;
            point.y = this.menuWindowY;
        }
        serializable = new Event(event.target, event.when, event.id, event.x - point.x, event.y - point.y, event.key, event.modifiers, event.arg);
        ((Event)serializable).clickCount = event.clickCount;
        ((Event)serializable).evt = event.evt;
        this.forwarding = true;
        boolean bl = this.menu.view.menuDrag;
        this.menu.view.postEvent((Event)serializable);
        if (this.menu != null) {
            this.menu.view.menuDrag = bl;
        }
        this.forwarding = false;
    }

    private Rectangle getMenuBounds(TextList textList) {
        int n;
        boolean bl;
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        Dimension dimension = textList.preferredSize();
        Dimension dimension2 = this.canvas.size();
        int n2 = this.canvas.columnX(this.column);
        int n3 = this.canvas.rowY(this.row);
        rectangle.x = Math.min(n2, dimension2.width - dimension.width);
        rectangle.x = Math.max(0, rectangle.x);
        rectangle.width = Math.min(dimension.width, dimension2.width - rectangle.x);
        int n4 = Math.min(this.items.size(), this.itemsVisible);
        n4 = Math.max(n4, 1);
        int n5 = textList.lineHeight();
        int n6 = 6;
        int n7 = n4 * n5 + n6;
        int n8 = n3;
        int n9 = dimension2.height - (n3 + this.canvas.rowHeight);
        if (n7 <= n9 || n9 >= n8) {
            bl = true;
            n = n9;
        } else {
            bl = false;
            n = n8;
        }
        n4 = Math.min(n4, (n - n6) / n5);
        rectangle.height = n4 * n5 + n6;
        rectangle.y = bl ? n3 + this.canvas.rowHeight : n3 - rectangle.height;
        return rectangle;
    }

    private Rectangle getWindowMenuBounds(TextList textList) {
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        Point point = this.getFrameOffset(this.canvas);
        Dimension dimension = textList.preferredSize();
        int n = Math.min(this.items.size(), this.itemsVisible);
        n = Math.max(n, 1);
        int n2 = textList.lineHeight();
        int n3 = 6;
        int n4 = n * n2 + n3;
        rectangle.x = point.x + this.canvas.columnX(this.column);
        rectangle.y = point.y + this.canvas.rowY(this.row) + n2;
        rectangle.width = dimension.width;
        rectangle.height = n4;
        rectangle.width = Math.max(rectangle.width, 112);
        rectangle.height = Math.max(rectangle.height, 27);
        Dimension dimension2 = this.canvas.getToolkit().getScreenSize();
        dimension2.height -= 30;
        if (rectangle.x + rectangle.width > dimension2.width) {
            rectangle.x = dimension2.width - rectangle.width;
        }
        if (rectangle.x < 0) {
            rectangle.x = 0;
        }
        if (rectangle.y + rectangle.height > dimension2.height) {
            rectangle.y -= rectangle.height + n2;
        }
        if (rectangle.y < 0) {
            rectangle.y = 0;
        }
        this.menuWindowX = rectangle.x - point.x;
        this.menuWindowY = rectangle.y - point.y;
        return rectangle;
    }

    private Frame findFrame(Component component) {
        while (component != null && !(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    private Point getFrameOffset(Component component) {
        Point point = new Point(0, 0);
        while (component != null) {
            Point point2 = component.location();
            point.x += point2.x;
            point.y += point2.y;
            if (component instanceof Frame) break;
            component = component.getParent();
        }
        return point;
    }
}

