/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import sunsoft.jws.visual.rt.awt.ColumnListCanvas;
import sunsoft.jws.visual.rt.awt.ScrollPanel;

public class ColumnList
extends ScrollPanel {
    static final int HIGHLIGHT = 1;
    ColumnListCanvas canvas = new ColumnListCanvas(this);
    String[] names = null;
    boolean[] keys = null;
    int[] sortColumns = null;
    int validSortColumns = 0;
    boolean[] sortAscend = null;
    public static final int CONFIRM_SELECT = 4863;
    public static final int APPLY_EDIT = 4864;

    public ColumnList() {
        this.add(this.canvas);
        this.setCanvasBackground(Color.white);
    }

    public ColumnList(String[] stringArray, boolean bl, boolean bl2) {
        this();
        this.setHeaders(stringArray);
        this.setSelectable(bl);
        this.setHighlightItems(bl2);
    }

    public void setTextEditable(int n, boolean bl) {
        this.canvas.setTextEditable(n, bl);
    }

    public void setTextEditable(boolean bl) {
        this.canvas.setTextEditable(bl);
    }

    public boolean getTextEditable(int n) {
        return this.canvas.getTextEditable(n);
    }

    public void cancelSelect() {
        this.canvas.cancelSelect();
    }

    public boolean startEdit(int n) {
        return this.canvas.startEdit(n);
    }

    public boolean applyChanges() {
        return this.canvas.applyChanges();
    }

    public void cancelApply() {
        this.canvas.cancelApply();
    }

    public void cancelEdit() {
        this.canvas.cancelEdit();
    }

    public int getEditRow() {
        return this.canvas.getEditRow();
    }

    public int getEditColumn() {
        return this.canvas.getEditColumn();
    }

    public void setCanvasForeground(Color color) {
        this.canvas.setForeground(color);
        this.canvas.repaint();
    }

    public Color getCanvasForeground() {
        return this.canvas.getForeground();
    }

    public void setCanvasBackground(Color color) {
        this.canvas.setBackground(color);
        this.canvas.repaint();
    }

    public Color getCanvasBackground() {
        return this.canvas.getBackground();
    }

    public void setCanvasFont(Font font) {
        this.canvas.setFont(font);
        this.canvas.repaint();
    }

    public Font getCanvasFont() {
        return this.canvas.getFont();
    }

    @Override
    public Dimension preferredSize() {
        Dimension dimension = super.preferredSize();
        dimension.height -= this.hbar.preferredSize().height;
        return dimension;
    }

    public void setVisibleRows(int n) {
        this.setDisplayRows(n);
    }

    public void setDisplayRows(int n) {
        this.canvas.setDisplayRows(n);
    }

    public void setVisibleChars(int n) {
        this.canvas.setVisibleChars(n);
    }

    public void setHeaders(String[] stringArray) {
        String[] stringArray2 = null;
        if (stringArray != null) {
            stringArray2 = new String[stringArray.length];
            this.names = new String[stringArray.length];
            this.keys = new boolean[stringArray.length];
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                this.keys[i] = false;
                int n = stringArray[i].indexOf(61);
                if (n > 0) {
                    this.names[i] = stringArray[i].substring(0, n);
                    if (this.names[i].charAt(0) == '*') {
                        this.keys[i] = true;
                        bl = true;
                        this.names[i] = stringArray[i].substring(1, n);
                    }
                    stringArray2[i] = stringArray[i].substring(n + 1);
                    continue;
                }
                stringArray2[i] = stringArray[i];
                this.names[i] = stringArray[i];
            }
            if (!bl) {
                this.keys = null;
            }
        } else {
            this.keys = null;
        }
        this.canvas.setHeaders(stringArray2);
    }

    public void setSort(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            this.sortColumns = new int[stringArray.length];
            this.sortAscend = new boolean[stringArray.length];
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl;
                String string = null;
                if (stringArray[i].startsWith("+")) {
                    bl = true;
                    string = stringArray[i].substring(1);
                } else if (stringArray[i].startsWith("-")) {
                    string = stringArray[i].substring(1);
                    bl = false;
                } else {
                    bl = true;
                    string = stringArray[i];
                }
                int n2 = this.getNameColumn(string);
                if (n2 == -1) continue;
                this.sortColumns[++n - 1] = n2;
                this.sortAscend[n - 1] = bl;
            }
            this.validSortColumns = n;
        } else {
            this.sortColumns = null;
            this.validSortColumns = 0;
            this.sortAscend = null;
        }
    }

    public void setFormats(String string) {
        int[] nArray = new int[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            nArray[i] = c == 'c' ? 1 : (c == 'r' ? 2 : 0);
        }
        this.canvas.setFormats(nArray);
    }

    public void setSelectable(boolean bl) {
        this.canvas.setSelectable(bl);
    }

    public void setEditable(boolean bl) {
        this.canvas.setEditable(bl);
    }

    public void setHighlightItems(boolean bl) {
        this.canvas.setHighlightItems(bl);
    }

    public void setHighlighted(int n, boolean bl) {
        this.canvas.setHighlighted(n, bl);
    }

    public boolean getHighlighted(int n) {
        return this.canvas.getHighlighted(n);
    }

    public void setShowHeaders(boolean bl) {
        this.canvas.setShowHeaders(bl);
    }

    public void setShowVerticalLines(boolean bl) {
        this.canvas.setShowVerticalLines(bl);
    }

    public void setShowHorizontalLines(boolean bl) {
        this.canvas.setShowHorizontalLines(bl);
    }

    public void setAutoWidth(boolean bl) {
        this.canvas.setAutoWidth(bl);
    }

    public int addItem(Object[] objectArray, boolean bl) {
        int n;
        boolean bl2 = false;
        if (this.keys != null) {
            for (n = 0; n < this.entries(); ++n) {
                if (!this.isEqualTo(objectArray, n)) continue;
                if (this.sortColumns != null && this.validSortColumns > 0) {
                    if (this.getSelectedRow() == n) {
                        bl2 = true;
                    }
                    this.canvas.delItems(n, n);
                    break;
                }
                this.canvas.addItem(objectArray, n);
                if (bl) {
                    this.updateView();
                }
                return n;
            }
        }
        if (this.sortColumns != null && this.validSortColumns > 0) {
            block1: for (n = 0; n < this.entries(); ++n) {
                for (int i = 0; i < this.validSortColumns; ++i) {
                    int n2 = this.sortColumns[i];
                    int n3 = objectArray[n2].toString().compareTo(this.getItem(n, n2).toString());
                    if (!this.sortAscend[i]) {
                        n3 = -n3;
                    }
                    if (n3 < 0) {
                        this.canvas.insertItem(objectArray, n);
                        if (bl2) {
                            this.selectRow(n);
                        }
                        if (bl) {
                            this.updateView();
                        }
                        return n;
                    }
                    if (n3 > 0) continue block1;
                }
            }
        }
        this.canvas.addItem(objectArray);
        if (bl2) {
            this.selectRow(this.entries() - 1);
        }
        if (bl) {
            this.updateView();
        }
        return this.entries() - 1;
    }

    public void addItem(Object[] objectArray) {
        this.addItem(objectArray, true);
    }

    private boolean isEqualTo(Object[] objectArray, int n) {
        for (int i = 0; i < this.getColumns(); ++i) {
            if (!this.keys[i] || ((String)this.getItem(n, i)).equals((String)objectArray[i])) continue;
            return false;
        }
        return true;
    }

    public void addItem(Object[] objectArray, int n) {
        this.canvas.addItem(objectArray, n);
        this.updateView();
    }

    public void insertItem(Object[] objectArray, int n) {
        this.canvas.insertItem(objectArray, n);
        this.updateView();
    }

    public void delItems() {
        this.delItems(true);
    }

    public void delItems(boolean bl) {
        this.canvas.delItems();
        if (bl) {
            this.updateView();
        }
    }

    public void delItems(int n, int n2) {
        this.canvas.delItems(n, n2);
        this.updateView();
    }

    public boolean delItem(Object[] objectArray) {
        if (this.keys != null) {
            for (int i = 0; i < this.entries(); ++i) {
                if (!this.isEqualTo(objectArray, i)) continue;
                this.canvas.delItems(i, i);
                this.updateView();
                return true;
            }
        }
        return false;
    }

    public int selectRow(int n) {
        return this.canvas.selectRow(n);
    }

    public void highlight(int n) {
        this.canvas.selectRow(n);
    }

    public int getSelectedRow() {
        return this.canvas.selectedRow;
    }

    public int getHighlightedRow() {
        return this.canvas.getSelectedRow();
    }

    public Rectangle getListBounds() {
        return this.canvas.bounds();
    }

    public int entries() {
        return this.canvas.records;
    }

    public int getColumns() {
        return this.canvas.columns;
    }

    public String[] getNames() {
        return this.names;
    }

    public int getNameColumn(String string) {
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public Object getItem(int n, int n2) {
        return this.canvas.getItem(n, n2);
    }

    public Object getObject(int n) {
        return this.canvas.getItem(n, this.canvas.columns);
    }

    public int putItem(int n, int n2, Object object) {
        int n3;
        Object[] objectArray;
        Object object2 = this.getItem(n, n2);
        if (!this.canvas.putItem(n, n2, object)) {
            return -1;
        }
        if (object.toString() != null && object.toString().equals(object2.toString())) {
            return n;
        }
        boolean bl = false;
        if (this.getSelectedRow() == n) {
            bl = true;
        }
        if (this.keys != null && this.keys.length > n2 && this.keys[n2]) {
            objectArray = (Object[])this.canvas.labels.elementAt(n);
            for (n3 = 0; n3 < this.entries(); ++n3) {
                if (n3 == n || !this.isEqualTo(objectArray, n3)) continue;
                this.canvas.delItems(n3, n3);
                if (n3 >= n) break;
                --n;
                break;
            }
        }
        if (this.isSortColumn(n2)) {
            objectArray = (Object[])this.canvas.labels.elementAt(n);
            block1: for (n3 = 0; n3 < this.entries(); ++n3) {
                for (int i = 0; i < this.sortColumns.length; ++i) {
                    int n4 = this.sortColumns[i];
                    int n5 = objectArray[n4].toString().compareTo(this.getItem(n3, n4).toString());
                    if (!this.sortAscend[i]) {
                        n5 = -n5;
                    }
                    if (n5 < 0) {
                        if (n3 != n && n3 != n + 1) {
                            this.swapItems(n3, n);
                            n = n3;
                        }
                        if (bl) {
                            this.selectRow(n);
                        }
                        return n;
                    }
                    if (n5 > 0) continue block1;
                }
            }
        }
        if (bl) {
            this.selectRow(n);
        }
        return n;
    }

    private boolean isSortColumn(int n) {
        if (this.sortColumns == null) {
            return false;
        }
        for (int i = 0; i < this.validSortColumns; ++i) {
            if (this.sortColumns[i] != n) continue;
            return true;
        }
        return false;
    }

    public boolean putObject(int n, Object object) {
        return this.canvas.putItem(n, this.canvas.columns, object);
    }

    public boolean swapItems(int n, int n2) {
        return this.canvas.swapItems(n, n2);
    }

    public int getRowY(int n) {
        return this.canvas.getRowY(n);
    }

    public int getRowHeight() {
        return this.canvas.rowHeight;
    }

    public void needsRepaint() {
        this.canvas.repaint();
    }

    public void updateView() {
        this.canvas.repaint();
        this.updateWindow();
    }

    void setHBarValue(int n) {
        this.hbar.setValue(n);
    }

    void setVBarValue(int n) {
        this.vbar.setValue(n);
    }

    public void changeText(String string, int n, int n2) {
        this.canvas.changeText(string, n, n2);
    }
}

