/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import sunsoft.jws.visual.rt.base.Global;

public class EditLine
implements Runnable {
    public static final int REPAINT = 87000;
    public static final int APPLY = 87001;
    public static final int CANCEL = 87002;
    public static final int BACKSPACE_KEY = 8;
    public static final int TAB_KEY = 9;
    public static final int RETURN_KEY = 10;
    public static final int ESCAPE_KEY = 27;
    public static final int DELETE_KEY = 127;
    private Component comp;
    private String text;
    private int textX;
    private int textY;
    private Color fg;
    private Color bg;
    private Font font;
    private FontMetrics metrics;
    private int x;
    private int y;
    private int w;
    private int h;
    private int initWidth;
    private String initText;
    private boolean justStartedEditing;
    private boolean cancelApply;
    private boolean applying;
    private int scrollPos;
    private int cursorPos;
    private int selectPos;
    private boolean dragging;
    private Frame frame;
    private boolean cursorState;
    private boolean paintCursor;
    private Thread cursorThread;
    private long cursorTime;
    private static final long CURSOR_DELAY = 500L;
    private static final int XOFF = 2;
    private static final int MINWIDTH = 12;
    static final int XPAD = 15;
    static final int YPAD = 4;

    public EditLine(Component component, String string, int n, int n2) {
        if (string == null) {
            string = "";
        }
        this.comp = component;
        this.text = string;
        this.textX = n;
        this.textY = n2;
        this.initText = string;
        this.selectPos = 0;
        this.cursorPos = string.length();
        this.scrollPos = 0;
        this.justStartedEditing = true;
        this.cacheDims();
        this.initWidth = this.w;
        this.mouseMove(n, n2);
        component.requestFocus();
        this.cursorThread = new Thread((Runnable)this, "Edit Line Cursor");
        this.cursorThread.setDaemon(true);
        this.cursorTime = System.currentTimeMillis();
        this.cursorState = true;
        this.cursorThread.start();
    }

    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        this.text = string;
        this.selectPos = this.cursorPos = string.length();
        this.scrollPos = 0;
        this.cacheText();
    }

    public String getText() {
        return this.text;
    }

    public void setSelection(int n, int n2) {
        int n3 = this.text.length();
        n = Math.max(0, n);
        n = Math.min(n, n3);
        n2 = Math.max(n, n2);
        n2 = Math.min(n2, n3);
        this.selectPos = n;
        this.cursorPos = n2;
        this.makeVisible(this.cursorPos);
        this.repaint();
    }

    public String getSelection() {
        return this.text.substring(this.selectStart(), this.selectEnd());
    }

    public void setFont(Font font) {
        this.font = font;
        this.cacheDims();
        this.comp.repaint();
    }

    public Font getFont() {
        if (this.font == null) {
            return this.comp.getFont();
        }
        return this.font;
    }

    public void setForeground(Color color) {
        this.fg = color;
    }

    public Color getForeground() {
        if (this.fg == null) {
            return this.comp.getForeground();
        }
        return this.fg;
    }

    public void setBackground(Color color) {
        this.bg = color;
    }

    public Color getBackground() {
        if (this.bg == null) {
            return this.comp.getBackground();
        }
        return this.bg;
    }

    public boolean applyChanges() {
        if (!this.text.equals(this.initText)) {
            this.applying = true;
            this.cancelApply = false;
            this.comp.postEvent(new Event(this, 87001, this.text));
            this.applying = false;
            return !this.cancelApply;
        }
        this.comp.postEvent(new Event(this, 87002, null));
        return true;
    }

    public void cancelApply() {
        this.cancelApply = true;
    }

    private void cacheText() {
        int n = this.text.length();
        if (this.selectPos > n) {
            this.selectPos = n;
        }
        if (this.cursorPos > n) {
            this.cursorPos = n;
        }
        if (this.scrollPos > n) {
            this.scrollPos = 0;
        }
        Rectangle rectangle = this.cacheHorizontal();
        this.makeVisible(this.cursorPos);
        this.repaint(rectangle);
    }

    private void cacheDims() {
        this.metrics = this.comp.getFontMetrics(this.getFont());
        this.cacheHorizontal();
        this.cacheVertical();
    }

    private Rectangle cacheHorizontal() {
        Dimension dimension = this.comp.size();
        int n = this.x;
        int n2 = this.x + this.w;
        this.x = this.textX - 2;
        this.w = this.metrics.stringWidth(this.text) + 15;
        this.w = Math.max(this.w, 12);
        this.w = Math.max(this.w, this.initWidth);
        if (this.w > dimension.width - this.x) {
            this.x = dimension.width - this.w;
            if (this.x < 0) {
                this.x = 0;
                this.w = dimension.width;
            }
        }
        int n3 = this.x;
        int n4 = this.x + this.w;
        if (n3 > n && n4 < n2) {
            return new Rectangle(n, this.y, n2 - n, this.h);
        }
        if (n3 > n) {
            return new Rectangle(n, this.y, n3 - n, this.h);
        }
        if (n4 < n2) {
            return new Rectangle(n4, this.y, n2 - n4, this.h);
        }
        return null;
    }

    private void cacheVertical() {
        Dimension dimension = this.comp.size();
        this.y = this.textY - (this.metrics.getAscent() + 2);
        this.h = this.metrics.getHeight() + 4;
        if (this.h > dimension.height - this.y) {
            this.y = dimension.height - this.h;
            if (this.y < 0) {
                this.y = 0;
                this.h = dimension.height;
            }
        }
    }

    public boolean handleEvent(Event event) {
        if (event.id == 501) {
            if (this.justStartedEditing && event.clickCount == 2) {
                this.justStartedEditing = false;
                this.comp.postEvent(new Event(this, 87002, null));
                return false;
            }
            this.justStartedEditing = false;
        }
        boolean bl = false;
        switch (event.id) {
            case 501: {
                if (!this.inside(event.x, event.y)) break;
                this.mouseDown(event.clickCount, event.x, event.y);
                bl = true;
                break;
            }
            case 506: {
                if (!this.dragging) break;
                this.mouseDrag(event.x, event.y);
                bl = true;
                break;
            }
            case 502: {
                if (!this.dragging) break;
                this.mouseUp(event.x, event.y);
                bl = true;
                break;
            }
            case 1005: {
                this.comp.requestFocus();
            }
            case 1004: {
                this.mouseMove(-1, -1);
                bl = true;
                break;
            }
            case 503: {
                this.mouseMove(event.x, event.y);
                bl = true;
                break;
            }
            case 401: 
            case 403: {
                this.keyPress(event);
            }
            case 402: 
            case 404: {
                bl = true;
            }
        }
        return bl;
    }

    private void mouseDown(int n, int n2, int n3) {
        this.comp.requestFocus();
        switch (n) {
            case 2: {
                this.selectWord(n2);
                break;
            }
            case 3: {
                this.selectLine();
                break;
            }
            default: {
                this.dragging = true;
                this.setCursorX(n2);
            }
        }
    }

    private void mouseDrag(int n, int n2) {
        this.adjustSelection(n);
    }

    private void mouseUp(int n, int n2) {
        this.mouseDrag(n, n2);
        this.dragging = false;
        this.mouseMove(n, n2);
        this.resetTimer();
    }

    private void mouseMove(int n, int n2) {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if (this.inside(n, n2)) {
            if (frame.getCursorType() != 2) {
                frame.setCursor(2);
            }
        } else if (frame.getCursorType() != 0) {
            frame.setCursor(0);
        }
    }

    private void keyPress(Event event) {
        boolean bl = false;
        boolean bl2 = false;
        int n = event.key;
        if (n == 10) {
            this.applyChanges();
            return;
        }
        if (n == 27) {
            this.comp.postEvent(new Event(this, 87002, null));
            return;
        }
        int n2 = this.text.length();
        switch (n) {
            case 1000: {
                if (this.cursorPos == 0) break;
                this.setCursorPos(0);
                bl2 = true;
                break;
            }
            case 1001: {
                if (this.cursorPos == n2) break;
                this.setCursorPos(n2);
                bl2 = true;
                break;
            }
            case 1006: {
                if (this.cursorPos == 0) break;
                this.setCursorPos(this.cursorPos - 1);
                bl2 = true;
                break;
            }
            case 1007: {
                if (this.cursorPos == n2) break;
                this.setCursorPos(this.cursorPos + 1);
                bl2 = true;
                break;
            }
            case 8: {
                if (this.deleteSelection()) {
                    bl = true;
                    break;
                }
                if (this.cursorPos == 0) break;
                this.text = this.text.substring(0, this.cursorPos - 1) + this.text.substring(this.cursorPos);
                --this.cursorPos;
                --this.selectPos;
                bl = true;
                break;
            }
            case 127: {
                if (this.deleteSelection()) {
                    bl = true;
                    break;
                }
                if (this.cursorPos == n2) break;
                this.text = this.text.substring(0, this.cursorPos) + this.text.substring(this.cursorPos + 1);
                bl = true;
                break;
            }
            default: {
                if ((event.modifiers & 0xFFFFFFFE) != 0 || n < 32 || n > 127) break;
                this.deleteSelection();
                this.text = this.text.substring(0, this.cursorPos) + String.valueOf((char)n) + this.text.substring(this.cursorPos);
                ++this.cursorPos;
                ++this.selectPos;
                bl = true;
            }
        }
        if (bl) {
            this.cacheText();
        } else if (bl2) {
            this.repaint();
        }
    }

    private boolean deleteSelection() {
        if (this.selectPos != this.cursorPos) {
            int n = this.selectStart();
            int n2 = this.selectEnd();
            this.text = this.text.substring(0, n) + this.text.substring(n2);
            this.setCursorPos(n);
            return true;
        }
        return false;
    }

    private void selectWord(int n) {
        int n2 = this.getCursorPos(n);
        this.selectPos = this.getWordStart(n2);
        this.cursorPos = this.getWordEnd(n2);
        this.makeVisible(this.cursorPos);
        this.repaint();
    }

    private int getWordStart(int n) {
        int n2;
        boolean bl = false;
        for (n2 = n - 1; n2 >= 0; --n2) {
            char c = this.text.charAt(n2);
            if (bl && Character.isSpace(c)) break;
            if (bl || Character.isSpace(c)) continue;
            bl = true;
        }
        return n2 + 1;
    }

    private int getWordEnd(int n) {
        int n2;
        int n3;
        boolean bl = false;
        int n4 = this.text.length();
        for (n3 = n2 = Math.max(n - 1, 0); n3 < n4; ++n3) {
            char c = this.text.charAt(n3);
            if (bl && !Character.isSpace(c)) break;
            if (bl || !Character.isSpace(c)) continue;
            bl = true;
        }
        return n3;
    }

    private void selectLine() {
        this.selectPos = 0;
        this.cursorPos = this.text.length();
        this.repaint();
    }

    private Frame getFrame() {
        if (this.frame == null) {
            Component component;
            for (component = this.comp; component != null && !(component instanceof Frame); component = component.getParent()) {
            }
            this.frame = (Frame)component;
        }
        return this.frame;
    }

    public Point location() {
        return new Point(this.x, this.y);
    }

    public Dimension size() {
        return new Dimension(this.w, this.h);
    }

    private void setCursorX(int n) {
        this.setCursorPos(this.getCursorPos(n));
        this.repaint();
    }

    private void setCursorPos(int n) {
        this.cursorPos = n;
        this.selectPos = n;
        this.makeVisible(this.cursorPos);
        this.resetTimer();
    }

    private void adjustSelection(int n) {
        int n2 = this.getCursorPos(n);
        if (this.cursorPos != n2) {
            this.cursorPos = n2;
            this.makeVisible(this.cursorPos);
            this.repaint();
        }
    }

    private boolean makeVisible(int n) {
        int n2;
        if (n < this.scrollPos) {
            this.scrollPos = Math.max(n - 6, 0);
            return true;
        }
        if (n > this.scrollPos && (n2 = this.metrics.stringWidth(this.text.substring(this.scrollPos, n))) >= this.w - 3) {
            int n3 = this.scrollPos;
            this.scrollPos = this.getScrollPos(n, this.w - 40);
            return true;
        }
        return false;
    }

    private synchronized void resetTimer() {
        this.cursorState = true;
        this.cursorTime = System.currentTimeMillis();
        this.notify();
    }

    private int getCursorPos(int n) {
        int n2 = this.text.length();
        int n3 = this.metrics.stringWidth(this.text.substring(0, this.scrollPos));
        int n4 = n - this.x - 2 + n3;
        return this.findCursorOffset(n4, this.text, n2 / 2, 0, n2);
    }

    private int findCursorOffset(int n, String string, int n2, int n3, int n4) {
        if (n3 == n4) {
            return n3;
        }
        if (n3 == n4 - 1) {
            int n5;
            int n6 = this.metrics.stringWidth(string.substring(0, n3));
            if (n - n6 < (n5 = this.metrics.stringWidth(string.substring(0, n4))) - n) {
                return n3;
            }
            return n4;
        }
        int n7 = this.metrics.stringWidth(string.substring(0, n2));
        if (n7 > n) {
            return this.findCursorOffset(n, string, n2 - (n2 - n3) / 2, n3, n2);
        }
        return this.findCursorOffset(n, string, n2 + (n4 - n2) / 2, n2, n4);
    }

    private int getScrollPos(int n, int n2) {
        String string = this.text.substring(this.scrollPos);
        int n3 = n - this.scrollPos;
        if (n3 <= 0) {
            return this.scrollPos;
        }
        n = this.findScrollOffset(n2, string, n3, n3 / 2, 0, n3);
        return this.scrollPos + n;
    }

    private int findScrollOffset(int n, String string, int n2, int n3, int n4, int n5) {
        if (n4 == n5) {
            return n4;
        }
        if (n4 == n5 - 1) {
            int n6;
            int n7 = this.metrics.stringWidth(string.substring(n4, n2));
            if (n7 - n < n - (n6 = this.metrics.stringWidth(string.substring(n5, n2)))) {
                return n4;
            }
            return n5;
        }
        int n8 = this.metrics.stringWidth(string.substring(n3, n2));
        if (n8 > n) {
            return this.findScrollOffset(n, string, n2, n3 + (n5 - n3) / 2, n3, n5);
        }
        return this.findScrollOffset(n, string, n2, n3 - (n3 - n4) / 2, n4, n3);
    }

    private boolean inside(int n, int n2) {
        return n >= this.x && n <= this.x + this.w && n2 >= this.y && n2 <= this.y + this.h;
    }

    private int selectStart() {
        return Math.min(this.selectPos, this.cursorPos);
    }

    private int selectEnd() {
        return Math.max(this.selectPos, this.cursorPos);
    }

    public void repaint() {
        this.repaint(null);
    }

    public void repaint(Rectangle rectangle) {
        this.comp.postEvent(new Event(this, 87000, rectangle));
    }

    public synchronized void paint(Graphics graphics) {
        int n;
        int n2;
        graphics = graphics.create();
        graphics.translate(this.x, this.y);
        graphics.setFont(this.getFont());
        if (this.paintCursor) {
            if (this.cursorState) {
                graphics.setColor(this.getForeground());
            } else {
                graphics.setColor(this.getBackground());
            }
            int n3 = this.metrics.stringWidth(this.text.substring(this.scrollPos, this.cursorPos)) + 2;
            graphics.fillRect(n3, 2, 1, this.h - 4);
            this.paintCursor = false;
            return;
        }
        if (this.bg != null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.w, this.h);
        } else {
            graphics.clearRect(0, 0, this.w, this.h);
        }
        graphics.setColor(this.getForeground());
        graphics.drawRect(0, 0, this.w - 1, this.h - 1);
        int n4 = 2;
        int n5 = this.h - 2 - this.metrics.getDescent();
        if (Global.isMotif()) {
            --n5;
        }
        if ((n2 = this.selectStart()) == (n = this.selectEnd())) {
            String string = this.text.substring(this.scrollPos);
            graphics.drawString(string, 2, n5);
            if (this.cursorState) {
                graphics.fillRect(n4 += this.metrics.stringWidth(this.text.substring(this.scrollPos, this.cursorPos)), 2, 1, this.h - 4);
            }
        } else {
            int n6;
            if (n2 > this.scrollPos) {
                graphics.drawString(this.text.substring(this.scrollPos, n2), n4, n5);
                n4 += this.metrics.stringWidth(this.text.substring(this.scrollPos, n2));
            }
            String string = this.text.substring(Math.max(n2, this.scrollPos), n);
            int n7 = this.metrics.stringWidth(string);
            graphics.setColor(new Color(0, 0, 128));
            graphics.fillRect(n4, 2, n7, this.h - 4);
            graphics.setColor(Color.white);
            graphics.drawString(string, n4, n5);
            if (this.cursorState) {
                graphics.setColor(this.getForeground());
            }
            if (this.cursorPos == n) {
                n4 += n7;
            }
            graphics.fillRect(n4, 2, 1, this.h - 4);
            if (this.cursorPos == n2) {
                n4 += n7;
            }
            if (!this.cursorState) {
                graphics.setColor(this.getForeground());
            }
            if (n < (n6 = this.text.length())) {
                graphics.drawString(this.text.substring(n), n4, n5);
            }
        }
    }

    @Override
    public synchronized void run() {
        long l = 500L;
        while (Thread.currentThread() == this.cursorThread) {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.comp.requestFocus();
            if (this.dragging) {
                l = 0L;
                continue;
            }
            long l2 = System.currentTimeMillis() - this.cursorTime;
            if (l2 >= 500L) {
                l = 500L;
                this.cursorState = !this.cursorState;
                this.cursorTime = System.currentTimeMillis();
                this.paintCursor = true;
                this.repaint();
                continue;
            }
            l = 500L - l2;
        }
    }

    public synchronized void destroy() {
        this.cursorThread = null;
        this.notify();
        Frame frame = this.getFrame();
        if (frame != null && frame.getCursorType() != 0) {
            frame.setCursor(0);
        }
    }

    protected void finalize() {
        this.destroy();
    }
}

