/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Hashtable;
import sunsoft.jws.visual.rt.awt.GBConstraints;
import sunsoft.jws.visual.rt.awt.GBLayoutInfo;
import sunsoft.jws.visual.rt.base.Global;

public class GBLayout
implements LayoutManager {
    public int[] columnWidths;
    public int[] rowHeights;
    public double[] columnWeights;
    public double[] rowWeights;
    protected static final int INITGRIDSIZE = 16;
    protected static final int MINSIZE = 1;
    protected static final int PREFERREDSIZE = 2;
    protected static final int TINYSIZE = 3;
    protected Hashtable comptable = new Hashtable();
    protected GBConstraints defaultConstraints = new GBConstraints();
    protected GBLayoutInfo layoutInfo;
    protected int anchor = 10;
    protected int clipAnchor = 18;
    private static boolean layoutDisabled = false;
    private static int disableCount = 0;
    private static Insets windowInsets = new Insets(0, 0, 0, 0);

    public static synchronized void enable() {
        if (--disableCount <= 0) {
            layoutDisabled = false;
        }
    }

    public static synchronized void disable() {
        if (++disableCount > 0) {
            layoutDisabled = true;
        }
    }

    public static synchronized void setWindowInsets(Insets insets) {
        windowInsets = insets == null ? new Insets(0, 0, 0, 0) : (Insets)insets.clone();
    }

    public static synchronized Insets getWindowInsets() {
        return (Insets)windowInsets.clone();
    }

    public void setConstraints(Component component, GBConstraints gBConstraints) {
        GBConstraints gBConstraints2 = (GBConstraints)gBConstraints.clone();
        if (gBConstraints2.insets == null) {
            gBConstraints2.insets = new Insets(0, 0, 0, 0);
        }
        if (gBConstraints2.hardinsets == null) {
            gBConstraints2.hardinsets = new Insets(0, 0, 0, 0);
        }
        this.comptable.put(component, gBConstraints2);
    }

    public void setConstraints(Component component, String string) {
        if (string == null) {
            return;
        }
        this.comptable.put(component, new GBConstraints(string));
    }

    public GBConstraints getConstraints(Component component) {
        GBConstraints gBConstraints = (GBConstraints)this.comptable.get(component);
        if (gBConstraints == null) {
            this.setConstraints(component, this.defaultConstraints);
            gBConstraints = (GBConstraints)this.comptable.get(component);
        }
        return (GBConstraints)gBConstraints.clone();
    }

    protected GBConstraints lookupConstraints(Component component) {
        GBConstraints gBConstraints = (GBConstraints)this.comptable.get(component);
        if (gBConstraints == null) {
            this.setConstraints(component, this.defaultConstraints);
            gBConstraints = (GBConstraints)this.comptable.get(component);
        }
        return gBConstraints;
    }

    public Point getLayoutOrigin() {
        Point point = new Point(0, 0);
        if (this.layoutInfo != null) {
            point.x = this.layoutInfo.startx;
            point.y = this.layoutInfo.starty;
        }
        return point;
    }

    public int[][] getLayoutDimensions() {
        if (this.layoutInfo == null) {
            return new int[2][0];
        }
        int[][] nArrayArray = new int[][]{new int[this.layoutInfo.width], new int[this.layoutInfo.height]};
        System.arraycopy(this.layoutInfo.minWidth, 0, nArrayArray[0], 0, this.layoutInfo.width);
        System.arraycopy(this.layoutInfo.minHeight, 0, nArrayArray[1], 0, this.layoutInfo.height);
        return nArrayArray;
    }

    public int[][] getMinimumLayoutDimensions(Container container) {
        GBLayoutInfo gBLayoutInfo = this.GetLayoutInfo(container, 1);
        int[][] nArrayArray = new int[][]{new int[gBLayoutInfo.width], new int[gBLayoutInfo.height]};
        System.arraycopy(gBLayoutInfo.minWidth, 0, nArrayArray[0], 0, gBLayoutInfo.width);
        System.arraycopy(gBLayoutInfo.minHeight, 0, nArrayArray[1], 0, gBLayoutInfo.height);
        return nArrayArray;
    }

    public int[][] getPreferredLayoutDimensions(Container container) {
        GBLayoutInfo gBLayoutInfo = this.GetLayoutInfo(container, 2);
        int[][] nArrayArray = new int[][]{new int[gBLayoutInfo.width], new int[gBLayoutInfo.height]};
        System.arraycopy(gBLayoutInfo.minWidth, 0, nArrayArray[0], 0, gBLayoutInfo.width);
        System.arraycopy(gBLayoutInfo.minHeight, 0, nArrayArray[1], 0, gBLayoutInfo.height);
        return nArrayArray;
    }

    public double[][] getLayoutWeights() {
        if (this.layoutInfo == null) {
            return new double[2][0];
        }
        double[][] dArrayArray = new double[][]{new double[this.layoutInfo.width], new double[this.layoutInfo.height]};
        System.arraycopy(this.layoutInfo.weightX, 0, dArrayArray[0], 0, this.layoutInfo.width);
        System.arraycopy(this.layoutInfo.weightY, 0, dArrayArray[1], 0, this.layoutInfo.height);
        return dArrayArray;
    }

    public Point location(int n, int n2) {
        int n3;
        Point point = new Point(0, 0);
        if (this.layoutInfo == null) {
            return point;
        }
        int n4 = this.layoutInfo.startx;
        for (n3 = 0; n3 < this.layoutInfo.width && (n4 += this.layoutInfo.minWidth[n3]) <= n; ++n3) {
        }
        point.x = n3;
        n4 = this.layoutInfo.starty;
        for (n3 = 0; n3 < this.layoutInfo.height && (n4 += this.layoutInfo.minHeight[n3]) <= n2; ++n3) {
        }
        point.y = n3;
        return point;
    }

    public void setAnchor(int n) {
        this.anchor = n;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void setClipAnchor(int n) {
        this.clipAnchor = n;
    }

    public int getClipAnchor() {
        return this.clipAnchor;
    }

    private Insets getInsets(Container container) {
        Insets insets = container.insets();
        Insets insets2 = null;
        insets2 = insets != null ? (Insets)insets.clone() : new Insets(0, 0, 0, 0);
        if (container instanceof Window) {
            insets2.top += GBLayout.windowInsets.top;
            insets2.bottom += GBLayout.windowInsets.bottom;
            insets2.left += GBLayout.windowInsets.left;
            insets2.right += GBLayout.windowInsets.right;
        }
        return insets2;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.setConstraints(component, string);
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        GBLayoutInfo gBLayoutInfo = this.GetLayoutInfo(container, 2);
        return this.GetMinSize(container, gBLayoutInfo);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        GBLayoutInfo gBLayoutInfo = this.GetLayoutInfo(container, 1);
        return this.GetMinSize(container, gBLayoutInfo);
    }

    public Dimension tinyLayoutSize(Container container) {
        GBLayoutInfo gBLayoutInfo = this.GetLayoutInfo(container, 3);
        return this.GetMinSize(container, gBLayoutInfo);
    }

    @Override
    public void layoutContainer(Container container) {
        if (!layoutDisabled) {
            this.ArrangeGrid(container, true);
        }
    }

    public void layoutContainerNoReshape(Container container) {
        if (!layoutDisabled) {
            this.ArrangeGrid(container, false);
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected GBLayoutInfo GetLayoutInfo(Container container, int n) {
        double d;
        int n2;
        Object object;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        GBConstraints gBConstraints;
        Component component;
        int n10;
        Component[] componentArray = container.getComponents();
        int n11 = 0;
        int n12 = 0;
        int n13 = -1;
        int n14 = -1;
        int[] nArray = new int[16];
        int[] nArray2 = new int[16];
        for (n10 = 0; n10 < componentArray.length; ++n10) {
            Dimension dimension;
            int n15;
            component = componentArray[n10];
            if (!component.isVisible()) continue;
            gBConstraints = this.lookupConstraints(component);
            n9 = gBConstraints.gridx;
            n8 = gBConstraints.gridy;
            n7 = gBConstraints.gridwidth;
            if (n7 <= 0) {
                n7 = 1;
            }
            if ((n6 = gBConstraints.gridheight) <= 0) {
                n6 = 1;
            }
            if (n9 < 0 && n8 < 0) {
                if (n14 >= 0) {
                    n8 = n14;
                } else if (n13 >= 0) {
                    n9 = n13;
                } else {
                    n8 = 0;
                }
            }
            if (n9 < 0) {
                n5 = 0;
                n15 = n8 + n6;
                nArray = this.ensureCapacity(nArray, n15);
                for (n4 = n8; n4 < n15; ++n4) {
                    n5 = Math.max(n5, nArray[n4]);
                }
                if ((n9 = n5 - n9 - 1) < 0) {
                    n9 = 0;
                }
            } else if (n8 < 0) {
                n3 = 0;
                n15 = n9 + n7;
                nArray2 = this.ensureCapacity(nArray2, n15);
                for (n4 = n9; n4 < n15; ++n4) {
                    n3 = Math.max(n3, nArray2[n4]);
                }
                if ((n8 = n3 - n8 - 1) < 0) {
                    n8 = 0;
                }
            }
            n5 = n9 + n7;
            while (n12 < n5) {
                ++n12;
            }
            n3 = n8 + n6;
            while (n11 < n3) {
                ++n11;
            }
            nArray2 = this.ensureCapacity(nArray2, n5);
            nArray = this.ensureCapacity(nArray, n3);
            for (n4 = n9; n4 < n5; ++n4) {
                nArray2[n4] = n3;
            }
            for (n4 = n8; n4 < n3; ++n4) {
                nArray[n4] = n5;
            }
            if (n == 3) {
                dimension = component instanceof Container ? (((Container)(object = (Container)component)).getLayout() instanceof GBLayout ? ((GBLayout)((Container)object).getLayout()).tinyLayoutSize((Container)object) : component.getMinimumSize()) : component.getMinimumSize();
                gBConstraints.tinyWidth = dimension.width;
                gBConstraints.tinyHeight = dimension.height;
                if (gBConstraints.shrinkx) {
                    gBConstraints.tinyWidth = 0;
                }
                if (gBConstraints.shrinky) {
                    gBConstraints.tinyHeight = 0;
                }
                if (gBConstraints.minsize == null) {
                    dimension = component.getMinimumSize();
                    gBConstraints.minsize = new Dimension(dimension.width, dimension.height);
                }
            } else if (n == 2) {
                dimension = component.getPreferredSize();
                if (dimension.width <= 1 && dimension.height <= 1) {
                    dimension = component.getMinimumSize();
                    if (dimension.width <= 1 && dimension.height <= 1) {
                        dimension = component.getSize();
                    }
                }
                gBConstraints.minsize = new Dimension(dimension.width, dimension.height);
            } else {
                dimension = component.getMinimumSize();
                if (dimension.width <= 1 && dimension.height <= 1) {
                    dimension = component.getPreferredSize();
                    if (dimension.width <= 1 && dimension.height <= 1) {
                        dimension = component.getSize();
                    }
                }
                gBConstraints.minsize = new Dimension(dimension.width, dimension.height);
            }
            if (gBConstraints.gridheight == 0 && gBConstraints.gridwidth == 0) {
                n13 = -1;
                n14 = -1;
            }
            if (gBConstraints.gridheight == 0 && n14 < 0) {
                n13 = n9 + n7;
                continue;
            }
            if (gBConstraints.gridwidth != 0 || n13 >= 0) continue;
            n14 = n8 + n6;
        }
        if (this.columnWidths != null && n12 < this.columnWidths.length) {
            n12 = this.columnWidths.length;
        }
        if (this.rowHeights != null && n11 < this.rowHeights.length) {
            n11 = this.rowHeights.length;
        }
        object = new GBLayoutInfo(n12, n11);
        n13 = -1;
        n14 = -1;
        nArray = new int[n11];
        nArray2 = new int[n12];
        for (n10 = 0; n10 < componentArray.length; ++n10) {
            component = componentArray[n10];
            if (!component.isVisible()) continue;
            gBConstraints = this.lookupConstraints(component);
            n9 = gBConstraints.gridx;
            n8 = gBConstraints.gridy;
            n7 = gBConstraints.gridwidth;
            n6 = gBConstraints.gridheight;
            if (n9 < 0 && n8 < 0) {
                if (n14 >= 0) {
                    n8 = n14;
                } else if (n13 >= 0) {
                    n9 = n13;
                } else {
                    n8 = 0;
                }
            }
            if (n9 < 0) {
                if (n6 <= 0 && (n6 += ((GBLayoutInfo)object).height - n8) < 1) {
                    n6 = 1;
                }
                n5 = 0;
                for (n4 = n8; n4 < n8 + n6; ++n4) {
                    n5 = Math.max(n5, nArray[n4]);
                }
                if ((n9 = n5 - n9 - 1) < 0) {
                    n9 = 0;
                }
            } else if (n8 < 0) {
                if (n7 <= 0 && (n7 += ((GBLayoutInfo)object).width - n9) < 1) {
                    n7 = 1;
                }
                n3 = 0;
                for (n4 = n9; n4 < n9 + n7; ++n4) {
                    n3 = Math.max(n3, nArray2[n4]);
                }
                if ((n8 = n3 - n8 - 1) < 0) {
                    n8 = 0;
                }
            }
            if (n7 <= 0 && (n7 += ((GBLayoutInfo)object).width - n9) < 1) {
                n7 = 1;
            }
            if (n6 <= 0 && (n6 += ((GBLayoutInfo)object).height - n8) < 1) {
                n6 = 1;
            }
            n5 = n9 + n7;
            n3 = n8 + n6;
            for (n4 = n9; n4 < n5; ++n4) {
                nArray2[n4] = n3;
            }
            for (n4 = n8; n4 < n3; ++n4) {
                nArray[n4] = n5;
            }
            if (gBConstraints.gridheight == 0 && gBConstraints.gridwidth == 0) {
                n13 = -1;
                n14 = -1;
            }
            if (gBConstraints.gridheight == 0 && n14 < 0) {
                n13 = n9 + n7;
            } else if (gBConstraints.gridwidth == 0 && n13 < 0) {
                n14 = n8 + n6;
            }
            gBConstraints.tempX = n9;
            gBConstraints.tempY = n8;
            gBConstraints.tempWidth = n7;
            gBConstraints.tempHeight = n6;
        }
        if (this.columnWeights != null) {
            System.arraycopy(this.columnWeights, 0, ((GBLayoutInfo)object).weightX, 0, Math.min(this.columnWeights.length, ((GBLayoutInfo)object).weightX.length));
        }
        if (this.rowWeights != null) {
            System.arraycopy(this.rowWeights, 0, ((GBLayoutInfo)object).weightY, 0, Math.min(this.rowWeights.length, ((GBLayoutInfo)object).weightY.length));
        }
        int n16 = Integer.MAX_VALUE;
        n4 = 1;
        while (n4 != Integer.MAX_VALUE) {
            for (n10 = 0; n10 < componentArray.length; ++n10) {
                double d2;
                double d3;
                double d4;
                component = componentArray[n10];
                if (!component.isVisible()) continue;
                gBConstraints = this.lookupConstraints(component);
                if (gBConstraints.tempWidth == n4) {
                    n5 = gBConstraints.tempX + gBConstraints.tempWidth;
                    d4 = gBConstraints.weightx;
                    for (n2 = gBConstraints.tempX; n2 < n5; ++n2) {
                        d4 -= ((GBLayoutInfo)object).weightX[n2];
                    }
                    if (d4 > 0.0) {
                        d = 0.0;
                        for (n2 = gBConstraints.tempX; n2 < n5; ++n2) {
                            d += ((GBLayoutInfo)object).weightX[n2];
                        }
                        n2 = gBConstraints.tempX;
                        while (d > 0.0 && n2 < n5) {
                            d3 = ((GBLayoutInfo)object).weightX[n2];
                            d2 = d3 * d4 / d;
                            int n17 = n2++;
                            ((GBLayoutInfo)object).weightX[n17] = ((GBLayoutInfo)object).weightX[n17] + d2;
                            d4 -= d2;
                            d -= d3;
                        }
                        int n18 = n5 - 1;
                        ((GBLayoutInfo)object).weightX[n18] = ((GBLayoutInfo)object).weightX[n18] + d4;
                    }
                } else if (gBConstraints.tempWidth > n4 && gBConstraints.tempWidth < n16) {
                    n16 = gBConstraints.tempWidth;
                }
                if (gBConstraints.tempHeight == n4) {
                    n3 = gBConstraints.tempY + gBConstraints.tempHeight;
                    d4 = gBConstraints.weighty;
                    for (n2 = gBConstraints.tempY; n2 < n3; ++n2) {
                        d4 -= ((GBLayoutInfo)object).weightY[n2];
                    }
                    if (!(d4 > 0.0)) continue;
                    d = 0.0;
                    for (n2 = gBConstraints.tempY; n2 < n3; ++n2) {
                        d += ((GBLayoutInfo)object).weightY[n2];
                    }
                    n2 = gBConstraints.tempY;
                    while (d > 0.0 && n2 < n3) {
                        d3 = ((GBLayoutInfo)object).weightY[n2];
                        d2 = d3 * d4 / d;
                        int n19 = n2++;
                        ((GBLayoutInfo)object).weightY[n19] = ((GBLayoutInfo)object).weightY[n19] + d2;
                        d4 -= d2;
                        d -= d3;
                    }
                    int n20 = n3 - 1;
                    ((GBLayoutInfo)object).weightY[n20] = ((GBLayoutInfo)object).weightY[n20] + d4;
                    continue;
                }
                if (gBConstraints.tempHeight <= n4 || gBConstraints.tempHeight >= n16) continue;
                n16 = gBConstraints.tempHeight;
            }
            n4 = n16;
            n16 = Integer.MAX_VALUE;
        }
        if (n == 3) {
            if (this.columnWidths != null) {
                for (n4 = 0; n4 < this.columnWidths.length; ++n4) {
                    if (((GBLayoutInfo)object).weightX[n4] != 0.0) continue;
                    ((GBLayoutInfo)object).minWidth[n4] = this.columnWidths[n4];
                }
            }
            if (this.rowHeights != null) {
                for (n4 = 0; n4 < this.rowHeights.length; ++n4) {
                    if (((GBLayoutInfo)object).weightY[n4] != 0.0) continue;
                    ((GBLayoutInfo)object).minHeight[n4] = this.rowHeights[n4];
                }
            }
        } else {
            if (this.columnWidths != null) {
                System.arraycopy(this.columnWidths, 0, ((GBLayoutInfo)object).minWidth, 0, this.columnWidths.length);
            }
            if (this.rowHeights != null) {
                System.arraycopy(this.rowHeights, 0, ((GBLayoutInfo)object).minHeight, 0, this.rowHeights.length);
            }
        }
        n16 = Integer.MAX_VALUE;
        n4 = 1;
        while (n4 != Integer.MAX_VALUE) {
            for (n10 = 0; n10 < componentArray.length; ++n10) {
                int n21;
                int n22;
                component = componentArray[n10];
                if (!component.isVisible()) continue;
                gBConstraints = this.lookupConstraints(component);
                if (gBConstraints.tempWidth == n4) {
                    n5 = gBConstraints.tempX + gBConstraints.tempWidth;
                    n22 = n == 3 && this.hasWeightX((GBLayoutInfo)object, gBConstraints) ? gBConstraints.tinyWidth + gBConstraints.hardipadx + gBConstraints.hardinsets.left + gBConstraints.hardinsets.right : gBConstraints.minsize.width + gBConstraints.ipadx + gBConstraints.hardipadx + gBConstraints.insets.left + gBConstraints.insets.right + gBConstraints.hardinsets.left + gBConstraints.hardinsets.right;
                    for (n2 = gBConstraints.tempX; n2 < n5; ++n2) {
                        n22 -= ((GBLayoutInfo)object).minWidth[n2];
                    }
                    if (n22 > 0) {
                        d = 0.0;
                        for (n2 = gBConstraints.tempX; n2 < n5; ++n2) {
                            d += ((GBLayoutInfo)object).weightX[n2];
                        }
                        n2 = gBConstraints.tempX;
                        while (d > 0.0 && n2 < n5) {
                            double d5 = ((GBLayoutInfo)object).weightX[n2];
                            n21 = (int)(d5 * (double)n22 / d);
                            int n23 = n2++;
                            ((GBLayoutInfo)object).minWidth[n23] = ((GBLayoutInfo)object).minWidth[n23] + n21;
                            n22 -= n21;
                            d -= d5;
                        }
                        int n24 = n22 / (n5 - gBConstraints.tempX);
                        n2 = gBConstraints.tempX;
                        while (n2 < n5 - 1) {
                            int n25 = n2++;
                            ((GBLayoutInfo)object).minWidth[n25] = ((GBLayoutInfo)object).minWidth[n25] + n24;
                            n22 -= n24;
                        }
                        int n26 = n5 - 1;
                        ((GBLayoutInfo)object).minWidth[n26] = ((GBLayoutInfo)object).minWidth[n26] + n22;
                    }
                } else if (gBConstraints.tempWidth > n4 && gBConstraints.tempWidth < n16) {
                    n16 = gBConstraints.tempWidth;
                }
                if (gBConstraints.tempHeight == n4) {
                    n3 = gBConstraints.tempY + gBConstraints.tempHeight;
                    n22 = n == 3 && this.hasWeightY((GBLayoutInfo)object, gBConstraints) ? gBConstraints.tinyHeight + gBConstraints.hardipady + gBConstraints.hardinsets.top + gBConstraints.hardinsets.bottom : gBConstraints.minsize.height + gBConstraints.ipady + gBConstraints.hardipady + gBConstraints.insets.top + gBConstraints.insets.bottom + gBConstraints.hardinsets.top + gBConstraints.hardinsets.bottom;
                    for (n2 = gBConstraints.tempY; n2 < n3; ++n2) {
                        n22 -= ((GBLayoutInfo)object).minHeight[n2];
                    }
                    if (n22 <= 0) continue;
                    d = 0.0;
                    for (n2 = gBConstraints.tempY; n2 < n3; ++n2) {
                        d += ((GBLayoutInfo)object).weightY[n2];
                    }
                    n2 = gBConstraints.tempY;
                    while (d > 0.0 && n2 < n3) {
                        double d6 = ((GBLayoutInfo)object).weightY[n2];
                        n21 = (int)(d6 * (double)n22 / d);
                        int n27 = n2++;
                        ((GBLayoutInfo)object).minHeight[n27] = ((GBLayoutInfo)object).minHeight[n27] + n21;
                        n22 -= n21;
                        d -= d6;
                    }
                    int n28 = n22 / (n3 - gBConstraints.tempY);
                    n2 = gBConstraints.tempY;
                    while (n2 < n3 - 1) {
                        int n29 = n2++;
                        ((GBLayoutInfo)object).minHeight[n29] = ((GBLayoutInfo)object).minHeight[n29] + n28;
                        n22 -= n28;
                    }
                    int n30 = n3 - 1;
                    ((GBLayoutInfo)object).minHeight[n30] = ((GBLayoutInfo)object).minHeight[n30] + n22;
                    continue;
                }
                if (gBConstraints.tempHeight <= n4 || gBConstraints.tempHeight >= n16) continue;
                n16 = gBConstraints.tempHeight;
            }
            n4 = n16;
            n16 = Integer.MAX_VALUE;
        }
        return object;
    }

    private int[] ensureCapacity(int[] nArray, int n) {
        if (nArray.length < n) {
            int n2 = nArray.length * 2;
            if (n2 == 0) {
                n2 = 1;
            }
            while (n2 < n) {
                n2 *= 2;
            }
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray = nArray2;
        }
        return nArray;
    }

    private boolean hasWeightX(GBLayoutInfo gBLayoutInfo, GBConstraints gBConstraints) {
        int n = gBConstraints.tempX + gBConstraints.tempWidth;
        for (int i = gBConstraints.tempX; i < n; ++i) {
            if (gBLayoutInfo.weightX[i] == 0.0) continue;
            return true;
        }
        return false;
    }

    private boolean hasWeightY(GBLayoutInfo gBLayoutInfo, GBConstraints gBConstraints) {
        int n = gBConstraints.tempY + gBConstraints.tempHeight;
        for (int i = gBConstraints.tempY; i < n; ++i) {
            if (gBLayoutInfo.weightY[i] == 0.0) continue;
            return true;
        }
        return false;
    }

    protected void AdjustForGravity(GBConstraints gBConstraints, Rectangle rectangle) {
        int n;
        int n2;
        Insets insets = (Insets)gBConstraints.insets.clone();
        int n3 = rectangle.width - (insets.left + insets.right + gBConstraints.hardinsets.left + gBConstraints.hardinsets.right);
        int n4 = rectangle.height - (insets.top + insets.bottom + gBConstraints.hardinsets.top + gBConstraints.hardinsets.bottom);
        if (n3 < gBConstraints.tinyWidth) {
            if (gBConstraints.fill == 2 || gBConstraints.fill == 1) {
                n2 = gBConstraints.tinyWidth - n3;
                insets.left -= n2 / 2;
                insets.right -= n2 / 2;
                if (insets.left < 0) {
                    insets.right += insets.left;
                    insets.left = 0;
                }
                if (insets.right < 0) {
                    insets.left += insets.right;
                    insets.right = 0;
                }
            } else {
                switch (gBConstraints.anchor) {
                    case 10: 
                    case 11: 
                    case 15: {
                        n2 = gBConstraints.tinyWidth - n3;
                        insets.left -= n2 / 2;
                        insets.right -= n2 / 2;
                        if (insets.left < 0) {
                            insets.right += insets.left;
                            insets.left = 0;
                        }
                        if (insets.right >= 0) break;
                        insets.left += insets.right;
                        insets.right = 0;
                        break;
                    }
                    case 16: 
                    case 17: 
                    case 18: {
                        n2 = gBConstraints.tinyWidth - n3;
                        insets.right -= n2;
                        if (insets.right >= 0) break;
                        insets.left += insets.right;
                        insets.right = 0;
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 14: {
                        n2 = gBConstraints.tinyWidth - n3;
                        insets.left -= n2;
                        if (insets.left >= 0) break;
                        insets.right += insets.left;
                        insets.left = 0;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(Global.getMsg("sunsoft.jws.visual.rt.awt.GBLayout.illegal__anchor__value.4"));
                    }
                }
            }
        }
        if (n4 < gBConstraints.tinyHeight) {
            if (gBConstraints.fill == 3 || gBConstraints.fill == 1) {
                n = gBConstraints.tinyHeight - n4;
                insets.top -= n / 2;
                insets.bottom -= n / 2;
                if (insets.top < 0) {
                    insets.bottom += insets.top;
                    insets.top = 0;
                }
                if (insets.bottom < 0) {
                    insets.top += insets.bottom;
                    insets.bottom = 0;
                }
            } else {
                switch (gBConstraints.anchor) {
                    case 10: 
                    case 13: 
                    case 17: {
                        n = gBConstraints.tinyHeight - n4;
                        insets.top -= n / 2;
                        insets.bottom -= n / 2;
                        if (insets.top < 0) {
                            insets.bottom += insets.top;
                            insets.top = 0;
                        }
                        if (insets.bottom >= 0) break;
                        insets.top += insets.bottom;
                        insets.bottom = 0;
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 18: {
                        n = gBConstraints.tinyHeight - n4;
                        insets.bottom -= n;
                        if (insets.bottom >= 0) break;
                        insets.top += insets.bottom;
                        insets.bottom = 0;
                        break;
                    }
                    case 14: 
                    case 15: 
                    case 16: {
                        n = gBConstraints.tinyHeight - n4;
                        insets.top -= n;
                        if (insets.top >= 0) break;
                        insets.bottom += insets.top;
                        insets.top = 0;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(Global.getMsg("sunsoft.jws.visual.rt.awt.GBLayout.illegal__anchor__value.4"));
                    }
                }
            }
        }
        rectangle.x += insets.left + gBConstraints.hardinsets.left;
        rectangle.width -= insets.left + insets.right + gBConstraints.hardinsets.left + gBConstraints.hardinsets.right;
        rectangle.y += insets.top + gBConstraints.hardinsets.top;
        rectangle.height -= insets.top + insets.bottom + gBConstraints.hardinsets.top + gBConstraints.hardinsets.bottom;
        n2 = 0;
        if (gBConstraints.fill != 2 && gBConstraints.fill != 1 && rectangle.width > gBConstraints.minsize.width + gBConstraints.ipadx + gBConstraints.hardipadx) {
            n2 = rectangle.width - (gBConstraints.minsize.width + gBConstraints.ipadx + gBConstraints.hardipadx);
            rectangle.width = gBConstraints.minsize.width + gBConstraints.ipadx + gBConstraints.hardipadx;
        }
        n = 0;
        if (gBConstraints.fill != 3 && gBConstraints.fill != 1 && rectangle.height > gBConstraints.minsize.height + gBConstraints.ipady + gBConstraints.hardipady) {
            n = rectangle.height - (gBConstraints.minsize.height + gBConstraints.ipady + gBConstraints.hardipady);
            rectangle.height = gBConstraints.minsize.height + gBConstraints.ipady + gBConstraints.hardipady;
        }
        switch (gBConstraints.anchor) {
            case 10: {
                rectangle.x += n2 / 2;
                rectangle.y += n / 2;
                break;
            }
            case 11: {
                rectangle.x += n2 / 2;
                break;
            }
            case 12: {
                rectangle.x += n2;
                break;
            }
            case 13: {
                rectangle.x += n2;
                rectangle.y += n / 2;
                break;
            }
            case 14: {
                rectangle.x += n2;
                rectangle.y += n;
                break;
            }
            case 15: {
                rectangle.x += n2 / 2;
                rectangle.y += n;
                break;
            }
            case 16: {
                rectangle.y += n;
                break;
            }
            case 17: {
                rectangle.y += n / 2;
                break;
            }
            case 18: {
                break;
            }
            default: {
                throw new IllegalArgumentException(Global.getMsg("sunsoft.jws.visual.rt.awt.GBLayout.illegal__anchor__value.5"));
            }
        }
    }

    protected Dimension GetMinSize(Container container, GBLayoutInfo gBLayoutInfo) {
        int n;
        Dimension dimension = new Dimension();
        Insets insets = this.getInsets(container);
        int n2 = 0;
        for (n = 0; n < gBLayoutInfo.width; ++n) {
            n2 += gBLayoutInfo.minWidth[n];
        }
        dimension.width = n2 + insets.left + insets.right;
        n2 = 0;
        for (n = 0; n < gBLayoutInfo.height; ++n) {
            n2 += gBLayoutInfo.minHeight[n];
        }
        dimension.height = n2 + insets.top + insets.bottom;
        return dimension;
    }

    protected void ArrangeGrid(Container container) {
        this.ArrangeGrid(container, true);
    }

    protected void ArrangeGrid(Container container, boolean bl) {
        int n;
        int n2;
        double d;
        Insets insets = this.getInsets(container);
        Component[] componentArray = container.getComponents();
        Rectangle rectangle = new Rectangle();
        if (!(componentArray.length != 0 || this.columnWidths != null && this.columnWidths.length != 0 || this.rowHeights != null && this.rowHeights.length != 0)) {
            return;
        }
        GBLayoutInfo gBLayoutInfo = this.GetLayoutInfo(container, 2);
        Dimension dimension = this.GetMinSize(container, gBLayoutInfo);
        Dimension dimension2 = container.getSize();
        if (dimension.width > dimension2.width || dimension.height > dimension2.height) {
            gBLayoutInfo = this.GetLayoutInfo(container, 1);
            dimension = this.GetMinSize(container, gBLayoutInfo);
        }
        GBLayoutInfo gBLayoutInfo2 = this.GetLayoutInfo(container, 3);
        this.layoutInfo = gBLayoutInfo;
        rectangle.width = dimension.width;
        rectangle.height = dimension.height;
        int n3 = dimension2.width - rectangle.width;
        if (n3 != 0) {
            d = 0.0;
            for (n2 = 0; n2 < gBLayoutInfo.width; ++n2) {
                d += gBLayoutInfo.weightX[n2];
            }
            if (d > 0.0) {
                for (n2 = 0; n2 < gBLayoutInfo.width; ++n2) {
                    n = (int)((double)n3 * gBLayoutInfo.weightX[n2] / d);
                    int n4 = n2;
                    gBLayoutInfo.minWidth[n4] = gBLayoutInfo.minWidth[n4] + n;
                    rectangle.width += n;
                    if (gBLayoutInfo.minWidth[n2] >= gBLayoutInfo2.minWidth[n2]) continue;
                    rectangle.width += gBLayoutInfo2.minWidth[n2] - gBLayoutInfo.minWidth[n2];
                    gBLayoutInfo.minWidth[n2] = gBLayoutInfo2.minWidth[n2];
                }
            }
            n3 = dimension2.width - rectangle.width;
        } else {
            n3 = 0;
        }
        int n5 = dimension2.height - rectangle.height;
        if (n5 != 0) {
            d = 0.0;
            for (n2 = 0; n2 < gBLayoutInfo.height; ++n2) {
                d += gBLayoutInfo.weightY[n2];
            }
            if (d > 0.0) {
                for (n2 = 0; n2 < gBLayoutInfo.height; ++n2) {
                    n = (int)((double)n5 * gBLayoutInfo.weightY[n2] / d);
                    int n6 = n2;
                    gBLayoutInfo.minHeight[n6] = gBLayoutInfo.minHeight[n6] + n;
                    rectangle.height += n;
                    if (gBLayoutInfo.minHeight[n2] >= gBLayoutInfo2.minHeight[n2]) continue;
                    rectangle.height += gBLayoutInfo2.minHeight[n2] - gBLayoutInfo.minHeight[n2];
                    gBLayoutInfo.minHeight[n2] = gBLayoutInfo2.minHeight[n2];
                }
            }
            n5 = dimension2.height - rectangle.height;
        } else {
            n5 = 0;
        }
        n = this.anchor;
        int n7 = this.anchor;
        if (n3 < 0) {
            n = this.clipAnchor;
        }
        if (n5 < 0) {
            n7 = this.clipAnchor;
        }
        switch (n) {
            case 10: 
            case 11: 
            case 15: {
                gBLayoutInfo.startx = n3 / 2;
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                gBLayoutInfo.startx = 0;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                gBLayoutInfo.startx = n3;
                break;
            }
            default: {
                throw new IllegalArgumentException(Global.getMsg("sunsoft.jws.visual.rt.awt.GBLayout.illegal__anchor__value.6"));
            }
        }
        switch (n7) {
            case 10: 
            case 13: 
            case 17: {
                gBLayoutInfo.starty = n5 / 2;
                break;
            }
            case 11: 
            case 12: 
            case 18: {
                gBLayoutInfo.starty = 0;
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                gBLayoutInfo.starty = n5;
                break;
            }
            default: {
                throw new IllegalArgumentException(Global.getMsg("sunsoft.jws.visual.rt.awt.GBLayout.illegal__anchor__value.7"));
            }
        }
        gBLayoutInfo.startx += insets.left;
        gBLayoutInfo.starty += insets.top;
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!component.isVisible()) continue;
            GBConstraints gBConstraints = this.lookupConstraints(component);
            rectangle.x = gBLayoutInfo.startx;
            for (n2 = 0; n2 < gBConstraints.tempX; ++n2) {
                rectangle.x += gBLayoutInfo.minWidth[n2];
            }
            rectangle.y = gBLayoutInfo.starty;
            for (n2 = 0; n2 < gBConstraints.tempY; ++n2) {
                rectangle.y += gBLayoutInfo.minHeight[n2];
            }
            rectangle.width = 0;
            for (n2 = gBConstraints.tempX; n2 < gBConstraints.tempX + gBConstraints.tempWidth; ++n2) {
                rectangle.width += gBLayoutInfo.minWidth[n2];
            }
            rectangle.height = 0;
            for (n2 = gBConstraints.tempY; n2 < gBConstraints.tempY + gBConstraints.tempHeight; ++n2) {
                rectangle.height += gBLayoutInfo.minHeight[n2];
            }
            this.AdjustForGravity(gBConstraints, rectangle);
            if (rectangle.width <= 0 || rectangle.height <= 0) {
                if (bl) {
                    component.reshape(-1, -1, 0, 0);
                }
                gBConstraints.location = new Point(-1, -1);
                gBConstraints.size = new Dimension(0, 0);
                continue;
            }
            Point point = component.getLocation();
            Dimension dimension3 = component.getSize();
            if (point.x == rectangle.x && point.y == rectangle.y && dimension3.width == rectangle.width && dimension3.height == rectangle.height) continue;
            if (bl) {
                component.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            gBConstraints.location = new Point(rectangle.x, rectangle.y);
            gBConstraints.size = new Dimension(rectangle.width, rectangle.height);
        }
    }
}

