/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.LayoutManager;
import sunsoft.jws.visual.rt.awt.GBConstraints;
import sunsoft.jws.visual.rt.awt.GBContainer;
import sunsoft.jws.visual.rt.awt.GBLayout;
import sunsoft.jws.visual.rt.awt.VJFlowLayout;
import sunsoft.jws.visual.rt.awt.VJPanel;
import sunsoft.jws.visual.rt.base.DesignerAccess;
import sunsoft.jws.visual.rt.base.Global;

public class GBPanel
extends VJPanel {
    private static Class gbclass;
    private boolean runtime = true;
    private GBContainer cntr;
    private GBLayout mgr;

    public GBPanel() {
        this.setLayout(new GBLayout());
    }

    @Override
    public boolean handleEvent(Event event) {
        if (this.cntr != null) {
            return this.cntr.handleEvent(event);
        }
        return super.handleEvent(event);
    }

    public void setRuntime(boolean bl) {
        if (this.runtime == bl) {
            return;
        }
        this.runtime = bl;
        if (this.runtime) {
            this.cntr.setGBPanel(null);
            this.cntr = null;
        } else {
            if (gbclass == null) {
                gbclass = DesignerAccess.getGBPanelClass();
            }
            try {
                this.cntr = (GBContainer)gbclass.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Error(illegalAccessException.toString());
            }
            catch (InstantiationException instantiationException) {
                throw new Error(instantiationException.toString());
            }
            this.cntr.setGBPanel(this);
        }
    }

    public GBContainer getGBContainer() {
        return this.cntr;
    }

    @Override
    public void layout() {
        LayoutManager layoutManager;
        Component component;
        int n;
        boolean bl = false;
        int n2 = this.countComponents();
        GBLayout gBLayout = (GBLayout)this.getLayout();
        for (n = 0; n < n2; ++n) {
            component = this.getComponent(n);
            if (!(component instanceof Container) || !((layoutManager = ((Container)component).getLayout()) instanceof VJFlowLayout)) continue;
            bl = true;
            ((VJFlowLayout)layoutManager).setMinimumWidth(0);
        }
        if (bl) {
            gBLayout.layoutContainerNoReshape(this);
            for (n = 0; n < n2; ++n) {
                component = this.getComponent(n);
                if (!(component instanceof Container) || !((layoutManager = ((Container)component).getLayout()) instanceof VJFlowLayout)) continue;
                GBConstraints gBConstraints = gBLayout.getConstraints(component);
                if (gBConstraints.size == null) continue;
                ((VJFlowLayout)layoutManager).setMinimumWidth(gBConstraints.size.width);
            }
        }
        super.layout();
        if (bl) {
            for (n = 0; n < n2; ++n) {
                component = this.getComponent(n);
                if (!(component instanceof Container) || !((layoutManager = ((Container)component).getLayout()) instanceof VJFlowLayout)) continue;
                ((VJFlowLayout)layoutManager).setMinimumWidth(0);
            }
        }
        if (this.cntr != null) {
            this.cntr.layout();
        }
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (this.cntr != null) {
            this.cntr.setLayout(layoutManager);
        } else {
            super.setLayout(layoutManager);
        }
        this.updateLayout();
    }

    public void setLayoutSuper(LayoutManager layoutManager) {
        super.setLayout(layoutManager);
        this.updateLayout();
    }

    private void updateLayout() {
        LayoutManager layoutManager = this.getLayout();
        this.mgr = layoutManager instanceof GBLayout ? (GBLayout)layoutManager : null;
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        this.doAdd(component);
    }

    private void doAdd(Component component) {
        if (this.cntr != null) {
            this.cntr.add(component);
        }
    }

    @Override
    public void remove(Component component) {
        super.remove(component);
        if (this.cntr != null) {
            this.cntr.remove(component);
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        if (this.cntr != null) {
            this.cntr.removeAll();
        }
    }

    @Override
    public void update(Graphics graphics) {
        if (Global.isWindows()) {
            graphics = this.getGraphics();
        }
        if (this.cntr != null) {
            this.cntr.update(graphics);
        }
        super.update(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        if (Global.isWindows()) {
            graphics = this.getGraphics();
        }
        if (this.cntr != null) {
            this.cntr.paint(graphics);
        }
        super.paint(graphics);
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        if (this.cntr != null) {
            this.cntr.reshape(n, n2, n3, n4);
        }
    }

    public void layoutMode() {
        if (this.cntr != null) {
            this.cntr.layoutMode();
        }
    }

    public void previewMode() {
        if (this.cntr != null) {
            this.cntr.previewMode();
        }
    }

    public void setConstraints(Component component, GBConstraints gBConstraints) {
        if (gBConstraints == null) {
            throw new Error(Global.getMsg("sunsoft.jws.visual.rt.awt.GBPanel.null__constraints"));
        }
        if (this.cntr != null) {
            this.cntr.setConstraints(component, gBConstraints);
        } else if (this.mgr != null) {
            this.mgr.setConstraints(component, gBConstraints);
        }
    }

    public GBConstraints getConstraints(Component component) {
        if (this.cntr != null) {
            return this.cntr.getConstraints(component);
        }
        if (this.mgr != null) {
            return this.mgr.getConstraints(component);
        }
        return null;
    }

    public void setColumnWeights(double[] dArray) {
        if (this.cntr != null) {
            this.cntr.setColumnWeights(dArray);
        } else if (this.mgr != null) {
            this.mgr.columnWeights = dArray;
        }
    }

    public void setRowWeights(double[] dArray) {
        if (this.cntr != null) {
            this.cntr.setRowWeights(dArray);
        } else if (this.mgr != null) {
            this.mgr.rowWeights = dArray;
        }
    }

    public double[] getColumnWeights() {
        if (this.cntr != null) {
            return this.cntr.getColumnWeights();
        }
        if (this.mgr != null) {
            return this.mgr.columnWeights;
        }
        return null;
    }

    public double[] getRowWeights() {
        if (this.cntr != null) {
            return this.cntr.getRowWeights();
        }
        if (this.mgr != null) {
            return this.mgr.rowWeights;
        }
        return null;
    }

    public void setColumnWidths(int[] nArray) {
        if (this.cntr != null) {
            this.cntr.setColumnWidths(nArray);
        } else if (this.mgr != null) {
            this.mgr.columnWidths = nArray;
        }
    }

    public void setRowHeights(int[] nArray) {
        if (this.cntr != null) {
            this.cntr.setRowHeights(nArray);
        } else if (this.mgr != null) {
            this.mgr.rowHeights = nArray;
        }
    }

    public int[] getColumnWidths() {
        if (this.cntr != null) {
            return this.cntr.getColumnWidths();
        }
        if (this.mgr != null) {
            return this.mgr.columnWidths;
        }
        return null;
    }

    public int[] getRowHeights() {
        if (this.cntr != null) {
            return this.cntr.getRowHeights();
        }
        if (this.mgr != null) {
            return this.mgr.rowHeights;
        }
        return null;
    }
}

