/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import sunsoft.jws.visual.rt.awt.CheckerboardFilter;
import sunsoft.jws.visual.rt.awt.TransWorkAroundFilter;
import sunsoft.jws.visual.rt.base.DesignerAccess;
import sunsoft.jws.visual.rt.base.Global;

public class ImageLabel
extends Canvas {
    protected Image origImg;
    protected Image upImg;
    protected Image disImg;
    protected int padWidth = 0;
    protected int defaultWidth;
    protected int defaultHeight;
    protected int imgWidth = -1;
    protected int imgHeight = -1;

    public ImageLabel(Image image) {
        this(image, 20, 20);
    }

    public ImageLabel(Image image, int n, int n2) {
        this.origImg = image;
        this.upImg = null;
        this.disImg = null;
        this.defaultWidth = n;
        this.defaultHeight = n2;
    }

    public void setPadWidth(int n) {
        this.padWidth = n;
        this.repaint();
    }

    public int getPadWidth() {
        return this.padWidth;
    }

    public void setDefaultWidth(int n) {
        if (n <= 0) {
            return;
        }
        this.defaultWidth = n;
    }

    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public void setDefaultHeight(int n) {
        if (n <= 0) {
            return;
        }
        this.defaultHeight = n;
    }

    public int getDefaultHeight() {
        return this.defaultHeight;
    }

    private void setUpImages() {
        RGBImageFilter rGBImageFilter;
        if (this.origImg != null && this.upImg == null) {
            this.disImg = null;
            this.imgWidth = -1;
            this.imgHeight = -1;
            if (this.getBackground() != null) {
                this.upImg = this.origImg;
                if (Global.isWindows95() && Global.javaVersion() == 1.0) {
                    rGBImageFilter = new TransWorkAroundFilter(this.getBackground());
                    this.upImg = this.createImage(new FilteredImageSource(this.upImg.getSource(), rGBImageFilter));
                }
                this.prepareImage(this.upImg, this);
                this.imgWidth = this.upImg.getWidth(this);
                this.imgHeight = this.upImg.getHeight(this);
            }
        } else {
            this.imgWidth = this.defaultWidth;
            this.imgHeight = this.defaultHeight;
        }
        if (this.origImg != null && this.disImg == null && this.getBackground() != null) {
            rGBImageFilter = new CheckerboardFilter(this.getBackground());
            this.disImg = this.createImage(new FilteredImageSource(this.origImg.getSource(), rGBImageFilter));
        }
    }

    public void setImage(Image image) {
        this.origImg = image;
        this.upImg = null;
        this.disImg = null;
        this.setUpImages();
        this.repaint();
    }

    public Image getImage() {
        return this.origImg;
    }

    @Override
    public Dimension minimumSize() {
        if (this.upImg != null) {
            if (this.imgWidth == -1 || this.imgHeight == -1) {
                this.imgWidth = this.upImg.getWidth(this);
                this.imgHeight = this.upImg.getHeight(this);
            }
            if (this.imgWidth == -1 || this.imgHeight == -1) {
                return new Dimension(this.defaultWidth + this.padWidth * 2, this.defaultHeight + this.padWidth * 2);
            }
            return new Dimension(this.imgWidth + this.padWidth * 2, this.imgHeight + this.padWidth * 2);
        }
        return new Dimension(20, 20);
    }

    @Override
    public Dimension preferredSize() {
        return this.minimumSize();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.upImg != null) {
            this.upImg = null;
            this.disImg = null;
            this.setUpImages();
        }
    }

    protected void updateWindow(Component component) {
        while (component != null) {
            component.invalidate();
            if (component instanceof Window) {
                component.validate();
                break;
            }
            component = component.getParent();
        }
    }

    protected void updateSize(int n, int n2) {
        if (n >= 0 && n2 >= 0) {
            Dimension dimension = this.size();
            if (dimension.width != n + this.padWidth * 2 || dimension.height != n2 + this.padWidth * 2) {
                this.resize(n + this.padWidth * 2, n2 + this.padWidth * 2);
                this.updateWindow(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Graphics graphics) {
        if (Global.isWindows()) {
            graphics = this.getGraphics();
        }
        Object object = DesignerAccess.mutex;
        synchronized (object) {
            graphics.setColor(this.getBackground());
            Dimension dimension = this.size();
            if (this.upImg != null && this.imgWidth >= 0 && this.imgHeight >= 0) {
                int n = (dimension.width - this.imgWidth) / 2;
                int n2 = (dimension.height - this.imgHeight) / 2;
                if (n > 0) {
                    graphics.fillRect(0, 0, n, dimension.height);
                }
                if (n2 > 0) {
                    graphics.fillRect(0, 0, dimension.width, n2);
                }
                if (dimension.width > this.imgWidth) {
                    graphics.fillRect(n + this.imgWidth, 0, dimension.width - (n + this.imgWidth), dimension.height);
                }
                if (dimension.height > this.imgHeight) {
                    graphics.fillRect(0, n2 + this.imgHeight, dimension.width, dimension.height - (n2 + this.imgHeight));
                }
            } else {
                graphics.fillRect(0, 0, dimension.width, dimension.height);
            }
            graphics.setColor(this.getForeground());
        }
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        if (Global.isWindows()) {
            graphics = this.getGraphics();
        }
        Object object = DesignerAccess.mutex;
        synchronized (object) {
            Dimension dimension = this.size();
            if (this.upImg != null && this.imgWidth >= 0 && this.imgHeight >= 0) {
                Image image = this.isEnabled() ? this.upImg : this.disImg;
                int n = (dimension.width - this.imgWidth) / 2;
                int n2 = (dimension.height - this.imgHeight) / 2;
                graphics.drawImage(image, n, n2, this.getBackground(), this);
            } else {
                graphics.setColor(this.getForeground());
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            }
        }
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (image == this.upImg && (n & 0x40) == 0) {
            boolean bl = false;
            if ((n & 1) != 0) {
                this.imgWidth = n4;
                bl = true;
            }
            if ((n & 2) != 0) {
                this.imgHeight = n5;
                bl = true;
            }
            if (bl && this.imgWidth >= 0 && this.imgHeight >= 0) {
                this.updateSize(this.imgWidth, this.imgHeight);
                this.repaint();
            }
        }
        return super.imageUpdate(image, n, n2, n3, n4, n5);
    }

    @Override
    public void enable() {
        if (!this.isEnabled()) {
            super.enable();
            this.repaint();
        }
    }

    @Override
    public void disable() {
        if (this.isEnabled()) {
            super.disable();
            this.repaint();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setUpImages();
    }
}

