/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import sunsoft.jws.visual.rt.base.Global;

public class KeyField
extends Canvas {
    private static int ipadx = 20;
    private static int ipady = 14;
    private int key;
    private FontMetrics fontMetrics;
    private boolean hasFocus;

    @Override
    public void addNotify() {
        super.addNotify();
        this.fontMetrics = this.getFontMetrics(this.getFont());
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.fontMetrics = null;
    }

    @Override
    public Dimension minimumSize() {
        Dimension dimension = new Dimension(0, 0);
        if (this.fontMetrics != null) {
            dimension.width = this.fontMetrics.stringWidth("Carriage Return") + ipadx;
            dimension.height = this.fontMetrics.getMaxAscent() + ipady;
        }
        return dimension;
    }

    @Override
    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public void setKey(int n) {
        this.key = n;
        this.repaint();
    }

    public int getKey() {
        return this.key;
    }

    private String getKeyString() {
        String string;
        switch (this.key) {
            case 0: {
                string = "null";
                break;
            }
            case 10: {
                string = "Line Feed";
                break;
            }
            case 9: {
                string = "Tab";
                break;
            }
            case 12: {
                string = "Form Feed";
                break;
            }
            case 13: {
                string = "Carriage Return";
                break;
            }
            case 8: {
                string = "Back Space";
                break;
            }
            case 32: {
                string = "Space";
                break;
            }
            case 27: {
                string = "Esc";
                break;
            }
            case 127: {
                string = "Delete";
                break;
            }
            case 1025: {
                string = "Insert";
                break;
            }
            case 1022: {
                string = "Caps Lock";
                break;
            }
            case 1023: {
                string = "Num Lock";
                break;
            }
            case 1024: {
                string = "Pause";
                break;
            }
            case 1020: {
                string = "Print Screen";
                break;
            }
            case 1021: {
                string = "Scroll Lock";
                break;
            }
            case 1000: {
                string = "Home";
                break;
            }
            case 1001: {
                string = "End";
                break;
            }
            case 1002: {
                string = "Page Up";
                break;
            }
            case 1003: {
                string = "Page Down";
                break;
            }
            case 1004: {
                string = "Up";
                break;
            }
            case 1005: {
                string = "Down";
                break;
            }
            case 1006: {
                string = "Left";
                break;
            }
            case 1007: {
                string = "Right";
                break;
            }
            case 1008: {
                string = "F1";
                break;
            }
            case 1009: {
                string = "F2";
                break;
            }
            case 1010: {
                string = "F3";
                break;
            }
            case 1011: {
                string = "F4";
                break;
            }
            case 1012: {
                string = "F5";
                break;
            }
            case 1013: {
                string = "F6";
                break;
            }
            case 1014: {
                string = "F7";
                break;
            }
            case 1015: {
                string = "F8";
                break;
            }
            case 1016: {
                string = "F9";
                break;
            }
            case 1017: {
                string = "F10";
                break;
            }
            case 1018: {
                string = "F11";
                break;
            }
            case 1019: {
                string = "F12";
                break;
            }
            default: {
                string = this.key >= 32 ? String.valueOf((char)this.key) : "^" + String.valueOf((char)(this.key + 65 - 1));
            }
        }
        return string;
    }

    @Override
    public void paint(Graphics graphics) {
        if (Global.isWindows()) {
            graphics = this.getGraphics();
        }
        Dimension dimension = this.size();
        String string = this.getKeyString();
        int n = (dimension.width - this.fontMetrics.stringWidth(string)) / 2;
        int n2 = (dimension.height + this.fontMetrics.getMaxAscent()) / 2 - 1;
        if (this.isEnabled()) {
            graphics.setColor(this.getForeground());
        } else {
            graphics.setColor(this.getBackground().darker());
        }
        graphics.setFont(this.getFont());
        graphics.drawString(string, n, n2);
        graphics.setColor(this.getBackground());
        graphics.draw3DRect(1, 1, dimension.width - 3, dimension.height - 3, false);
        graphics.draw3DRect(2, 2, dimension.width - 5, dimension.height - 5, false);
        if (this.hasFocus) {
            graphics.setColor(this.getForeground());
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    @Override
    public boolean handleEvent(Event event) {
        if (event.id == 1004) {
            if (!this.hasFocus) {
                this.hasFocus = true;
                this.repaint();
            }
        } else if (event.id == 1005) {
            if (this.hasFocus) {
                this.hasFocus = false;
                this.repaint();
            }
        } else {
            return super.handleEvent(event);
        }
        return false;
    }

    @Override
    public boolean mouseDown(Event event, int n, int n2) {
        if (!this.hasFocus) {
            this.requestFocus();
        }
        return false;
    }

    @Override
    public boolean keyDown(Event event, int n) {
        this.setKey(n);
        return false;
    }
}

