/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;
import sunsoft.jws.visual.rt.base.Global;

public class MultiLineLabel
extends Canvas {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected String label;
    protected Vector lines;
    protected int num_lines;
    protected int maxChars;
    protected int margin_width;
    protected int margin_height;
    protected int line_height;
    protected int line_ascent;
    protected int[] line_widths;
    protected int max_width;
    protected int alignment = 0;

    protected void newLabel(String string) {
        if (string == null) {
            string = "";
        }
        this.label = string;
        this.lines = new Vector();
        int n = string.length();
        int n2 = 0;
        while (n2 != -1 && n2 < n) {
            int n3;
            String string2;
            int n4 = string.indexOf("\n", n2);
            if (n4 == -1) {
                string2 = string.substring(n2);
                n2 = -1;
            } else {
                string2 = string.substring(n2, n4);
                n2 = n4 + 1;
            }
            if (this.maxChars == -1 || string2.length() <= this.maxChars) {
                this.lines.addElement(string2);
                continue;
            }
            while (string2.length() > this.maxChars && ((n3 = string2.lastIndexOf(32, this.maxChars)) != -1 || (n3 = string2.indexOf(32)) != -1)) {
                this.lines.addElement(string2.substring(0, n3));
                string2 = string2.substring(n3 + 1);
            }
            this.lines.addElement(string2);
        }
        this.num_lines = this.lines.size();
        this.line_widths = new int[this.num_lines];
    }

    protected void measure() {
        if (this.getFont() == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return;
        }
        this.line_height = fontMetrics.getHeight();
        this.line_ascent = fontMetrics.getAscent();
        this.max_width = 0;
        for (int i = 0; i < this.num_lines; ++i) {
            this.line_widths[i] = fontMetrics.stringWidth((String)this.lines.elementAt(i));
            if (this.line_widths[i] <= this.max_width) continue;
            this.max_width = this.line_widths[i];
        }
        Dimension dimension = this.preferredSize();
        this.setSize(dimension);
    }

    public MultiLineLabel(String string, int n, int n2, int n3, int n4) {
        this.maxChars = n;
        this.newLabel(string);
        this.margin_width = n2;
        this.margin_height = n3;
        this.alignment = n4;
    }

    public MultiLineLabel(String string, int n, int n2, int n3) {
        this(string, n, n2, n3, 0);
    }

    public MultiLineLabel(String string, int n, int n2) {
        this(string, n, 10, 10, n2);
    }

    public MultiLineLabel(String string, int n) {
        this(string, n, 10, 10, 0);
    }

    public MultiLineLabel(String string) {
        this(string, -1, 10, 10, 0);
    }

    public MultiLineLabel() {
        this("MultiLineLabel");
    }

    public void setLabel(String string) {
        this.newLabel(string);
        this.measure();
        this.repaint();
    }

    public String getLabel() {
        return this.label;
    }

    public void setMaxColumns(int n) {
        if (n < 0) {
            n = -1;
        }
        this.maxChars = n;
        this.newLabel(this.label);
        this.measure();
        this.repaint();
    }

    public int getMaxColumns() {
        return this.maxChars;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.measure();
        this.repaint();
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public void setAlignment(int n) {
        this.alignment = n;
        this.repaint();
    }

    public void setMarginWidth(int n) {
        this.margin_width = n;
        this.repaint();
    }

    public void setMarginHeight(int n) {
        this.margin_height = n;
        this.repaint();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getMarginWidth() {
        return this.margin_width;
    }

    public int getMarginHeight() {
        return this.margin_height;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.measure();
    }

    @Override
    public Dimension preferredSize() {
        return new Dimension(this.max_width + 2 * this.margin_width, this.num_lines * this.line_height + 2 * this.margin_height);
    }

    @Override
    public Dimension minimumSize() {
        return new Dimension(this.max_width, this.num_lines * this.line_height);
    }

    @Override
    public void paint(Graphics graphics) {
        if (Global.isWindows()) {
            graphics = this.getGraphics();
        }
        Dimension dimension = this.size();
        int n = Math.max((dimension.width - this.max_width) / 2, 0);
        graphics.setColor(this.getForeground());
        int n2 = this.line_ascent + (dimension.height - this.num_lines * this.line_height) / 2;
        int n3 = 0;
        while (n3 < this.num_lines) {
            int n4;
            switch (this.alignment) {
                case 0: {
                    n4 = n;
                    break;
                }
                default: {
                    n4 = (dimension.width - this.line_widths[n3]) / 2;
                    break;
                }
                case 2: {
                    n4 = dimension.width - n - this.line_widths[n3];
                }
            }
            graphics.drawString(((String)this.lines.elementAt(n3)).trim(), n4, n2);
            ++n3;
            n2 += this.line_height;
        }
    }
}

