/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import sunsoft.jws.visual.rt.base.Global;

public class StatusBar
extends Canvas
implements Runnable {
    private String text;
    private long wakeupTime = 0L;
    private long timeout = 7000L;

    public StatusBar(String string) {
        this.setFont(new Font("Sansserif", 1, 14));
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    public StatusBar() {
        this("");
    }

    public synchronized void setTimeout(long l) {
        this.timeout = l;
        this.resetTimer(true);
    }

    public void setText(String string) {
        this.setText(string, true);
    }

    public void setText(String string, boolean bl) {
        if (!(string == this.text || this.text != null && this.text.equals(string))) {
            this.text = string;
            this.repaint();
        }
        this.resetTimer(bl);
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void paint(Graphics graphics) {
        if (Global.isWindows()) {
            graphics = this.getGraphics();
        }
        Dimension dimension = this.size();
        graphics.setColor(this.getBackground());
        if (Global.isWindows()) {
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        Global.util.draw3DRect(graphics, 0, 0, dimension.width - 1, dimension.height - 1, 7, 1);
        if (this.text != null) {
            graphics.setColor(this.getForeground());
            graphics.setFont(this.getFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.drawString(this.text, 5, fontMetrics.getAscent() + 3);
        }
    }

    @Override
    public Dimension minimumSize() {
        Graphics graphics = this.getGraphics();
        int n = 10;
        int n2 = 6;
        if (graphics != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (this.text != null) {
                n += fontMetrics.stringWidth(this.text);
            }
            n2 += fontMetrics.getHeight();
        }
        return new Dimension(n, n2);
    }

    @Override
    public Dimension preferredSize() {
        return this.minimumSize();
    }

    @Override
    public synchronized void run() {
        long l = System.currentTimeMillis();
        while (true) {
            try {
                if (this.wakeupTime == 0L) {
                    this.wait();
                } else {
                    this.wait(this.wakeupTime - l);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l = System.currentTimeMillis();
            if (this.wakeupTime == 0L || this.wakeupTime >= l) continue;
            this.text = null;
            this.repaint();
            this.wakeupTime = 0L;
        }
    }

    private synchronized void resetTimer(boolean bl) {
        if (this.timeout > 0L && bl && this.text != null && !this.text.equals("")) {
            this.wakeupTime = System.currentTimeMillis() + this.timeout;
            this.notify();
        } else {
            this.wakeupTime = 0L;
        }
    }
}

