/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.util.Enumeration;
import sunsoft.jws.visual.rt.awt.CardPanel;
import sunsoft.jws.visual.rt.base.Global;

public class TabbedFolder
extends CardPanel {
    public static final int CONFIRM_SWITCH = 4862;
    private static final int bd = 2;
    private static final double BFACTOR = 0.8;
    private static final double DFACTOR = 0.7;
    private static final int tabipadx = 14;
    private static final int tabipady = 14;
    private static final int comppadx = 20;
    private static final int comppady = 14;
    private static final Insets folderInsets = new Insets(6, 6, 6, 6);
    private Image buffer;
    private int[] tabx;
    private String[] tabtext;
    private int tabW;
    private int tabH;
    private boolean cancelSwitch = false;

    public TabbedFolder() {
    }

    public TabbedFolder(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            super.addTab(stringArray[i]);
        }
    }

    @Override
    protected Label newCardLabel() {
        return new Label(Global.getMsg("sunsoft.jws.visual.rt.awt.TabbedFolder.NewCardLabel"));
    }

    @Override
    public void addTab(String string) {
        super.addTab(string);
        this.flushCache();
        this.repaint();
    }

    @Override
    public void addTab(String string, int n) {
        super.addTab(string, n);
        this.flushCache();
        this.repaint();
    }

    @Override
    public void renameTab(String string, String string2) {
        super.renameTab(string, string2);
        this.flushCache();
        this.repaint();
    }

    @Override
    public void removeTab(String string) {
        super.removeTab(string);
        this.flushCache();
        this.repaint();
    }

    @Override
    public void removeAllTabs() {
        super.removeAllTabs();
        this.flushCache();
        this.repaint();
    }

    public String getCurrentFolder() {
        return this.getCurrentCard();
    }

    @Override
    public void show(String string) {
        super.show(string);
        this.repaint();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.flushCache();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.flushCache();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.flushCache();
    }

    @Override
    public Dimension minimumSize() {
        this.cacheTabInfo();
        Dimension dimension = super.minimumSize();
        int n = this.tabW + TabbedFolder.folderInsets.left + TabbedFolder.folderInsets.right;
        if (n > dimension.width) {
            dimension = new Dimension(n, dimension.height);
        }
        return dimension;
    }

    @Override
    public Dimension preferredSize() {
        this.cacheTabInfo();
        Dimension dimension = super.preferredSize();
        int n = this.tabW + TabbedFolder.folderInsets.left + TabbedFolder.folderInsets.right;
        if (n > dimension.width) {
            dimension = new Dimension(n, dimension.height);
        }
        return dimension;
    }

    @Override
    public Insets insets() {
        this.cacheTabInfo();
        Insets insets = new Insets(0, 0, 0, 0);
        insets.left = TabbedFolder.folderInsets.left + 2 + 10;
        insets.right = TabbedFolder.folderInsets.right + 2 + 10;
        insets.top = TabbedFolder.folderInsets.top + this.tabH + 7;
        insets.bottom = TabbedFolder.folderInsets.bottom + 2 + 7;
        return insets;
    }

    @Override
    public boolean mouseDown(Event event, int n, int n2) {
        int n3 = this.calcTabIndex(n, n2);
        if (n3 >= 0 && n3 < this.tabs.size()) {
            String string = (String)this.tabs.elementAt(n3);
            this.cancelSwitch = false;
            this.postEvent(new Event(this, 4862, string));
            if (!this.cancelSwitch) {
                this.show(string);
                this.postEvent(new Event(this, 1001, string));
            } else {
                this.cancelSwitch = false;
            }
        }
        return false;
    }

    public void cancelSwitch() {
        this.cancelSwitch = true;
    }

    private synchronized int calcTabIndex(int n, int n2) {
        this.cacheTabInfo();
        if (n < TabbedFolder.folderInsets.left + this.tabx[0] || n > TabbedFolder.folderInsets.left + this.tabx[this.tabx.length - 1]) {
            return -1;
        }
        if (n2 < TabbedFolder.folderInsets.top + 2 || n2 > TabbedFolder.folderInsets.top + this.tabH) {
            return -1;
        }
        for (int i = 0; i < this.tabtext.length; ++i) {
            if (n < TabbedFolder.folderInsets.left + this.tabx[i] || n > TabbedFolder.folderInsets.left + this.tabx[i + 1]) continue;
            return i;
        }
        return -1;
    }

    private synchronized void cacheTabInfo() {
        if (this.tabx == null) {
            if (this.getPeer() == null) {
                return;
            }
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = this.tabs.size();
            if (n == 0) {
                this.tabx = new int[2];
                this.tabtext = new String[1];
                this.tabtext[0] = Global.getMsg("sunsoft.jws.visual.rt.awt.TabbedFolder.Empty");
                this.tabx[0] = 2;
                this.tabx[1] = this.tabx[0] + fontMetrics.stringWidth(this.tabtext[0]) + 14 + 4;
            } else {
                Enumeration enumeration = this.tabs.elements();
                int n2 = 0;
                int n3 = 2;
                this.tabx = new int[this.tabs.size() + 1];
                this.tabtext = new String[this.tabs.size()];
                while (enumeration.hasMoreElements()) {
                    this.tabtext[n2] = (String)enumeration.nextElement();
                    this.tabx[n2] = n3;
                    n3 += fontMetrics.stringWidth(this.tabtext[n2]) + 14 + 4;
                    ++n2;
                }
                this.tabx[n2] = n3;
            }
            this.tabW = this.tabx[this.tabx.length - 1] - this.tabx[0] + 4;
            this.tabH = fontMetrics.getMaxAscent() + 14 + 6;
            this.buffer = this.createImage(this.tabW, this.tabH);
        }
    }

    private synchronized void flushCache() {
        this.tabx = null;
        this.tabtext = null;
        this.tabW = 0;
        this.tabH = 0;
        this.buffer = null;
        if (this.isValid()) {
            this.invalidate();
        }
    }

    @Override
    public void update(Graphics graphics) {
        if (Global.isWindows()) {
            graphics = this.getGraphics();
        }
        this.cacheTabInfo();
        Dimension dimension = this.size();
        int n = TabbedFolder.folderInsets.left + this.tabW;
        int n2 = TabbedFolder.folderInsets.top + this.tabH;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, TabbedFolder.folderInsets.top);
        graphics.fillRect(0, n2, dimension.width, dimension.height - n2);
        graphics.fillRect(0, 0, TabbedFolder.folderInsets.left, dimension.height);
        graphics.fillRect(n, 0, dimension.width - n, dimension.height);
        this.draw(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        if (Global.isWindows()) {
            graphics = this.getGraphics();
        }
        this.draw(graphics);
    }

    private synchronized void draw(Graphics graphics) {
        this.cacheTabInfo();
        Dimension dimension = this.size();
        if (this.buffer != null) {
            this.drawTabs(dimension);
            graphics.drawImage(this.buffer, TabbedFolder.folderInsets.left, TabbedFolder.folderInsets.top, null);
        }
        this.drawBox(graphics, dimension);
    }

    private synchronized void drawTabs(Dimension dimension) {
        int n;
        Graphics graphics = this.buffer.getGraphics();
        String string = this.getCurrentCard();
        int n2 = -1;
        if (string != null) {
            n2 = this.tabs.indexOf(string);
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.tabW, this.tabH);
        for (n = 0; n < this.tabtext.length; ++n) {
            if (n == n2) continue;
            this.drawTab(graphics, n, false);
        }
        for (n = 0; n < this.tabtext.length; ++n) {
            if (n != n2) continue;
            this.drawTab(graphics, n, true);
            break;
        }
        graphics.setColor(this.brighter(this.getBackground()));
        graphics.fillRect(0, this.tabH - 2, 2, 2);
        n = this.tabx[this.tabx.length - 1];
        if (dimension.width - this.tabW > TabbedFolder.folderInsets.left + TabbedFolder.folderInsets.right) {
            graphics.setColor(this.brighter(this.getBackground()));
            graphics.fillRect(this.tabW - 2, this.tabH - 2, 2, 2);
        } else {
            this.drawUpperRightCorner(graphics, this.tabW - 2, this.tabH - 2);
        }
    }

    private void drawUpperRightCorner(Graphics graphics, int n, int n2) {
        String string = this.getCurrentCard();
        int n3 = -1;
        if (string != null) {
            n3 = this.tabs.indexOf(string);
        }
        graphics.setColor(this.darker(this.getBackground()));
        this.fillRect(graphics, n, n2, 2, 2);
        int n4 = this.tabs.size();
        if (n4 == 0 || n3 != n4 - 1) {
            graphics.setColor(this.brighter(this.getBackground()));
            this.fillRect(graphics, n, n2, 1, 1);
        }
    }

    private void drawTab(Graphics graphics, int n, boolean bl) {
        int n2 = this.tabx[n];
        int n3 = 2;
        int n4 = this.tabx[n + 1] - this.tabx[n] - 1;
        int n5 = this.tabH - 2 - 1;
        if (bl) {
            n2 -= 2;
            n3 -= 2;
            n4 += 4;
            n5 += 4;
        }
        graphics.setColor(this.getBackground());
        this.draw3DOuterTab(graphics, n2, n3, n4, n5, bl);
        this.draw3DInnerTab(graphics, n2 + 1, n3 + 1, n4 - 2, n5 - 2, bl);
        n2 = this.tabx[n] + 2 + 7;
        n3 = this.tabH - 2 - 7;
        if (bl) {
            n3 -= 2;
        }
        graphics.setColor(this.getForeground());
        graphics.setFont(this.getFont());
        graphics.drawString(this.tabtext[n], n2, n3 - 1);
    }

    private void drawBox(Graphics graphics, Dimension dimension) {
        int n = TabbedFolder.folderInsets.left;
        int n2 = TabbedFolder.folderInsets.top + this.tabH;
        int n3 = dimension.width - (TabbedFolder.folderInsets.left + TabbedFolder.folderInsets.right) - 1;
        int n4 = dimension.height - (this.tabH + TabbedFolder.folderInsets.top + TabbedFolder.folderInsets.bottom) - 1;
        if (n >= dimension.width || n2 >= dimension.height || n3 <= 0 || n4 <= 0) {
            return;
        }
        graphics.setColor(this.getBackground());
        this.draw3DU(graphics, n, n2, n3, n4, true);
        if (dimension.width - this.tabW > TabbedFolder.folderInsets.left + TabbedFolder.folderInsets.right) {
            graphics.setColor(this.brighter(this.getBackground()));
            this.fillRect(graphics, TabbedFolder.folderInsets.left + this.tabW, TabbedFolder.folderInsets.top + this.tabH - 2, dimension.width - (TabbedFolder.folderInsets.left + TabbedFolder.folderInsets.right + this.tabW), 2);
            this.drawUpperRightCorner(graphics, dimension.width - TabbedFolder.folderInsets.right - 2, TabbedFolder.folderInsets.top + this.tabH - 2);
        }
    }

    private void draw3DU(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        Color color = graphics.getColor();
        Color color2 = this.brighter(color);
        Color color3 = this.darker(color);
        graphics.setColor(bl ? color2 : color3);
        graphics.drawLine(n, n2, n, n2 + n4);
        graphics.drawLine(n + 1, n2, n + 1, n2 + n4);
        graphics.setColor(bl ? color3 : color2);
        graphics.drawLine(n + 1, n2 + n4, n + n3, n2 + n4);
        graphics.drawLine(n + 2, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3, n2, n + n3, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        graphics.setColor(color);
    }

    private void draw3DInnerTab(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        Color color = graphics.getColor();
        Color color2 = this.brighter(color);
        Color color3 = this.darker(color);
        graphics.setColor(color2);
        graphics.drawLine(n, n2, n, n2 + n4);
        graphics.drawLine(n + 1, n2, n + n3 - 1, n2);
        if (!bl) {
            graphics.drawLine(n + 1, n2 + n4, n + n3 + 1, n2 + n4);
        }
        graphics.setColor(color3);
        graphics.drawLine(n + n3, n2, n + n3, n2 + n4 - 1);
        graphics.setColor(color);
    }

    private void draw3DOuterTab(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        Color color = graphics.getColor();
        Color color2 = this.brighter(color);
        Color color3 = this.darker(color);
        graphics.setColor(color2);
        graphics.drawLine(n, n2 + 2, n, n2 + n4);
        graphics.drawLine(n + 2, n2, n + n3 - 2, n2);
        if (!bl) {
            graphics.drawLine(n + 1, n2 + n4, n + n3, n2 + n4);
        }
        graphics.setColor(color3);
        graphics.drawLine(n + n3, n2 + 2, n + n3, n2 + n4 - 2);
        graphics.setColor(color);
    }

    private Color brighter(Color color) {
        return Global.util.brighter(color);
    }

    private Color darker(Color color) {
        return new Color(Math.max((int)((double)color.getRed() * 0.7), 0), Math.max((int)((double)color.getGreen() * 0.7), 0), Math.max((int)((double)color.getBlue() * 0.7), 0));
    }

    private void fillRect(Graphics graphics, int n, int n2, int n3, int n4) {
        if (Global.isWindows()) {
            graphics.drawRect(n, n2, --n3, --n4);
        }
        graphics.fillRect(n, n2, n3, n4);
    }
}

