/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VJFlowLayout
implements LayoutManager {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private static final int PREFERREDSIZE = 0;
    private static final int MINIMUMSIZE = 1;
    private int align = 0;
    private int hgap = 5;
    private int vgap = 5;
    private int minimumWidth = 0;

    public void setAlignment(int n) {
        this.align = n;
    }

    public int getAlignment() {
        return this.align;
    }

    public void setHGap(int n) {
        this.hgap = n;
    }

    public int getHGap() {
        return this.hgap;
    }

    public void setVGap(int n) {
        this.vgap = n;
    }

    public int getVGap() {
        return this.vgap;
    }

    public void setMinimumWidth(int n) {
        this.minimumWidth = n;
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.calcLayoutSize(container, 0);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.calcLayoutSize(container, 1);
    }

    private Dimension calcLayoutSize(Container container, int n) {
        Insets insets = container.insets();
        Dimension dimension = new Dimension(0, this.vgap + insets.top + insets.bottom);
        int n2 = container.countComponents();
        int n3 = 0;
        int n4 = insets.left + insets.right + this.hgap;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = n == 0 ? component.preferredSize() : component.minimumSize();
            if (this.minimumWidth > 0 && n3 != 0 && n4 + dimension2.width + this.hgap > this.minimumWidth) {
                dimension.width = Math.max(n4, dimension.width);
                dimension.height += n5 + this.vgap;
                n3 = 0;
                n4 = insets.left + insets.right + this.hgap;
                n5 = 0;
            }
            n4 += dimension2.width + this.hgap;
            n5 = Math.max(n5, dimension2.height);
            ++n3;
        }
        if (n3 > 0) {
            dimension.width = Math.max(n4, dimension.width);
            dimension.height += n5 + this.vgap;
        }
        return dimension;
    }

    private void moveComponents(Container container, int n, int n2, int n3, int n4, int n5, int n6) {
        switch (this.align) {
            case 0: {
                break;
            }
            case 1: {
                n += n3 / 2;
                break;
            }
            case 2: {
                n += n3;
            }
        }
        for (int i = n5; i < n6; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension = component.size();
            component.move(n, n2 + (n4 - dimension.height) / 2);
            n += this.hgap + dimension.width;
        }
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.insets();
        Dimension dimension = container.size();
        int n = dimension.width - (insets.left + insets.right + this.hgap * 2);
        int n2 = container.countComponents();
        int n3 = 0;
        int n4 = insets.top + this.vgap;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n2; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.preferredSize();
            component.resize(dimension2.width, dimension2.height);
            if (n3 == 0 || n3 + dimension2.width <= n) {
                if (n3 > 0) {
                    n3 += this.hgap;
                }
                n3 += dimension2.width;
                n5 = Math.max(n5, dimension2.height);
                continue;
            }
            this.moveComponents(container, insets.left + this.hgap, n4, n - n3, n5, n6, i);
            n3 = dimension2.width;
            n4 += this.vgap + n5;
            n5 = dimension2.height;
            n6 = i;
        }
        this.moveComponents(container, insets.left + this.hgap, n4, n - n3, n5, n6, n2);
    }

    public String toString() {
        String string = "";
        switch (this.align) {
            case 0: {
                string = ",align=left";
                break;
            }
            case 1: {
                string = ",align=center";
                break;
            }
            case 2: {
                string = ",align=right";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + string + "]";
    }
}

