/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Window;
import java.util.Hashtable;
import sunsoft.jws.visual.rt.awt.GBConstraints;
import sunsoft.jws.visual.rt.awt.GBLayout;
import sunsoft.jws.visual.rt.base.AttributeManager;
import sunsoft.jws.visual.rt.base.DesignerAccess;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.base.Message;

public class VJPanel
extends Panel {
    public static final int RELIEF_FLAT = 0;
    public static final int RELIEF_RAISED = 1;
    public static final int RELIEF_SUNKEN = 2;
    public static final int RELIEF_RIDGE = 3;
    public static final int RELIEF_GROOVE = 4;
    public static final int WIN95_RAISED = 6;
    public static final int WIN95_SUNKEN = 7;
    public static final int WIN95_FIELD_BORDER = 8;
    public static final int WIN95_WINDOW_BORDER = 9;
    public static final int BLACK_BORDER = 10;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private static final int labelpadx = 10;
    private static final int labelipadx = 4;
    private static final int labelpadtop = 2;
    private static final int MARKER_EVENT = 83250;
    private static double FACTOR = 0.85;
    static boolean isMouseDown;
    private static final int CLICK_TIMEOUT = 400;
    private static final int CLICK_DISTANCE = 2;
    private static int clickCount;
    private static long clickTime;
    private static long clickWhen;
    private static int clickX;
    private static int clickY;
    private int relief = 0;
    int borderWidth = 2;
    private String borderLabel = null;
    private int labelAlignment = 0;
    private Insets borderInsets = new Insets(5, 5, 5, 5);

    public static boolean markEvent(Event event, Component component) {
        Event event2 = event.evt;
        while (event2 != null) {
            if (event2.id == 83250) {
                return false;
            }
            event2 = event2.evt;
        }
        Object object = null;
        AttributeManager attributeManager = null;
        Hashtable hashtable = DesignerAccess.getShadowTable();
        if (event.target != null) {
            attributeManager = (AttributeManager)hashtable.get(event.target);
            object = attributeManager;
        }
        if (attributeManager == null) {
            attributeManager = (AttributeManager)hashtable.get(component);
            object = event.target;
        }
        if (attributeManager != null) {
            Message message = new Message(object, "AWT", event, true);
            event2 = event;
            while (event2.evt != null) {
                event2 = event2.evt;
            }
            event2.evt = new Event(attributeManager, 83250, message);
            event2.evt.x = event2.x;
            event2.evt.y = event2.y;
            return true;
        }
        return false;
    }

    public static void forwardEvent(Event event, Component component) {
        Object object;
        Event event2 = event;
        Event event3 = event;
        while (event3.evt != null) {
            event2 = event3;
            event3 = event3.evt;
        }
        event2.evt = null;
        if (event3.id != 83250) {
            throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.awt.VJPanel.UnmarkedEvent", "forwardEvent"));
        }
        event.x = event3.x;
        event.y = event3.y;
        Object object2 = null;
        if (event.target instanceof Component) {
            object2 = (Component)event.target;
        }
        while (object2 != null && object2 != component) {
            object = ((Component)object2).getParent();
            if (object == null) {
                event.x = event3.x;
                event.y = event3.y;
                break;
            }
            VJPanel.translateEvent(event, (Component)object2, (Container)object, true);
            object2 = object;
        }
        VJPanel.fixClickCount(event);
        object = (AttributeManager)event3.target;
        ((AttributeManager)object).postMessage((Message)event3.arg);
    }

    @Override
    public boolean postEvent(Event event) {
        VJPanel.fixClickCount(event);
        if (event.id == 501) {
            isMouseDown = true;
        } else if (event.id == 502) {
            isMouseDown = false;
        }
        boolean bl = VJPanel.markEvent(event, this);
        boolean bl2 = this.doPostEvent(event);
        if (bl) {
            VJPanel.forwardEvent(event, this);
        }
        return bl2;
    }

    private boolean doPostEvent(Event event) {
        boolean bl = false;
        if (Global.isWindows()) {
            if (this.handleEvent(event)) {
                bl = true;
            } else {
                Container container = this.getParent();
                if (container != null) {
                    this.translateEvent(event, this, container);
                    if (container.postEvent(event)) {
                        bl = true;
                    }
                }
            }
        } else {
            bl = super.postEvent(event);
        }
        return bl;
    }

    static void fixClickCount(Event event) {
        if (event.id != 501 || event.when == clickWhen) {
            return;
        }
        if (Global.isMotif()) {
            long l = System.currentTimeMillis();
            if (event.when == 0L) {
                event.when = l;
            }
            int n = Math.abs(clickX - event.x) + Math.abs(clickY - event.y);
            if (l - clickTime < 400L && n <= 2) {
                event.clickCount = ++clickCount;
            } else {
                clickCount = 1;
            }
            if (event.clickCount == 1) {
                event.clickCount = clickCount;
            }
            clickTime = l;
            clickWhen = event.when;
            clickX = event.x;
            clickY = event.y;
        } else if (Global.isWindows()) {
            int n;
            long l = System.currentTimeMillis();
            if (event.when == 0L) {
                event.when = l;
            }
            if ((n = Math.abs(clickX - event.x) + Math.abs(clickY - event.y)) > 2) {
                event.clickCount = 1;
            }
            clickWhen = event.when;
            clickX = event.x;
            clickY = event.y;
        }
    }

    public void translateEvent(Event event, Component component, Container container) {
        VJPanel.translateEvent(event, component, container, false);
    }

    private static void translateEvent(Event event, Component component, Container container, boolean bl) {
        LayoutManager layoutManager = container.getLayout();
        if (layoutManager instanceof GBLayout) {
            GBLayout gBLayout = (GBLayout)layoutManager;
            GBConstraints gBConstraints = gBLayout.getConstraints(component);
            Point point = null;
            if (gBConstraints != null) {
                point = gBConstraints.location;
            }
            if (point == null) {
                point = component.location();
            }
            if (bl) {
                event.translate(-point.x, -point.y);
            } else {
                event.translate(point.x, point.y);
            }
        } else {
            Point point = component.location();
            if (bl) {
                event.translate(-point.x, -point.y);
            } else {
                event.translate(point.x, point.y);
            }
        }
    }

    public VJPanel() {
    }

    public VJPanel(int n) {
        this();
        this.setRelief(n);
    }

    public VJPanel(int n, String string) {
        this(n);
        this.setBorderLabel(string);
    }

    public VJPanel(int n, String string, int n2, Insets insets) {
        this(n, string);
        this.setBorderWidth(n2);
        this.setBorderInsets(insets);
    }

    @Override
    public void validate() {
        if (!this.isValid() && this.getPeer() != null) {
            this.layout();
        }
        int n = this.countComponents();
        for (int i = 0; i < n; ++i) {
            Component component = this.getComponent(i);
            if (component.isValid() || component.getPeer() == null || !component.isVisible()) continue;
            component.validate();
        }
    }

    @Override
    protected void validateTree() {
        if (!this.isValid() && this.getPeer() != null) {
            this.layout();
            int n = this.countComponents();
            for (int i = 0; i < n; ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof Container) || component instanceof Window || component.isValid() || component.getPeer() == null || !component.isVisible()) continue;
                ((Container)component).validate();
            }
        }
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (component.getParent() != this) {
            super.addImpl(component, object, n);
        }
    }

    public void setRelief(int n) {
        this.relief = n;
        this.invalidate();
        this.repaint();
    }

    public int getRelief() {
        return this.relief;
    }

    public void setBorderWidth(int n) {
        if (n != this.borderWidth) {
            this.borderWidth = n;
            this.invalidate();
            this.repaint();
        }
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderLabel(String string) {
        this.borderLabel = string;
        this.invalidate();
        this.repaint();
    }

    public String getBorderLabel() {
        return this.borderLabel;
    }

    public void setLabelAlignment(int n) {
        this.labelAlignment = n;
        this.repaint();
    }

    public int getLabelAlignment() {
        return this.labelAlignment;
    }

    public void setBorderInsets(Insets insets) {
        this.borderInsets = insets == null ? new Insets(0, 0, 0, 0) : (Insets)insets.clone();
        this.invalidate();
    }

    public Insets getBorderInsets() {
        return (Insets)this.borderInsets.clone();
    }

    @Override
    public Insets insets() {
        int n = this.getBD();
        int n2 = this.getLabelAdjustedTop();
        Insets insets = this.getAdjustedInsets();
        return new Insets(n2 + insets.top, n + insets.left, n + insets.bottom, n + insets.right);
    }

    @Override
    public Dimension minimumSize() {
        Dimension dimension = super.minimumSize();
        int n = this.getLabelAdjustedMinWidth();
        if (n > dimension.width) {
            dimension = new Dimension(n, dimension.height);
        }
        return dimension;
    }

    @Override
    public Dimension preferredSize() {
        Dimension dimension = super.preferredSize();
        int n = this.getLabelAdjustedMinWidth();
        if (n > dimension.width) {
            dimension = new Dimension(n, dimension.height);
        }
        return dimension;
    }

    private int getBD() {
        int n = 0;
        if (this.relief != 0 || this.borderLabel != null) {
            n = this.borderWidth;
        }
        return n;
    }

    private Insets getAdjustedInsets() {
        Insets insets = this.relief == 0 && this.borderLabel == null ? new Insets(0, 0, 0, 0) : this.borderInsets;
        return insets;
    }

    private int getLabelAdjustedTop() {
        int n;
        if (this.relief == 0 && this.borderLabel == null) {
            return 0;
        }
        int n2 = n = this.borderWidth;
        Font font = this.getFont();
        if (this.borderLabel != null && font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            n2 = fontMetrics.getAscent() + fontMetrics.getDescent() + 2;
            if (!this.isLabelInBorder()) {
                n2 += n;
            } else if (n2 < n) {
                n2 = n;
            }
        }
        return n2;
    }

    private int getLabelAdjustedMinWidth() {
        if (this.relief == 0 && this.borderLabel == null) {
            return 0;
        }
        int n = this.borderWidth;
        int n2 = 2 * n + this.borderInsets.left + this.borderInsets.right;
        Font font = this.getFont();
        if (this.borderLabel != null && font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            n2 = Math.max(n2, 2 * n + fontMetrics.stringWidth(this.borderLabel) + 10 + 4);
        }
        return n2;
    }

    private boolean isLabelInBorder() {
        switch (this.relief) {
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void update(Graphics graphics) {
        if (Global.isWindows()) {
            graphics = this.getGraphics();
        }
        Dimension dimension = this.size();
        Insets insets = this.insets();
        graphics.setColor(this.getBackground());
        if (insets.left > 0) {
            graphics.fillRect(0, 0, insets.left, dimension.height);
        }
        if (insets.top > 0) {
            graphics.fillRect(0, 0, dimension.width, insets.top);
        }
        if (insets.bottom > 0) {
            graphics.fillRect(0, dimension.height - insets.bottom, dimension.width, insets.bottom);
        }
        if (insets.right > 0) {
            graphics.fillRect(dimension.width - insets.right, 0, insets.right, dimension.height);
        }
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        graphics = this.getGraphics();
        super.paint(graphics);
        Dimension dimension = this.size();
        Insets insets = this.insets();
        int n4 = this.borderWidth;
        FontMetrics fontMetrics = null;
        if (this.borderLabel != null) {
            fontMetrics = this.getFontMetrics(this.getFont());
        }
        if (this.relief != 0 && n4 > 0) {
            switch (this.relief) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 10: {
                    graphics.setColor(this.getBackground());
                    break;
                }
                case 8: 
                case 9: {
                    graphics.setColor(this.getParent().getBackground());
                }
            }
            n3 = 0;
            if (this.borderLabel != null) {
                n2 = fontMetrics.getAscent();
                n = fontMetrics.getDescent();
                n3 = this.isLabelInBorder() ? (n2 + n + 2 - n4) / 2 : n2 + n + 2;
                if (n3 < 0) {
                    n3 = 0;
                }
            }
            Global.util.draw3DRect(graphics, 0, n3, dimension.width - 1, dimension.height - 1 - n3, this.relief, n4);
        }
        if (this.borderLabel != null) {
            int n5;
            n3 = fontMetrics.stringWidth(this.borderLabel);
            n2 = fontMetrics.getAscent();
            n = fontMetrics.getDescent();
            switch (this.labelAlignment) {
                default: {
                    n5 = n4 + 7;
                    break;
                }
                case 1: {
                    n5 = (dimension.width - n3) / 2;
                    break;
                }
                case 2: {
                    n5 = dimension.width - (n3 + 7 + n4);
                }
            }
            int n6 = 2 + n2;
            int n7 = 2 + n2 + n;
            if (this.isLabelInBorder() && n4 > n7) {
                n6 = (n4 - n7) / 2 + (2 + n2);
                n7 = n4;
            }
            graphics.setColor(this.getBackground());
            graphics.fillRect(n5 - 2, 0, n3 + 4, n7);
            graphics.setColor(this.getForeground());
            graphics.setFont(this.getFont());
            graphics.drawString(this.borderLabel, n5, n6 - 1);
        }
    }

    @Override
    public void requestFocus() {
        if (!Global.isWindows() || !isMouseDown) {
            super.requestFocus();
        }
    }

    static {
        clickCount = 1;
        clickTime = 0L;
        clickWhen = -1L;
    }
}

