/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.base;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Window;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import sunsoft.jws.visual.rt.base.AMContainer;
import sunsoft.jws.visual.rt.base.Attribute;
import sunsoft.jws.visual.rt.base.AttributeList;
import sunsoft.jws.visual.rt.base.AttributeManager;
import sunsoft.jws.visual.rt.base.DesignerAccess;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.base.Message;
import sunsoft.jws.visual.rt.base.NVGroup;
import sunsoft.jws.visual.rt.base.Operations;
import sunsoft.jws.visual.rt.base.Registry;
import sunsoft.jws.visual.rt.base.Root;
import sunsoft.jws.visual.rt.base.Shadow;
import sunsoft.jws.visual.rt.shadow.VJPanelShadow;
import sunsoft.jws.visual.rt.shadow.java.awt.ContainerShadow;
import sunsoft.jws.visual.rt.shadow.java.awt.DialogShadow;
import sunsoft.jws.visual.rt.shadow.java.awt.FrameShadow;
import sunsoft.jws.visual.rt.shadow.java.awt.PanelShadow;
import sunsoft.jws.visual.rt.shadow.java.awt.WindowShadow;
import sunsoft.jws.visual.rt.type.Converter;

public abstract class Group
extends AttributeManager {
    private boolean warned = false;
    private boolean doingShow = false;
    private boolean isShowing = false;
    public static final int FORWARD = 256;
    public static final int FORWARD_REMOVE = 512;
    public static final int RESTORE_CURSOR = 50000;
    public static final int BACKSPACE_KEY = 8;
    public static final int TAB_KEY = 9;
    public static final int RETURN_KEY = 10;
    public static final int ESCAPE_KEY = 27;
    public static final int DELETE_KEY = 127;
    private Root root;
    private boolean isInitialized;
    private boolean isStarted = false;
    private Group parentGroup = null;
    private Vector children = new Vector();
    private Vector operations = null;
    private Vector forwardVector = new Vector();
    private static AttributeList genericAttrList = null;
    private Applet applet = null;
    private String[] cmdLineArgs;
    private Frame topLevel = null;
    private Registry registry = null;
    private boolean hasEnvironment = false;

    private void checkDate() {
        Date date = new Date(840092401000L);
        if (System.currentTimeMillis() >= 840092401000L) {
            throw new Error(Global.getMsg("sunsoft.jws.visual.rt.base.Group.ExpiredVersion"));
        }
        if (!this.warned) {
            this.warned = true;
            System.out.println(Global.fmtMsg("sunsoft.jws.visual.rt.base.Group.ExpiredVersionDate", date.toString()));
        }
    }

    public Group() {
        this.attributes.add("visible", "java.lang.Boolean", Boolean.TRUE, 16);
    }

    @Override
    public void initialize() {
        Object object;
        Enumeration enumeration;
        boolean bl = this.isInitialized;
        if (!this.isInitialized) {
            if (!this.hasEnvironment()) {
                throw new Error(Global.getMsg("sunsoft.jws.visual.rt.base.Group.GroupInitializationWarning"));
            }
            this.isInitialized = true;
            this.root = this.initRoot();
            if (this.root == null && !(this instanceof NVGroup)) {
                throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.base.Group.RootIsNull", this.getClass().getName()));
            }
            this.removeForwardedAttributes();
            this.initGroup();
            if (this.operations != null) {
                enumeration = this.operations.elements();
                while (enumeration.hasMoreElements()) {
                    object = (Operations)enumeration.nextElement();
                    ((Operations)object).setRoot(this.root);
                }
            }
        }
        enumeration = this.getChildList();
        while (enumeration.hasMoreElements()) {
            object = (Group)enumeration.nextElement();
            if (!this.wouldBeVisible((Group)object)) continue;
            ((Group)object).initialize();
        }
        if (!bl) {
            enumeration = this.attributes.elements();
            while (enumeration.hasMoreElements()) {
                object = (Attribute)enumeration.nextElement();
                String string = ((Attribute)object).getName();
                if (!((Attribute)object).isModified() && ((Attribute)object).flagged(17)) continue;
                this.set(string, ((Attribute)object).getValue());
            }
            if (this.isLayoutMode() && (object = this.getWindow()) != null) {
                ((WindowShadow)object).setLayout(true);
            }
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    protected abstract Root initRoot();

    protected void initGroup() {
    }

    @Override
    protected String getUserTypeName() {
        return Converter.shortClassName(this.getClass().getName()).toLowerCase();
    }

    public ContainerShadow getContainer() {
        if (this.root == null) {
            return null;
        }
        AttributeManager attributeManager = this.root.getMainChild();
        if (attributeManager == null) {
            return null;
        }
        if (attributeManager instanceof ContainerShadow) {
            return (ContainerShadow)attributeManager;
        }
        if (attributeManager instanceof Group) {
            return ((Group)attributeManager).getContainer();
        }
        throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.base.Group.UnexpectedMainChildType", attributeManager));
    }

    public PanelShadow getPanel() {
        ContainerShadow containerShadow = this.getContainer();
        if (containerShadow instanceof PanelShadow) {
            return (PanelShadow)containerShadow;
        }
        return null;
    }

    public WindowShadow getWindow() {
        ContainerShadow containerShadow = this.getContainer();
        if (containerShadow instanceof WindowShadow) {
            return (WindowShadow)containerShadow;
        }
        return null;
    }

    public void show(boolean bl) {
        if (bl) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void show() {
        this.set("visible", Boolean.TRUE);
    }

    public void hide() {
        this.set("visible", Boolean.FALSE);
    }

    public boolean isVisible() {
        Group group = this.getBase();
        if (group == null) {
            return false;
        }
        return group.wouldBeVisible(this);
    }

    public boolean wouldBeVisible(Group group) {
        while (group != null && group != this) {
            Boolean bl = (Boolean)group.get("visible");
            if (!bl.booleanValue()) {
                return false;
            }
            AttributeManager attributeManager = (AttributeManager)((Object)group.getParent());
            while (!(attributeManager instanceof Root)) {
                bl = (Boolean)attributeManager.get("visible");
                if (!bl.booleanValue()) {
                    return false;
                }
                attributeManager = (AttributeManager)((Object)attributeManager.getParent());
            }
            if (attributeManager == null) {
                return false;
            }
            group = ((Root)attributeManager).getGroup();
        }
        return group != null;
    }

    public boolean isShowing() {
        return this.isShowing;
    }

    private boolean isContainerVisible() {
        if (this.inDesignerRoot()) {
            ContainerShadow containerShadow = this.getContainer();
            if (containerShadow == null) {
                return false;
            }
            Component component = (Component)containerShadow.getBody();
            if (component == null) {
                return false;
            }
            return component.isVisible();
        }
        return false;
    }

    protected void showGroup() {
    }

    void internalShowGroup() {
        Group group = null;
        if (!this.isInitialized) {
            group = this.getBase();
            if (group != null) {
                group.setCursor(3);
            }
            this.initialize();
        }
        if (!this.isCreated) {
            this.doingShow = true;
            this.create();
            this.doingShow = false;
        }
        if (!this.isShowing) {
            this.isShowing = true;
            if (this.root != null) {
                this.showGroup();
            }
            if (!this.isShowing) {
                return;
            }
        }
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            Group group2 = (Group)enumeration.nextElement();
            if (!this.wouldBeVisible(group2) || group2.getParent() == this.root) continue;
            group2.internalShowGroup();
        }
        if (this.root != null) {
            this.root.showRoot();
        }
        if (this.hasStarted() && !this.isStarted) {
            this.start();
        }
        if (group != null) {
            group.setCursor(50000);
        }
    }

    protected void hideGroup() {
    }

    void internalHideGroup() {
        if (!this.isInitialized) {
            return;
        }
        if (this.isShowing) {
            this.isShowing = false;
            if (this.root != null) {
                this.hideGroup();
            }
        }
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            Group group = (Group)enumeration.nextElement();
            if (group.getParent() == this.root) continue;
            group.internalHideGroup();
        }
        if (this.root != null) {
            this.root.hideRoot();
        }
    }

    @Override
    public void create() {
        if (!this.isInitialized) {
            this.initialize();
        }
        if (!this.hasBase()) {
            throw new Error(Global.getMsg("sunsoft.jws.visual.rt.base.Group.GroupCreationWarning"));
        }
        boolean bl = this.isCreated;
        boolean bl2 = this.doingShow;
        boolean bl3 = false;
        if (!bl && !this.doingShow() && this.isVisible()) {
            this.doingShow = true;
            bl3 = true;
        }
        super.create();
        if (this.root == null && !(this instanceof NVGroup)) {
            throw new Error(Global.getMsg("sunsoft.jws.visual.rt.base.Group.RootIsNull2"));
        }
        if (this.root != null) {
            this.root.create();
        }
        if (!bl) {
            this.createGroup();
            if (bl3) {
                this.internalShowGroup();
            }
        }
        this.doingShow = bl2;
    }

    protected void createGroup() {
    }

    @Override
    public void destroy() {
        if (!this.isInitialized) {
            return;
        }
        this.stop();
        if (this.isCreated) {
            this.destroyGroup();
        }
        super.destroy();
        if (this.root != null) {
            this.root.destroy();
        }
    }

    protected void destroyGroup() {
    }

    public void start() {
        if (!this.isInitialized) {
            return;
        }
        if (!this.isCreated) {
            this.create();
        }
        if (!this.isStarted) {
            this.isStarted = true;
            this.startGroup();
        }
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            Group group = (Group)enumeration.nextElement();
            if (!this.wouldBeVisible(group)) continue;
            group.start();
        }
    }

    protected void startGroup() {
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void stop() {
        if (!this.isInitialized) {
            return;
        }
        if (this.isStarted) {
            this.isStarted = false;
            this.stopGroup();
        }
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            ((Group)enumeration.nextElement()).stop();
        }
    }

    protected void stopGroup() {
    }

    protected boolean hasStarted() {
        if (this.isBase()) {
            return this.isStarted;
        }
        if (this.parentGroup != null) {
            return this.parentGroup.hasStarted();
        }
        return false;
    }

    void add(Group group) {
        if (!this.children.contains(group)) {
            group.setParentGroup(this);
            this.children.addElement(group);
        }
    }

    void remove(Group group) {
        if (this.children.contains(group)) {
            group.setParentGroup(null);
            this.children.removeElement(group);
        }
    }

    void addRootChildren(Root root) {
        this.addChildren(root);
    }

    private void addChildren(AMContainer aMContainer) {
        Enumeration enumeration = aMContainer.getChildList();
        while (enumeration.hasMoreElements()) {
            AttributeManager attributeManager = (AttributeManager)enumeration.nextElement();
            if (attributeManager instanceof Group) {
                this.add((Group)attributeManager);
            }
            if (!(attributeManager instanceof AMContainer)) continue;
            this.addChildren((AMContainer)((Object)attributeManager));
        }
    }

    void removeRootChildren(Root root) {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            Group group = (Group)enumeration.nextElement();
            if (group.getRoot() != root) continue;
            this.remove(group);
        }
    }

    public Group getChild(String string) {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            Group group = (Group)enumeration.nextElement();
            if (!string.equals(group.get("name"))) continue;
            return group;
        }
        return null;
    }

    public Enumeration getChildList() {
        return ((Vector)this.children.clone()).elements();
    }

    private void setParentGroup(Group group) {
        this.parentGroup = group;
    }

    public Group getParentGroup() {
        return this.parentGroup;
    }

    @Override
    public Group getGroup() {
        return this;
    }

    @Override
    public String getFullName() {
        String string;
        String string2 = this.getName();
        if (string2 == null) {
            return null;
        }
        if (this.parentGroup != null && (string = this.parentGroup.getFullName()) != null) {
            string2 = string + "." + string2;
        }
        return string2;
    }

    @Override
    public AttributeManager resolveFullName(String string) {
        AttributeManager attributeManager = null;
        Group group = this;
        while (group != null && !group.isBase()) {
            group = group.parentGroup;
        }
        if (group == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (group.getName() != null) {
            if (!stringTokenizer.hasMoreTokens()) {
                return null;
            }
            string = stringTokenizer.nextToken();
            if (!string.equals(group.getName())) {
                return null;
            }
        }
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            Group group2 = group.resolveGroup(string);
            if (group2 == null) {
                if (group.root == null) {
                    return null;
                }
                attributeManager = group.root.resolve(string);
                break;
            }
            group = group2;
        }
        if (stringTokenizer.hasMoreTokens()) {
            return null;
        }
        return attributeManager;
    }

    public Group resolveGroup(String string) {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            Group group = (Group)enumeration.nextElement();
            String string2 = group.getName();
            if (string2 == null || !string2.equals(string)) continue;
            return group;
        }
        return null;
    }

    void setParentBody() {
        if (this.root != null) {
            this.root.addChildBody(this.getContainer());
        }
    }

    void unsetParentBody() {
        if (this.root != null) {
            this.root.removeChildBody(this.getContainer());
        }
    }

    public synchronized void addOperations(Operations operations) {
        if (this.operations == null) {
            this.operations = new Vector();
        }
        if (!this.operations.contains(operations)) {
            operations.setGroup(this);
            if (this.root != null) {
                operations.setRoot(this.root);
            }
            this.operations.addElement(operations);
        }
    }

    public synchronized void removeOperations(Operations operations) {
        if (this.operations != null) {
            this.operations.removeElement(operations);
        }
    }

    @Override
    public void postMessageToParent(Message message) {
        if (this.parentGroup != null) {
            this.parentGroup.postMessage(message);
        }
    }

    @Override
    public void postMessage(Message message) {
        if (this.operations != null) {
            Enumeration enumeration = this.operations.elements();
            while (enumeration.hasMoreElements()) {
                Operations operations = (Operations)enumeration.nextElement();
                if (!operations.handleMessage(message)) continue;
                return;
            }
        }
        if (this.handleMessage(message)) {
            return;
        }
        if (!message.isAWT && this.parentGroup != null) {
            this.parentGroup.postMessage(message);
        }
    }

    @Override
    public boolean handleMessage(Message message) {
        if (message.isAWT) {
            Event event = (Event)message.arg;
            this.handleEvent(message, event);
            if (event.id == 401 && event.key != 0 && (event.key < 32 || event.key >= 127)) {
                this.postMessage(new Message(this, "AcceleratorKey", event));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean handleEvent(Message message, Event event) {
        if (super.handleEvent(message, event)) {
            return true;
        }
        switch (event.id) {
            case 201: {
                this.windowDestroy(message);
                return true;
            }
            case 203: {
                if (event.target instanceof Window && this.isBaseWindow((Window)event.target)) {
                    this.hide();
                    return true;
                }
                return false;
            }
            case 204: {
                if (event.target instanceof Window && this.isBaseWindow((Window)event.target)) {
                    this.show();
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public void exit() {
        this.exit(0);
    }

    public void exit(int n) {
        if (this.isBase()) {
            this.destroy();
            if (this.applet == null) {
                System.exit(n);
            }
        } else if (this.parentGroup != null) {
            this.parentGroup.exit(n);
        } else {
            this.destroy();
        }
    }

    protected void windowDestroy(Message message) {
        if (message.target == this.getContainer()) {
            if (this.inDesignerRoot()) {
                this.internalHideGroup();
            } else if (this.isBase()) {
                this.exit();
            } else {
                this.hide();
            }
        } else if (message.target instanceof AttributeManager) {
            ((AttributeManager)message.target).set("visible", Boolean.FALSE);
        } else if (message.target instanceof Component) {
            ((Component)message.target).hide();
        }
    }

    protected void addAttributeForward(AttributeManager attributeManager) {
        if (this.forwardVector.contains(attributeManager)) {
            return;
        }
        this.forwardVector.addElement(attributeManager);
        Enumeration enumeration = this.attributes.attributesWithFlags(256);
        while (enumeration.hasMoreElements()) {
            String string;
            Attribute attribute = (Attribute)enumeration.nextElement();
            String string2 = attribute.getName();
            if (!attributeManager.hasAttribute(string2, string = attribute.getType())) continue;
            Object object = attributeManager.get(string2);
            if (!attribute.flagged(1)) {
                if (!attribute.isModified()) {
                    this.putInTable(string2, object);
                } else if (!attributeManager.getAttribute(string2).flagged(1)) {
                    attributeManager.set(string2, attribute.getValue());
                }
            }
            attribute.setDefaultValue(object);
        }
    }

    protected void addForwardedAttributes() {
        if (genericAttrList == null) {
            genericAttrList = new AttributeList();
            this.mergeForward(genericAttrList, new VJPanelShadow());
            this.mergeForward(genericAttrList, new FrameShadow());
            this.mergeForward(genericAttrList, new DialogShadow());
        }
        Enumeration enumeration = genericAttrList.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (this.hasAttribute(attribute.getName())) continue;
            this.attributes.add((Attribute)attribute.clone());
        }
        if (!this.hasAttribute("text")) {
            this.attributes.alias("text", "title");
        }
    }

    private void mergeForward(AttributeList attributeList, Shadow shadow) {
        AttributeList attributeList2 = (AttributeList)shadow.getAttributeList().clone();
        Enumeration enumeration = attributeList2.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attributeList.contains(attribute.getName())) continue;
            attribute.addFlags(768);
            attributeList.add(attribute);
        }
    }

    private void removeForwardedAttributes() {
        ContainerShadow containerShadow = this.getContainer();
        if (containerShadow == null) {
            return;
        }
        Enumeration enumeration = this.attributes.attributesWithFlags(512);
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (containerShadow.hasAttribute(attribute.getName())) continue;
            this.attributes.remove(attribute.getName());
        }
    }

    boolean hasAttributeForward(AttributeManager attributeManager, String string) {
        return this.forwardVector.contains(attributeManager) && this.attributes.get(string).flagged(256);
    }

    protected void addComponentAttributes() {
        this.addForwardedAttributes();
    }

    protected void addPanelAttributes() {
        this.addForwardedAttributes();
    }

    protected void addFrameAttributes() {
        this.addForwardedAttributes();
    }

    protected void addDialogAttributes() {
        this.addForwardedAttributes();
    }

    @Override
    public Object get(String string) {
        Attribute attribute = this.attributes.get(string);
        if (string.equals("name")) {
            return super.get(string);
        }
        if (string.equals("visible")) {
            return super.get(string);
        }
        if (!this.isInitialized) {
            return super.get(string);
        }
        if (attribute != null && attribute.flagged(256)) {
            Enumeration enumeration = this.forwardVector.elements();
            while (enumeration.hasMoreElements()) {
                AttributeManager attributeManager = (AttributeManager)enumeration.nextElement();
                if (!attributeManager.hasAttribute(string, attribute.getType())) continue;
                return attributeManager.get(string);
            }
            return null;
        }
        return this.getOnGroup(string);
    }

    protected Object getOnGroup(String string) {
        return super.get(string);
    }

    @Override
    public void set(String string, Object object) {
        Attribute attribute = this.attributes.get(string);
        if (string.equals("name")) {
            super.set(string, object);
        } else if (string.equals("visible")) {
            super.set(string, object);
            if (((Boolean)object).booleanValue()) {
                if (this.isVisible()) {
                    this.internalShowGroup();
                }
            } else {
                this.internalHideGroup();
            }
        } else if (!this.isInitialized) {
            super.set(string, object);
        } else if (attribute != null && attribute.flagged(256)) {
            super.set(string, object);
            Enumeration enumeration = this.forwardVector.elements();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                AttributeManager attributeManager = (AttributeManager)enumeration.nextElement();
                if (!attributeManager.hasAttribute(string, attribute.getType())) continue;
                attributeManager.set(string, object);
                bl = true;
            }
            if (bl && this.inDesignerRoot()) {
                DesignerAccess.setChangesMade(true);
            }
        } else {
            this.setOnGroup(string, object);
        }
    }

    protected void setOnGroup(String string, Object object) {
        super.set(string, object);
    }

    private boolean hasEnvironment() {
        if (this.hasEnvironment) {
            return true;
        }
        if (this.parentGroup != null) {
            return this.parentGroup.hasEnvironment();
        }
        return false;
    }

    public boolean isBase() {
        return this.hasEnvironment;
    }

    protected boolean isBaseWindow(Window window) {
        WindowShadow windowShadow = (WindowShadow)DesignerAccess.getShadowTable().get(window);
        return this.isBase() && this.getWindow() == windowShadow;
    }

    public boolean hasBase() {
        if (this.hasEnvironment) {
            return true;
        }
        if (this.parentGroup != null) {
            return this.parentGroup.hasBase();
        }
        return false;
    }

    public Group getBase() {
        if (this.hasEnvironment) {
            return this;
        }
        if (this.parentGroup != null) {
            return this.parentGroup.getBase();
        }
        return null;
    }

    boolean doingShow() {
        if (this.doingShow) {
            return true;
        }
        if (this.parentGroup != null) {
            return this.parentGroup.doingShow();
        }
        return false;
    }

    public void setEnvironmentInfo(Applet applet, String[] stringArray) {
        this.applet = applet;
        this.cmdLineArgs = stringArray;
        this.hasEnvironment = true;
    }

    public void setTopLevel(Frame frame) {
        this.topLevel = frame;
    }

    public void setCursor(int n) {
        if (this.root != null) {
            this.root.setCursor(n);
        }
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            Group group = (Group)enumeration.nextElement();
            group.setCursor(n);
        }
    }

    public Applet getApplet() {
        if (this.applet != null) {
            return this.applet;
        }
        if (this.parentGroup != null) {
            return this.parentGroup.getApplet();
        }
        return null;
    }

    public String[] getCmdLineArgs() {
        if (this.cmdLineArgs != null) {
            return this.cmdLineArgs;
        }
        if (this.parentGroup != null) {
            return this.parentGroup.getCmdLineArgs();
        }
        return null;
    }

    public Frame getFrame() {
        WindowShadow windowShadow = this.getWindow();
        if (windowShadow != null && windowShadow.getBody() != null) {
            if (windowShadow instanceof DialogShadow) {
                return (Frame)((Window)windowShadow.getBody()).getParent();
            }
            return (Frame)windowShadow.getBody();
        }
        if (this.parentGroup != null) {
            return this.parentGroup.getFrame();
        }
        return this.getTopLevel();
    }

    public Frame getTopLevel() {
        if (this.topLevel != null) {
            return this.topLevel;
        }
        if (this.parentGroup != null) {
            return this.parentGroup.getTopLevel();
        }
        return null;
    }

    public Registry getRegistry() {
        if (this.isBase()) {
            this.initRegistry();
            return this.registry;
        }
        if (this.parentGroup != null) {
            return this.parentGroup.getRegistry();
        }
        return null;
    }

    private synchronized void initRegistry() {
        if (this.registry == null) {
            this.registry = new Registry();
        }
    }

    @Override
    public void layoutMode() {
        super.layoutMode();
        WindowShadow windowShadow = this.getWindow();
        if (windowShadow != null) {
            windowShadow.setLayout(true);
        }
    }

    @Override
    public void previewMode() {
        super.previewMode();
        WindowShadow windowShadow = this.getWindow();
        if (windowShadow != null) {
            windowShadow.setPreview(true);
        }
    }

    @Override
    protected void preValidate() {
        PanelShadow panelShadow = this.getPanel();
        if (panelShadow != null) {
            panelShadow.preValidate();
        }
    }
}

