/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.base;

import java.util.Enumeration;
import java.util.StringTokenizer;
import sunsoft.jws.visual.rt.base.AMContainer;
import sunsoft.jws.visual.rt.base.Attribute;
import sunsoft.jws.visual.rt.base.AttributeManager;
import sunsoft.jws.visual.rt.base.DesignerAccess;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.base.VJException;

public class Shadow
extends AttributeManager {
    public static final int CONSTRUCTOR = 64;
    public static final int NONBODY = 128;
    protected Object body;

    public Object getBody() {
        return this.body;
    }

    @Override
    protected String getUserTypeName() {
        String string = "unknown";
        StringTokenizer stringTokenizer = new StringTokenizer(this.getClass().getName(), ".", false);
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        }
        int n = string.lastIndexOf("Shadow");
        if (n != -1) {
            string = string.substring(0, n);
        }
        if (string.length() > 0) {
            return string.toLowerCase();
        }
        return "shadow";
    }

    protected Object getOnBody(String string) {
        throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.base.Shadow.NoSuchKey", string));
    }

    @Override
    public Object get(String string) {
        if (this.attributes.contains(string = this.attributes.resolveAlias(string))) {
            Attribute attribute = this.attributes.get(string);
            if (this.body != null && !attribute.flagged(128)) {
                return this.getOnBody(string);
            }
            return attribute.getValue();
        }
        throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.base.Shadow.UnknownAttribute", string, this.getClass().getName()));
    }

    protected void setOnBody(String string, Object object) {
        throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.base.Shadow.NoSuchKey2", string));
    }

    @Override
    public void set(String string, Object object) {
        Attribute attribute = this.attributes.get(string = this.attributes.resolveAlias(string));
        if (attribute == null) {
            throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.base.Shadow.InvalidAttributeSet", string));
        }
        if (attribute.flagged(1)) {
            throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.base.Shadow.ReadOnlyAttributeSet", string));
        }
        if (attribute.flagged(64) && this.isCreated) {
            this.isCreated = false;
            this.refetchAttributeList();
            this.unregisterBody();
            this.destroyBody();
            if (this.body != null) {
                throw new Error(Global.getMsg("sunsoft.jws.visual.rt.base.Shadow.BodyNotDestroyed"));
            }
        }
        Object object2 = attribute.getValue();
        attribute.setValue(object);
        if (this.body != null && !attribute.flagged(128)) {
            try {
                this.setOnBody(string, object);
            }
            catch (VJException vJException) {
                attribute.setValue(object2);
                throw vJException;
            }
        }
        if (this.inDesignerRoot()) {
            DesignerAccess.setChangesMade(true);
        }
        if (this.parent != null && attribute.flagged(8)) {
            this.parent.updateContainerAttribute(this, string, object);
        }
    }

    @Override
    public void create() {
        if (!this.isCreated) {
            this.isCreated = true;
            if (this.getGroup() == null || !this.getGroup().hasBase()) {
                throw new Error(Global.getMsg("sunsoft.jws.visual.rt.base.Group.ShadowCreationWarning"));
            }
            if (this.body == null) {
                this.createBody();
            }
            if (this.body == null) {
                throw new Error(Global.getMsg("sunsoft.jws.visual.rt.base.Group.BodyNotCreated"));
            }
            this.registerBody();
            super.create();
            if (this.parent != null && this.body != null) {
                this.parent.addChildBody(this);
            }
            this.postCreate();
        } else {
            super.create();
            if (this.parent != null && this.body != null) {
                this.parent.addChildBody(this);
            }
        }
    }

    protected void postCreate() {
    }

    public void createBody() {
    }

    protected void registerBody() {
        DesignerAccess.getShadowTable().put(this.body, this);
        Enumeration enumeration = this.attributes.attributesWithoutFlags(129);
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (!attribute.isModified() && attribute.flagged(16)) continue;
            this.setOnBody(attribute.getName(), attribute.getValue());
        }
    }

    @Override
    public void recreate() {
        if (!this.isCreated) {
            this.isCreated = true;
            this.createBody();
            if (this instanceof AMContainer) {
                ((AMContainer)((Object)this)).reparentChildren();
            }
            this.registerBody();
            this.postCreate();
        }
        if (this.parent != null && this.body != null) {
            this.parent.addChildBody(this);
        }
    }

    @Override
    public void destroy() {
        if (this.isCreated) {
            this.isCreated = false;
            this.preDestroy();
            super.destroy();
            this.unregisterBody();
            this.destroyBody();
            if (this.body != null) {
                throw new Error(Global.getMsg("sunsoft.jws.visual.rt.base.Shadow.BodyNotDestroyed"));
            }
        } else {
            super.destroy();
        }
    }

    protected void preDestroy() {
    }

    protected void destroyBody() {
        this.body = null;
    }

    protected void unregisterBody() {
        if (this.body != null) {
            if (this.parent != null && this.body != null) {
                this.parent.removeChildBody(this);
            }
            DesignerAccess.getShadowTable().remove(this.body);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "[" + "," + "body=" + (this.body == null ? "null" : this.body.toString()) + "]";
    }
}

