/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.shadow;

import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Label;
import java.awt.Window;
import sunsoft.jws.visual.rt.awt.RootDialog;
import sunsoft.jws.visual.rt.awt.RootFrame;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.base.Message;
import sunsoft.jws.visual.rt.base.VJException;
import sunsoft.jws.visual.rt.shadow.java.awt.WindowShadow;

public class GenericWindowShadow
extends WindowShadow {
    private String className;
    private Class genericClass;

    public GenericWindowShadow() {
        this.attributes.add("class", "java.lang.String", "sunsoft.jws.visual.rt.awt.RootFrame", 1024);
        this.attributes.add("title", "java.lang.String", "Generic Window", 1024);
        this.attributes.alias("text", "title");
        if (Global.isIrix()) {
            this.attributes.add("font", "java.awt.Font", new Font("Sansserif", 0, 12), 32);
        }
        if (Global.isWindows()) {
            this.attributes.add("background", "java.awt.Color", Color.lightGray, 32);
            this.attributes.add("font", "java.awt.Font", new Font("Dialog", 0, 12), 32);
        }
    }

    @Override
    protected boolean useLayoutSize() {
        return false;
    }

    @Override
    protected Object getOnBody(String string) {
        if (string.equals("class")) {
            return this.getFromTable("class");
        }
        if (string.equals("title")) {
            if (this.body instanceof RootFrame) {
                return ((RootFrame)this.body).getTitle();
            }
            return ((RootDialog)this.body).getTitle();
        }
        return super.getOnBody(string);
    }

    @Override
    protected void setOnBody(String string, Object object) {
        if (string.equals("class")) {
            if (this.className.equals((String)object)) {
                return;
            }
            Object object2 = this.loadClass((String)object);
            this.destroy();
            this.body = object2;
            this.create();
        } else if (string.equals("title")) {
            if (this.body instanceof RootFrame) {
                ((RootFrame)this.body).setTitle((String)object);
            } else {
                ((RootDialog)this.body).setTitle((String)object);
            }
        } else {
            super.setOnBody(string, object);
        }
    }

    @Override
    public void createBody() {
        this.body = this.loadClass((String)this.get("class"));
    }

    @Override
    protected void registerBody() {
        super.registerBody();
        Window window = (Window)this.body;
        if (window.countComponents() == 0) {
            window.add(new Label("Generic Window"));
        }
    }

    private Object loadClass(String string) {
        Object obj;
        Class<?> clazz;
        if (!string.equals(this.className)) {
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new VJException(Global.fmtMsg("sunsoft.jws.visual.rt.shadow.GenericWindowShadow.Class__not__found", string));
            }
        } else {
            clazz = this.genericClass;
        }
        try {
            obj = clazz.newInstance();
            if (!(obj instanceof RootFrame) && !(obj instanceof RootDialog)) {
                throw new VJException(Global.fmtMsg("sunsoft.jws.visual.rt.shadow.GenericWindowShadow.NotARootSubclass", string));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new VJException(Global.fmtMsg("sunsoft.jws.visual.rt.shadow.GenericWindowShadow.IllegalAccess", string));
        }
        catch (InstantiationException instantiationException) {
            throw new VJException(Global.fmtMsg("sunsoft.jws.visual.rt.shadow.GenericWindowShadow.InstantiationException", string));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new VJException(Global.fmtMsg("sunsoft.jws.visual.rt.shadow.GenericWindowShadow.Noconstructor", string));
        }
        this.genericClass = clazz;
        this.className = string;
        return obj;
    }

    @Override
    public boolean handleEvent(Message message, Event event) {
        if (message.target == this && event.id == 201) {
            Window window = (Window)this.body;
            window.hide();
            return true;
        }
        return super.handleEvent(message, event);
    }
}

