/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.shadow.java.awt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import sunsoft.jws.visual.rt.awt.RootDialog;
import sunsoft.jws.visual.rt.base.AttributeManager;
import sunsoft.jws.visual.rt.base.DesignerAccess;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.base.Group;
import sunsoft.jws.visual.rt.base.Root;
import sunsoft.jws.visual.rt.base.Shadow;
import sunsoft.jws.visual.rt.shadow.java.awt.ContainerShadow;
import sunsoft.jws.visual.rt.shadow.java.awt.FrameShadow;
import sunsoft.jws.visual.rt.shadow.java.awt.WindowShadow;
import sunsoft.jws.visual.rt.type.AMRef;

public class DialogShadow
extends WindowShadow {
    protected Frame dialogFrame;

    public DialogShadow() {
        this.attributes.add("frame", "sunsoft.jws.visual.rt.type.AMRef", null, 194);
        this.attributes.alias("text", "title");
        this.attributes.add("title", "java.lang.String", Global.getMsg("sunsoft.jws.visual.rt.shadow.java.awt.DialogShadow.title"), 1024);
        this.attributes.add("modal", "java.lang.Boolean", Boolean.FALSE, 64);
        this.attributes.add("resizable", "java.lang.Boolean", Boolean.TRUE, 0);
    }

    @Override
    protected Object getOnBody(String string) {
        if (this.body instanceof Dialog) {
            return this.getOnDialogBody(string);
        }
        return this.getOnFrameBody(string);
    }

    private Object getOnDialogBody(String string) {
        Dialog dialog = (Dialog)this.body;
        if (string.equals("modal")) {
            if (this.isLive()) {
                return new Boolean(dialog.isModal());
            }
            return this.getFromTable("modal");
        }
        if (string.equals("resizable")) {
            return new Boolean(dialog.isResizable());
        }
        if (string.equals("title")) {
            return dialog.getTitle();
        }
        return super.getOnBody(string);
    }

    private Object getOnFrameBody(String string) {
        Frame frame = (Frame)this.body;
        if (string.equals("modal")) {
            return this.getFromTable("modal");
        }
        if (string.equals("resizable")) {
            return new Boolean(frame.isResizable());
        }
        if (string.equals("title")) {
            return frame.getTitle();
        }
        return super.getOnBody(string);
    }

    @Override
    protected void setOnBody(String string, Object object) {
        if (this.body instanceof Dialog) {
            this.setOnDialogBody(string, object);
        } else {
            this.setOnFrameBody(string, object);
        }
    }

    private void setOnDialogBody(String string, Object object) {
        Dialog dialog = (Dialog)this.body;
        if (string.equals("modal")) {
            return;
        }
        if (string.equals("resizable")) {
            dialog.setResizable((Boolean)object);
        } else if (string.equals("title")) {
            dialog.setTitle((String)object);
        } else {
            super.setOnBody(string, object);
        }
    }

    private void setOnFrameBody(String string, Object object) {
        Frame frame = (Frame)this.body;
        if (string.equals("modal")) {
            return;
        }
        if (string.equals("resizable")) {
            frame.setResizable((Boolean)object);
        } else if (string.equals("title")) {
            frame.setTitle((String)object);
        } else {
            super.setOnBody(string, object);
        }
    }

    @Override
    public void create() {
        if (!this.isCreated() && Global.isWindows()) {
            this.createBody();
            if (!(this.body instanceof Dialog) && this.attributes.get("font").flagged(16)) {
                this.attributes.add("font", "java.awt.Font", new Font("Dialog", 0, 12), 32);
            }
        }
        super.create();
    }

    @Override
    public void createBody() {
        this.dialogFrame = this.getFrame();
        if (!this.inDesignerRoot()) {
            boolean bl = this.isLive() ? (Boolean)this.getFromTable("modal") : false;
            String string = (String)this.getFromTable("title");
            RootDialog rootDialog = new RootDialog(this.dialogFrame, string, bl);
            this.body = rootDialog;
        } else {
            try {
                this.body = DesignerAccess.getDialogClass().newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new Error(instantiationException.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Error(illegalAccessException.toString());
            }
        }
    }

    @Override
    public void showComponent() {
        if (this.dialogFrame != null && this.dialogFrame.getPeer() == null) {
            this.dialogFrame.addNotify();
        }
        super.showComponent();
    }

    protected Frame getFrame() {
        Frame frame;
        AMRef aMRef = (AMRef)this.getFromTable("frame");
        if (aMRef != null) {
            FrameShadow frameShadow;
            AttributeManager attributeManager = this.getForwardingGroup("frame");
            if (attributeManager == null) {
                attributeManager = this;
            }
            if ((frameShadow = (FrameShadow)aMRef.getRef(attributeManager)) == null) {
                throw new Error(Global.getMsg("sunsoft.jws.visual.rt.awt.java.awt.DialogShadow.NullFrameShadow"));
            }
            frame = this.getFrameBody(frameShadow);
        } else {
            frame = this.lookupFrame();
        }
        if (frame == null) {
            throw new Error(Global.getMsg("sunsoft.jws.visual.rt.awt.java.awt.DialogShadow.NullFrame"));
        }
        return frame;
    }

    private Frame lookupFrame() {
        Boolean bl;
        Object object;
        Root root = this.getRoot();
        AttributeManager attributeManager = root.getMainChild();
        if (attributeManager instanceof Group) {
            attributeManager = DesignerAccess.getContainer((Group)attributeManager);
        }
        if (attributeManager instanceof FrameShadow) {
            return this.getFrameBody((FrameShadow)attributeManager);
        }
        if (attributeManager != this) {
            object = root.getChildList();
            while (object.hasMoreElements()) {
                attributeManager = (AttributeManager)object.nextElement();
                if (!(attributeManager instanceof FrameShadow) || !(bl = (Boolean)attributeManager.get("visible")).booleanValue()) continue;
                return this.getFrameBody((FrameShadow)attributeManager);
            }
        }
        if ((object = this.lookupGroupFrame(root.getGroup())) != null && (bl = (Boolean)attributeManager.get("visible")).booleanValue()) {
            return this.getFrameBody((FrameShadow)object);
        }
        return this.getGroup().getTopLevel();
    }

    private Frame getFrameBody(FrameShadow frameShadow) {
        Frame frame = (Frame)frameShadow.getBody();
        if (frame == null) {
            frameShadow.createBody();
            frame = (Frame)frameShadow.getBody();
        }
        return frame;
    }

    private FrameShadow lookupGroupFrame(Group group) {
        if (group == null) {
            return null;
        }
        ContainerShadow containerShadow = DesignerAccess.getContainer(group);
        if (containerShadow instanceof FrameShadow) {
            return (FrameShadow)containerShadow;
        }
        return this.lookupGroupFrame(group.getParentGroup());
    }

    @Override
    public void addChildBody(Shadow shadow) {
        if (this.body != null) {
            Container container = (Container)this.body;
            if (container.getLayout() instanceof BorderLayout && this.getChildCount() == 1) {
                container.add("Center", (Component)shadow.getBody());
            } else {
                super.addChildBody(shadow);
            }
        }
    }
}

