/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.shadow.java.awt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import sunsoft.jws.visual.rt.awt.RootFrame;
import sunsoft.jws.visual.rt.base.DesignerAccess;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.base.Shadow;
import sunsoft.jws.visual.rt.base.VJException;
import sunsoft.jws.visual.rt.shadow.java.awt.MenuBarShadow;
import sunsoft.jws.visual.rt.shadow.java.awt.WindowShadow;
import sunsoft.jws.visual.rt.type.ImageRef;

public class FrameShadow
extends WindowShadow {
    private int cursorCount = 0;
    private int prevCursor = 0;

    public FrameShadow() {
        this.attributes.add("title", "java.lang.String", Global.getMsg("sunsoft.jws.visual.rt.shadow.java.awt.FrameShadow.title"), 1024);
        this.attributes.alias("text", "title");
        this.attributes.add("resizable", "java.lang.Boolean", Boolean.TRUE, 0);
        this.attributes.add("icon", "sunsoft.jws.visual.rt.type.ImageRef", null, 0);
        this.attributes.add("menubar", "sunsoft.jws.visual.rt.shadow.java.awt.MenuBarShadow", null, 20);
        if (Global.isIrix()) {
            this.attributes.add("font", "java.awt.Font", new Font("Sansserif", 0, 12), 32);
        }
        if (Global.isWindows()) {
            this.attributes.add("font", "java.awt.Font", new Font("Dialog", 0, 12), 32);
        }
    }

    @Override
    protected Object getOnBody(String string) {
        Frame frame = (Frame)this.body;
        if (string.equals("title")) {
            return frame.getTitle();
        }
        if (string.equals("resizable")) {
            return new Boolean(frame.isResizable());
        }
        if (string.equals("icon")) {
            return this.getFromTable("icon");
        }
        if (string.equals("menubar")) {
            MenuBar menuBar = frame.getMenuBar();
            if (menuBar == null) {
                return null;
            }
            return DesignerAccess.getShadowTable().get(menuBar);
        }
        return super.getOnBody(string);
    }

    @Override
    protected void setOnBody(String string, Object object) {
        Frame frame = (Frame)this.body;
        if (string.equals("title")) {
            frame.setTitle((String)object);
        } else if (string.equals("resizable")) {
            frame.setResizable((Boolean)object);
        } else if (string.equals("menubar")) {
            MenuBarShadow menuBarShadow = (MenuBarShadow)this.getOnBody("menubar");
            if (menuBarShadow != null) {
                this.remove(menuBarShadow);
                menuBarShadow.destroy();
            }
            if (object != null) {
                menuBarShadow = (MenuBarShadow)object;
                this.add(menuBarShadow);
                menuBarShadow.create();
            }
        } else if (string.equals("icon")) {
            if (object != null) {
                try {
                    frame.setIconImage(((ImageRef)object).getImage(frame, this.getGroup().getApplet()));
                }
                catch (VJException vJException) {
                    if (this.isLive()) {
                        System.out.println("Error: " + vJException.getMessage());
                    }
                    throw vJException;
                }
            } else if (frame.getPeer() == null) {
                frame.setIconImage(null);
            }
        } else {
            super.setOnBody(string, object);
        }
    }

    @Override
    protected String getUserTypeName() {
        return "frame";
    }

    @Override
    public void createBody() {
        if (!this.inDesignerRoot()) {
            this.body = new RootFrame();
        } else {
            try {
                this.body = DesignerAccess.getFrameClass().newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new Error(instantiationException.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Error(illegalAccessException.toString());
            }
        }
    }

    @Override
    public void addChildBody(Shadow shadow) {
        if (this.body != null) {
            Frame frame = (Frame)this.body;
            if (shadow instanceof MenuBarShadow) {
                MenuBar menuBar = frame.getMenuBar();
                if (menuBar != null && menuBar != shadow.getBody()) {
                    throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.awt.java.awt.FrameShadow.AlreadyHasMenubar", shadow.get("name")));
                }
                frame.setMenuBar((MenuBar)shadow.getBody());
            } else if (frame.getLayout() instanceof BorderLayout) {
                frame.add("Center", (Component)shadow.getBody());
            } else {
                super.addChildBody(shadow);
            }
        }
    }

    @Override
    public void removeChildBody(Shadow shadow) {
        if (this.body != null) {
            if (shadow instanceof MenuBarShadow) {
                if (!((Frame)this.body).getMenuBar().equals((MenuBar)shadow.getBody())) {
                    throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.awt.java.awt.FrameShadow.MenubarNotInstalled", shadow.get("name")));
                }
                ((Frame)this.body).remove((MenuComponent)shadow.getBody());
            } else {
                ((Frame)this.body).remove((Component)shadow.getBody());
            }
        }
    }

    int incrCursor() {
        ++this.cursorCount;
        return this.cursorCount;
    }

    int decrCursor() {
        --this.cursorCount;
        if (this.cursorCount < 0) {
            this.cursorCount = 0;
        }
        return this.cursorCount;
    }

    void setPrevCursor(int n) {
        this.prevCursor = n;
    }

    int getPrevCursor() {
        return this.prevCursor;
    }
}

