/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.shadow.java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import sunsoft.jws.visual.rt.awt.GBConstraints;
import sunsoft.jws.visual.rt.awt.GBLayout;
import sunsoft.jws.visual.rt.awt.RootWindow;
import sunsoft.jws.visual.rt.base.AttributeList;
import sunsoft.jws.visual.rt.base.AttributeManager;
import sunsoft.jws.visual.rt.base.DesignerAccess;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.base.Group;
import sunsoft.jws.visual.rt.base.Message;
import sunsoft.jws.visual.rt.base.Shadow;
import sunsoft.jws.visual.rt.base.VJException;
import sunsoft.jws.visual.rt.shadow.java.awt.ContainerShadow;
import sunsoft.jws.visual.rt.shadow.java.awt.PanelShadow;
import sunsoft.jws.visual.rt.type.AnchorEnum;

public class WindowShadow
extends ContainerShadow {
    private static final int PADX = 100;
    private static final int PADY = 100;
    private static Point defaultLocation = new Point(100, 100);
    private static Dimension defaultSize = new Dimension(100, 100);
    private boolean packed = false;
    private boolean layoutMode = false;
    private boolean isPanel = false;
    private String prevTitle = "Unnamed Window";
    private static Class enclosingFrame = null;

    public static void setDefaultLocation(Point point) {
        defaultLocation = point;
    }

    public static Point getDefaultLocation() {
        return defaultLocation;
    }

    public static void setDefaultSize(Dimension dimension) {
        defaultSize = dimension;
    }

    public static Dimension getDefaultSize() {
        return defaultSize;
    }

    public WindowShadow() {
        this.attributes.remove("GBConstraints");
        this.attributes.remove("borderName");
        this.attributes.remove("flowRank");
        this.attributes.remove("anchor");
        this.attributes.remove("insets");
        this.attributes.add("visible", "java.lang.Boolean", Boolean.TRUE, 128);
        this.attributes.add("location", "java.awt.Point", null, 0);
        this.attributes.add("layoutLocation", "java.awt.Point", null, 2);
        this.attributes.add("currentLocation", "java.awt.Point", null, 7);
        this.attributes.add("size", "java.awt.Dimension", null, 0);
        this.attributes.add("layoutSize", "java.awt.Dimension", null, 2);
        this.attributes.add("currentSize", "java.awt.Dimension", null, 7);
    }

    protected boolean useLayoutLocation() {
        if (!this.layoutMode) {
            return false;
        }
        if (this.inDesignerRoot()) {
            return true;
        }
        Group group = this.getGroup();
        if (group == null) {
            return false;
        }
        if (DesignerAccess.getWindow(group) != this) {
            return false;
        }
        return group.inDesignerRoot();
    }

    protected boolean useLayoutSize() {
        return this.layoutMode && this.inDesignerRoot();
    }

    @Override
    protected Object getOnBody(String string) {
        Window window = (Window)this.body;
        if (string.equals("location")) {
            return this.getFromTable(string);
        }
        if (string.equals("layoutLocation")) {
            if (this.useLayoutLocation()) {
                Point point;
                try {
                    point = window.getLocationOnScreen();
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    point = window.getLocation();
                }
                return point;
            }
            return this.getFromTable(string);
        }
        if (string.equals("currentLocation")) {
            return window.location();
        }
        if (string.equals("size")) {
            return this.getFromTable(string);
        }
        if (string.equals("layoutSize")) {
            if (this.useLayoutSize()) {
                return window.size();
            }
            return this.getFromTable(string);
        }
        if (string.equals("currentSize")) {
            return window.size();
        }
        return super.getOnBody(string);
    }

    @Override
    protected void setOnBody(String string, Object object) {
        Window window = (Window)this.body;
        if (string.equals("location")) {
            this.putInTable(string, object);
            if (object != null && !this.useLayoutLocation()) {
                Point point = this.getWindowLocation(false);
                window.move(point.x, point.y);
            }
        } else if (string.equals("layoutLocation")) {
            this.putInTable(string, object);
            if (object != null && this.useLayoutLocation()) {
                Point point = this.getWindowLocation(true);
                window.move(point.x, point.y);
            }
        } else if (string.equals("size")) {
            this.putInTable(string, object);
            if (object != null && !this.useLayoutSize()) {
                window.resize(this.getWindowSize(window, false));
            }
        } else if (string.equals("layoutSize")) {
            this.putInTable(string, object);
            if (object != null && this.useLayoutSize()) {
                window.resize(this.getWindowSize(window, true));
            }
        } else {
            super.setOnBody(string, object);
        }
    }

    @Override
    public void createBody() {
    }

    @Override
    protected void registerBody() {
        Window window = (Window)this.body;
        if (!(window.getLayout() instanceof GBLayout)) {
            GBLayout gBLayout = new GBLayout();
            double[] dArray = new double[]{1.0};
            gBLayout.columnWeights = dArray;
            gBLayout.rowWeights = dArray;
            window.setLayout(gBLayout);
        }
        super.registerBody();
    }

    @Override
    protected void postCreate() {
        super.postCreate();
        if (this.body instanceof RootWindow) {
            if (this.layoutMode) {
                ((RootWindow)this.body).layoutMode();
            } else {
                ((RootWindow)this.body).previewMode();
            }
        }
        if (!this.doingShow()) {
            this.showComponent(this.isVisible());
        }
    }

    @Override
    protected void preDestroy() {
        this.packed = false;
    }

    public boolean isVisible() {
        if (!this.hasAttribute("visible")) {
            return false;
        }
        Boolean bl = (Boolean)this.getFromTable("visible");
        if (!bl.booleanValue()) {
            return false;
        }
        Group group = this.getRoot().getGroup();
        if (group != null) {
            return group.isShowing();
        }
        return true;
    }

    @Override
    public void updateContainerAttribute(AttributeManager attributeManager, String string, Object object) {
        if (string.equals("anchor")) {
            GBConstraints gBConstraints = (GBConstraints)attributeManager.get("GBConstraints");
            if (gBConstraints == null) {
                return;
            }
            int n = ((AnchorEnum)object).intValue();
            if (n != gBConstraints.anchor) {
                gBConstraints.anchor = n;
                attributeManager.set("GBConstraints", gBConstraints);
            }
        } else if (string.equals("insets")) {
            GBConstraints gBConstraints = (GBConstraints)attributeManager.get("GBConstraints");
            if (gBConstraints == null) {
                return;
            }
            Insets insets = (Insets)object;
            if (gBConstraints.insets != insets) {
                gBConstraints.insets = insets;
                attributeManager.set("GBConstraints", gBConstraints);
            }
        } else if (string.equals("GBConstraints")) {
            int n;
            Shadow shadow;
            Component component;
            GBConstraints gBConstraints = (GBConstraints)object;
            if (gBConstraints == null) {
                gBConstraints = new GBConstraints();
            }
            if ((component = (Component)(shadow = (Shadow)attributeManager).getBody()) == null) {
                return;
            }
            gBConstraints.anchor = n = ((AnchorEnum)attributeManager.get("anchor")).intValue();
            gBConstraints.insets = (Insets)attributeManager.get("insets");
            GBLayout gBLayout = (GBLayout)((Window)this.body).getLayout();
            gBLayout.setConstraints(component, gBConstraints);
        }
    }

    public void pack() {
        boolean bl;
        this.checkCreate();
        Window window = (Window)this.body;
        boolean bl2 = bl = window.getPeer() != null;
        if (!bl) {
            Object object;
            if (Global.isIrix()) {
                object = window.size();
                if (((Dimension)object).width == 0 || ((Dimension)object).height == 0) {
                    window.reshape(0, 0, 40, 40);
                }
            }
            window.addNotify();
            object = this.getGroup();
            if (object != null && DesignerAccess.getWindow((Group)object) == this) {
                DesignerAccess.preValidate((Group)object);
            }
            this.preValidate();
        }
        this.resizePreferredSize(window, bl);
        window.validate();
        this.packed = true;
    }

    @Override
    public void showComponent() {
        this.checkCreate();
        Window window = (Window)this.body;
        if (this.packed && window.getPeer() == null) {
            this.packed = false;
        }
        if (!this.packed) {
            this.pack();
        }
        window.show();
        if (Global.isWindows()) {
            window.toFront();
        }
        window.getToolkit().sync();
    }

    protected void checkCreate() {
        if (!this.isCreated()) {
            this.doingShow = true;
            this.create();
            this.doingShow = false;
        }
    }

    private void resizePreferredSize(Window window, boolean bl) {
        Point point = this.getWindowLocation(this.useLayoutLocation());
        Dimension dimension = this.getWindowSize(window, this.useLayoutSize());
        this.constrainToScreen(window, point, dimension);
        if (window instanceof Dialog) {
            if (Global.isMotif() && !bl) {
                point.x -= dimension.width / 2;
                point.y -= dimension.height / 2;
            }
            window.reshape(point.x, point.y, dimension.width, dimension.height);
        } else if (bl) {
            window.resize(dimension.width, dimension.height);
        } else {
            window.reshape(point.x, point.y, dimension.width, dimension.height);
        }
    }

    private Point getDialogLocation(Dialog dialog) {
        Frame frame = (Frame)dialog.getParent();
        Point point = frame.location();
        Dimension dimension = frame.size();
        Dimension dimension2 = dialog.preferredSize();
        point.x += (dimension.width - dimension2.width) / 2;
        point.y += (dimension.height - dimension2.height) / 2;
        return point;
    }

    private Point getWindowLocation(boolean bl) {
        if (this.body instanceof Dialog) {
            return this.getDialogLocation((Dialog)this.body);
        }
        ContainerShadow containerShadow = this.getPanel();
        Point point = null;
        if (bl) {
            point = containerShadow != null ? (Point)containerShadow.get("layoutLocation") : (Point)this.getFromTable("layoutLocation");
            if (point == null) {
                point = WindowShadow.getDefaultLocation();
            }
        } else {
            point = (Point)this.getFromTable("location");
            if (point == null) {
                point = WindowShadow.getDefaultLocation();
            }
        }
        return point;
    }

    private Dimension getWindowSize(Window window, boolean bl) {
        Dimension dimension;
        ContainerShadow containerShadow = this.getPanel();
        if (bl) {
            dimension = containerShadow != null ? (Dimension)containerShadow.get("layoutSize") : (Dimension)this.getFromTable("layoutSize");
            if (dimension == null) {
                dimension = WindowShadow.getDefaultSize();
            }
        } else {
            Dimension dimension2 = window.preferredSize();
            dimension = (Dimension)this.getFromTable("size");
            if (dimension == null) {
                dimension = dimension2;
            } else {
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
            }
        }
        return dimension;
    }

    private void constrainToScreen(Window window, Point point, Dimension dimension) {
        int n;
        int n2;
        int n3;
        Dimension dimension2 = this.getScreenSize(window);
        int n4 = dimension2.width - dimension.width;
        if (point.x > n4) {
            point.x = n4;
        }
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y > (n3 = dimension2.height - dimension.height)) {
            point.y = n3;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        if (dimension.width > (n2 = dimension2.width - point.x)) {
            dimension.width = n2;
        }
        if (dimension.height > (n = dimension2.height - point.y)) {
            dimension.height = n;
        }
    }

    private Dimension getScreenSize(Window window) {
        Dimension dimension = window.getToolkit().getScreenSize();
        dimension.width -= 6;
        dimension.height -= 6;
        if (Global.isWindows95()) {
            dimension.height -= 30;
        }
        return dimension;
    }

    private void recurseInvalidate(Component component) {
        component.invalidate();
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.countComponents();
            for (int i = 0; i < n; ++i) {
                this.recurseInvalidate(container.getComponent(i));
            }
        }
    }

    @Override
    protected void destroyBody() {
        if (this.useLayoutLocation()) {
            Point point = ((Window)this.body).location();
            this.putInTable("layoutLocation", point);
        }
        ((Window)this.body).dispose();
        this.body = null;
    }

    public boolean isPanel() {
        return this.isPanel;
    }

    public void isPanel(boolean bl) {
        if (this.isPanel != bl) {
            if (bl) {
                this.prevTitle = (String)this.get("title");
                this.set("title", "PANEL");
                this.isPanel = bl;
            } else {
                String string;
                this.isPanel = bl;
                if (!(this.getRoot() == null || (string = (String)this.get("name")) != null && DesignerAccess.isUniqueName(this.getRoot(), string, this))) {
                    this.set("name", DesignerAccess.getUniqueName(this.getRoot(), this));
                }
                this.set("title", this.prevTitle);
            }
        }
    }

    public ContainerShadow getPanel() {
        if (!this.isPanel) {
            return null;
        }
        if (this.getChildCount() == 0) {
            return null;
        }
        return (ContainerShadow)this.getChildList().nextElement();
    }

    private Class getEnclosingFrameClass() {
        if (enclosingFrame == null) {
            enclosingFrame = DesignerAccess.getFrameClass();
        }
        return enclosingFrame;
    }

    private boolean isEnclosingFrame(Object object) {
        Class clazz = this.getEnclosingFrameClass();
        return clazz != null && clazz.isInstance(this.body);
    }

    protected void setOnPanel(String string, Object object) {
        ContainerShadow containerShadow = (ContainerShadow)this.getChildList().nextElement();
        if (containerShadow != null && containerShadow instanceof PanelShadow) {
            containerShadow.set(string, object);
        }
    }

    protected Object getOnPanel(String string) {
        ContainerShadow containerShadow = (ContainerShadow)this.getChildList().nextElement();
        if (containerShadow != null && containerShadow instanceof PanelShadow) {
            return containerShadow.get(string);
        }
        return null;
    }

    @Override
    public void set(String string, Object object) {
        ContainerShadow containerShadow = this.getPanel();
        if (!(containerShadow == null || string.equals("location") || string.equals("layoutLocation") || string.equals("size") || string.equals("layoutSize"))) {
            containerShadow.set(string, object);
        } else if (string.equals("visible")) {
            if (!this.hasAttribute("visible")) {
                return;
            }
            Boolean bl = (Boolean)this.get("visible");
            Boolean bl2 = (Boolean)object;
            if (this.inDesignerRoot() && this.isMainContainer() && !bl2.booleanValue()) {
                throw new VJException(Global.getMsg("sunsoft.jws.visual.rt.awt.java.awt.WindowShadow.IllegalSetVisible"));
            }
            super.set(string, object);
            if (!this.doingShow() && bl.booleanValue() != bl2.booleanValue()) {
                this.showComponent(this.isVisible());
            }
        } else {
            if (this.isEnclosingFrame(this.body) && (string.equals("background") || string.equals("foreground"))) {
                this.setOnPanel(string, object);
                return;
            }
            super.set(string, object);
        }
    }

    @Override
    public Object get(String string) {
        ContainerShadow containerShadow = this.getPanel();
        if (!(containerShadow == null || string.equals("location") || string.equals("layoutLocation") || string.equals("size") || string.equals("layoutSize"))) {
            return containerShadow.get(string);
        }
        if (this.isEnclosingFrame(this.body) && (string.equals("background") || string.equals("foreground"))) {
            return this.getOnPanel(string);
        }
        return super.get(string);
    }

    @Override
    public String getType(String string) {
        ContainerShadow containerShadow = this.getPanel();
        if (containerShadow != null) {
            return containerShadow.getType(string);
        }
        return super.getType(string);
    }

    @Override
    public int getFlags(String string) {
        ContainerShadow containerShadow = this.getPanel();
        if (containerShadow != null) {
            return containerShadow.getFlags(string);
        }
        return super.getFlags(string);
    }

    @Override
    public boolean hasAttribute(String string) {
        ContainerShadow containerShadow = this.getPanel();
        if (containerShadow != null) {
            return containerShadow.hasAttribute(string);
        }
        return super.hasAttribute(string);
    }

    @Override
    public boolean hasAttribute(String string, String string2) {
        ContainerShadow containerShadow = this.getPanel();
        if (containerShadow != null) {
            return containerShadow.hasAttribute(string, string2);
        }
        return super.hasAttribute(string, string2);
    }

    @Override
    public AttributeList getAttributeList() {
        ContainerShadow containerShadow = this.getPanel();
        if (containerShadow != null) {
            return containerShadow.getAttributeList();
        }
        return super.getAttributeList();
    }

    @Override
    public void refetchAttributeList() {
        ContainerShadow containerShadow = this.getPanel();
        if (containerShadow != null) {
            containerShadow.refetchAttributeList();
        } else {
            super.refetchAttributeList();
        }
    }

    @Override
    public void layoutMode() {
        super.layoutMode();
        this.setLayout(true);
    }

    @Override
    public void previewMode() {
        super.previewMode();
        this.setPreview(true);
    }

    public void setLayout(boolean bl) {
        if (this.layoutMode) {
            return;
        }
        this.layoutMode = true;
        if (this.body != null) {
            Window window = (Window)this.body;
            if (this.body instanceof RootWindow) {
                ((RootWindow)this.body).layoutMode();
            }
            if (bl) {
                if (window.getPeer() != null && (this.useLayoutLocation() || this.useLayoutSize())) {
                    Point point = this.getWindowLocation(this.useLayoutLocation());
                    Dimension dimension = this.getWindowSize(window, this.useLayoutSize());
                    window.reshape(point.x, point.y, dimension.width, dimension.height);
                }
                window.validate();
            }
        }
    }

    public void setPreview(boolean bl) {
        if (!this.layoutMode) {
            return;
        }
        if (this.body != null) {
            Window window = (Window)this.body;
            if (window instanceof RootWindow) {
                ((RootWindow)((Object)window)).previewMode();
            }
            if (bl) {
                if (window.getPeer() != null) {
                    if (this.useLayoutLocation()) {
                        this.putInTable("layoutLocation", window.location());
                    }
                    if (this.useLayoutSize()) {
                        this.putInTable("layoutSize", window.size());
                    }
                    if (this.useLayoutLocation() || this.useLayoutSize()) {
                        Point point = this.getWindowLocation(this.useLayoutLocation());
                        Dimension dimension = this.getWindowSize(window, false);
                        this.constrainToScreen(window, point, dimension);
                        window.reshape(point.x, point.y, dimension.width, dimension.height);
                    }
                }
                window.validate();
            }
        }
        this.layoutMode = false;
    }

    public Dimension previewSize() {
        boolean bl = this.layoutMode;
        if (bl) {
            this.setPreview(false);
            super.previewMode();
        }
        Dimension dimension = ((Window)this.body).preferredSize();
        dimension = new Dimension(dimension.width, dimension.height);
        if (bl) {
            this.setLayout(false);
            super.layoutMode();
        }
        return dimension;
    }

    @Override
    public boolean handleEvent(Message message, Event event) {
        ContainerShadow containerShadow;
        if (message.target == this && event.id == 205 && (containerShadow = this.getPanel()) != null) {
            boolean bl = DesignerAccess.getChangesMade();
            containerShadow.set("layoutLocation", this.get("layoutLocation"));
            containerShadow.set("layoutSize", this.get("layoutSize"));
            DesignerAccess.setChangesMade(bl);
        }
        return super.handleEvent(message, event);
    }
}

