/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.type;

import java.awt.Color;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.type.ColorStore;
import sunsoft.jws.visual.rt.type.Converter;
import sunsoft.jws.visual.rt.type.ParseException;

public class ColorConverter
extends Converter {
    @Override
    public String convertToString(Object object) {
        Color color = (Color)object;
        if (color == null) {
            return "";
        }
        String string = ColorStore.getDefaultColorStore().getColorName(color);
        if (string != null) {
            return string;
        }
        int n = color.getRGB();
        StringBuffer stringBuffer = new StringBuffer(Integer.toString(n &= 0xFFFFFF, 16));
        while (stringBuffer.length() < 6) {
            stringBuffer.insert(0, '0');
        }
        return "#" + stringBuffer.toString();
    }

    @Override
    public Object convertFromString(String string) {
        Integer n;
        if (string == null || string.length() == 0) {
            return null;
        }
        Color color = ColorStore.getDefaultColorStore().getColor(string);
        if (color != null) {
            return color;
        }
        if (!string.startsWith("#")) {
            throw new ParseException(Global.getMsg("sunsoft.jws.visual.rt.type.ColorConverter.Illegal__color__value-co-.18") + string);
        }
        try {
            n = Integer.valueOf(string.substring(1), 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(Global.getMsg("sunsoft.jws.visual.rt.type.ColorConverter.Badly__formatted__colo.19") + string);
        }
        int n2 = n;
        color = new Color(n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 >> 0 & 0xFF);
        return color;
    }
}

