/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.type;

import java.util.StringTokenizer;
import java.util.Vector;
import sunsoft.jws.visual.rt.base.Attribute;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.type.Converter;
import sunsoft.jws.visual.rt.type.ParseException;

public class DoubleArrayConverter
extends Converter {
    @Override
    public String convertToString(Object object) {
        if (object != null) {
            double[] dArray = (double[])object;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < dArray.length; ++i) {
                stringBuffer.append(dArray[i]);
                if (i == dArray.length - 1) continue;
                stringBuffer.append(",");
            }
            return stringBuffer.toString();
        }
        return "";
    }

    @Override
    public Object convertFromString(String string) {
        if (string != null) {
            Vector<Double> vector = new Vector<Double>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    string = stringTokenizer.nextToken().trim();
                    vector.addElement(Double.valueOf(string));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException(Global.getMsg("sunsoft.jws.visual.rt.type.DoubleArrayConverter.Badly__formatted__doub.28") + string);
                }
            }
            if (vector.size() > 0) {
                double[] dArray = new double[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    dArray[i] = (Double)vector.elementAt(i);
                }
                return dArray;
            }
        }
        return null;
    }

    @Override
    public void convertToCodeBlock(String string, Attribute attribute, int n, StringBuffer stringBuffer) {
        DoubleArrayConverter.indent(stringBuffer, n);
        stringBuffer.append("{");
        Global.newline(stringBuffer);
        DoubleArrayConverter.indent(stringBuffer, n += 2);
        stringBuffer.append("double _tmp[] = {");
        this.convertToString(attribute.getValue(), stringBuffer);
        stringBuffer.append("};");
        Global.newline(stringBuffer);
        super.convertToCodeBlock(string, attribute, n, stringBuffer);
        DoubleArrayConverter.indent(stringBuffer, n -= 2);
        stringBuffer.append("}");
        Global.newline(stringBuffer);
    }

    @Override
    public String convertToCode(Object object) {
        return "_tmp";
    }
}

