/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.type;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.ImageObserver;
import java.net.URL;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.base.VJException;

public class ImageRef
implements ImageObserver {
    private Image img;
    private String filename;
    private URL url;
    private int imgWidth;
    private int imgHeight;
    private boolean gotWidth;
    private boolean gotHeight;
    private boolean errorFlagged = false;
    private boolean disableErrorPrint = false;

    public ImageRef(URL uRL) {
        this.init(null, uRL, -1, -1);
    }

    public ImageRef(String string) {
        int n = string.indexOf(59);
        if (n != -1) {
            String string2 = string.substring(n + 1);
            string = string.substring(0, n);
            n = string2.indexOf(120);
            try {
                int n2 = Integer.parseInt(string2.substring(0, n));
                int n3 = Integer.parseInt(string2.substring(n + 1));
                this.init(string, null, n2, n3);
            }
            catch (Exception exception) {
                this.init(string, null, -1, -1);
            }
        } else {
            this.init(string, null, -1, -1);
        }
    }

    private void init(String string, URL uRL, int n, int n2) {
        this.img = null;
        this.filename = string;
        this.url = uRL;
        this.imgWidth = n;
        this.imgHeight = n2;
    }

    public Image getImage(Component component, Applet applet) {
        try {
            this.cacheImage(component, applet);
        }
        catch (VJException vJException) {
            return null;
        }
        return this.img;
    }

    public int getWidth(Component component, Applet applet) {
        try {
            this.cacheImage(component, applet);
        }
        catch (VJException vJException) {
            return 0;
        }
        return this.imgWidth;
    }

    public int getHeight(Component component, Applet applet) {
        try {
            this.cacheImage(component, applet);
        }
        catch (VJException vJException) {
            return 0;
        }
        return this.imgHeight;
    }

    public URL getURL() {
        return this.url;
    }

    public String getFileName() {
        String string = this.filename != null ? this.filename : this.getURL().toExternalForm();
        return string;
    }

    public String toString() {
        String string = this.getFileName();
        if (this.imgWidth != -1 && this.imgHeight != -1) {
            string = string + ";" + this.imgWidth + "x" + this.imgHeight;
        }
        return string;
    }

    private void cacheImage(Component component, Applet applet) throws VJException {
        int n;
        if (this.img != null) {
            return;
        }
        if (this.url == null) {
            this.url = Global.util.pathToURL(this.filename, applet);
            if (this.url == null) {
                throw new VJException(Global.fmtMsg("sunsoft.jws.visual.rt.type.ImageRef.FMT.32", Global.getMsg("sunsoft.jws.visual.rt.type.ImageRef.could__not__find__file__.32"), this.filename, Global.getMsg("sunsoft.jws.visual.rt.type.ImageRef.-ba--qu-__relative__to__class.33")));
            }
        }
        this.img = component.getToolkit().getImage(this.url);
        if (this.img == null) {
            return;
        }
        int n2 = this.img.getWidth(this);
        if (n2 != -1) {
            this.imgWidth = n2;
        }
        if ((n = this.img.getHeight(this)) != -1) {
            this.imgHeight = n;
        }
    }

    public boolean verifyImage(Component component, Applet applet) {
        this.disableErrorPrint = true;
        if (this.img != null) {
            if (this.errorFlagged) {
                return false;
            }
            if (this.gotWidth && this.gotHeight) {
                return true;
            }
        } else {
            try {
                this.cacheImage(component, applet);
            }
            catch (VJException vJException) {
                return false;
            }
            return true;
        }
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(this.img, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return (mediaTracker.statusID(0, false) & 4) == 0;
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x40) != 0 && !this.errorFlagged) {
            if (!this.disableErrorPrint) {
                System.out.println(Global.getMsg("sunsoft.jws.visual.rt.type.ImageRef.Error-co-__could__not__loa.34") + this.getFileName() + "\"");
            }
            this.errorFlagged = true;
        }
        if ((n & 1) != 0) {
            this.gotWidth = true;
            this.imgWidth = n4;
        }
        if ((n & 2) != 0) {
            this.gotHeight = true;
            this.imgHeight = n5;
        }
        return this.gotWidth && this.gotHeight;
    }
}

