/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.type;

import java.awt.Insets;
import java.util.Enumeration;
import java.util.Hashtable;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.type.Converter;
import sunsoft.jws.visual.rt.type.ParseException;
import sunsoft.jws.visual.rt.type.SubFieldTokenizer;

public class InsetsConverter
extends Converter {
    @Override
    public String convertToString(Object object) {
        if (object == null) {
            return "top=0;left=0;bottom=0;right=0;";
        }
        String string = "";
        Insets insets = (Insets)object;
        string = string + "top=" + insets.top + ";";
        string = string + "left=" + insets.left + ";";
        string = string + "bottom=" + insets.bottom + ";";
        string = string + "right=" + insets.right + ";";
        return string;
    }

    private int getIntegerFromTable(Hashtable hashtable, String string) {
        String string2 = (String)hashtable.get(string);
        if (string2 != null) {
            try {
                return Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(Global.fmtMsg("sunsoft.jws.visual.rt.type.InsetsConverter.BadInsets", string2));
            }
        }
        return 0;
    }

    @Override
    public Object convertFromString(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        SubFieldTokenizer subFieldTokenizer = new SubFieldTokenizer(string);
        Hashtable hashtable = subFieldTokenizer.getHashtable();
        Insets insets = new Insets(0, 0, 0, 0);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equals("top") || string2.equals("bottom") || string2.equals("left") || string2.equals("right")) continue;
            throw new ParseException(Global.fmtMsg("sunsoft.jws.visual.rt.type.InsetsConverter.IllegalInsets", string2));
        }
        if (hashtable.containsKey("top")) {
            insets.top = this.getIntegerFromTable(hashtable, "top");
        }
        if (hashtable.containsKey("left")) {
            insets.left = this.getIntegerFromTable(hashtable, "left");
        }
        if (hashtable.containsKey("bottom")) {
            insets.bottom = this.getIntegerFromTable(hashtable, "bottom");
        }
        if (hashtable.containsKey("right")) {
            insets.right = this.getIntegerFromTable(hashtable, "right");
        }
        return insets;
    }

    @Override
    public String convertToCode(Object object) {
        if (object == null) {
            return "null";
        }
        Insets insets = (Insets)object;
        return "new java.awt.Insets(" + insets.top + ", " + insets.left + ", " + insets.bottom + ", " + insets.right + ")";
    }
}

