/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.type;

import java.util.StringTokenizer;
import java.util.Vector;
import sunsoft.jws.visual.rt.base.Attribute;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.type.Converter;
import sunsoft.jws.visual.rt.type.ParseException;

public class IntArrayConverter
extends Converter {
    @Override
    public String convertToString(Object object) {
        if (object != null) {
            int[] nArray = (int[])object;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(nArray[i]);
                if (i == nArray.length - 1) continue;
                stringBuffer.append(",");
            }
            return stringBuffer.toString();
        }
        return "";
    }

    @Override
    public Object convertFromString(String string) {
        if (string != null) {
            Vector<Integer> vector = new Vector<Integer>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    string = stringTokenizer.nextToken().trim();
                    vector.addElement(Integer.valueOf(string));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException(Global.fmtMsg("sunsoft.jws.visual.rt.type.IntArrayConverter.BadFormatInteger", string));
                }
            }
            if (vector.size() > 0) {
                int[] nArray = new int[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    nArray[i] = (Integer)vector.elementAt(i);
                }
                return nArray;
            }
        }
        return null;
    }

    @Override
    public void convertToCodeBlock(String string, Attribute attribute, int n, StringBuffer stringBuffer) {
        IntArrayConverter.indent(stringBuffer, n);
        stringBuffer.append("{");
        Global.newline(stringBuffer);
        IntArrayConverter.indent(stringBuffer, n += 2);
        stringBuffer.append("int _tmp[] = {");
        this.convertToString(attribute.getValue(), stringBuffer);
        stringBuffer.append("};");
        Global.newline(stringBuffer);
        super.convertToCodeBlock(string, attribute, n, stringBuffer);
        IntArrayConverter.indent(stringBuffer, n -= 2);
        stringBuffer.append("}");
        Global.newline(stringBuffer);
    }

    @Override
    public String convertToCode(Object object) {
        return "_tmp";
    }
}

