/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.type;

import java.awt.Event;
import java.util.Hashtable;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.base.Message;
import sunsoft.jws.visual.rt.base.Root;
import sunsoft.jws.visual.rt.type.Converter;
import sunsoft.jws.visual.rt.type.ListParser;
import sunsoft.jws.visual.rt.type.OpAction;
import sunsoft.jws.visual.rt.type.OpFilter;

public class Op
extends Converter
implements Cloneable {
    public Root scope;
    public String name;
    public OpFilter filter;
    public OpAction action;

    public Op() {
    }

    public Op(Root root) {
        this.scope = root;
    }

    public boolean matchMessage(Message message) {
        if (message.isAWT) {
            return this.filter.match(message, (Event)message.arg);
        }
        return this.filter.match(message);
    }

    public boolean hasCode() {
        return this.action != null && this.action.actionType == 2;
    }

    public boolean handleMessage(Message message) {
        if (message.isAWT) {
            return this.handleEvent(message, (Event)message.arg);
        }
        if (this.filter.match(message)) {
            this.action.invoke(message.target, message.arg, this.scope);
            return true;
        }
        return false;
    }

    public boolean handleEvent(Message message, Event event) {
        if (this.filter.match(message, event)) {
            this.action.invoke(message.target, event.arg, this.scope);
            return true;
        }
        return false;
    }

    public Object clone() {
        Op op;
        try {
            op = (Op)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        if (op.filter != null) {
            op.filter = (OpFilter)op.filter.clone();
        }
        if (op.action != null) {
            op.action = (OpAction)op.action.clone();
        }
        return op;
    }

    public void genInitCode(StringBuffer stringBuffer, String string) {
        Global.newline(stringBuffer);
        stringBuffer.append("    ");
        stringBuffer.append(string);
        stringBuffer.append(" = new Op(gui);");
        Global.newline(stringBuffer);
        if (this.name != null) {
            stringBuffer.append("    ");
            stringBuffer.append(string);
            stringBuffer.append(".name = ");
            ListParser.quote(this.name, stringBuffer, true);
            stringBuffer.append(";");
            Global.newline(stringBuffer);
        }
        if (this.filter != null) {
            stringBuffer.append("    ");
            stringBuffer.append(string);
            stringBuffer.append(".filter = new OpFilter();");
            Global.newline(stringBuffer);
            this.filter.genInitCode(stringBuffer, string + ".filter");
        }
        if (this.action != null) {
            stringBuffer.append("    ");
            stringBuffer.append(string);
            stringBuffer.append(".action = new OpAction();");
            Global.newline(stringBuffer);
            this.action.genInitCode(stringBuffer, string + ".action");
        }
    }

    @Override
    public void convertToString(Object object, StringBuffer stringBuffer) {
        Op op = (Op)object;
        if (op == null) {
            return;
        }
        stringBuffer.append("{");
        Op.newline(stringBuffer);
        Op.incrIndent();
        if (op.name != null) {
            Op.indent(stringBuffer);
            stringBuffer.append("name ");
            ListParser.quote(op.name, stringBuffer, false);
            Op.newline(stringBuffer);
        }
        if (op.filter != null) {
            Op.indent(stringBuffer);
            stringBuffer.append("filter ");
            op.filter.convertToString(op.filter, stringBuffer);
            Op.newline(stringBuffer);
        }
        if (op.action != null) {
            Op.indent(stringBuffer);
            stringBuffer.append("action ");
            op.action.convertToString(op.action, stringBuffer);
            Op.newline(stringBuffer);
        }
        Op.decrIndent();
        Op.indent(stringBuffer);
        stringBuffer.append("}");
    }

    @Override
    public Object convertFromString(String string) {
        Op op = new Op();
        this.convertFromString(string, op);
        return op;
    }

    public void convertFromString(String string, Op op) {
        Hashtable hashtable = ListParser.makeListTable(string);
        op.name = (String)hashtable.get("name");
        string = (String)hashtable.get("filter");
        if (string != null) {
            op.filter = new OpFilter();
            op.filter.convertFromString(string, op.filter);
        }
        if ((string = (String)hashtable.get("action")) != null) {
            op.action = new OpAction();
            op.action.convertFromString(string, op.action);
        }
    }

    @Override
    public boolean viewableAsString() {
        return false;
    }

    static {
        Converter.addConverter("sunsoft.jws.visual.rt.type.Op", "sunsoft.jws.visual.rt.type.Op");
        Converter.addConverter("[Lsunsoft.jws.visual.rt.type.Op;", "sunsoft.jws.visual.rt.type.OpArrayConverter");
    }
}

