/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.type;

import java.util.Hashtable;
import sunsoft.jws.visual.rt.base.AttributeManager;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.base.Message;
import sunsoft.jws.visual.rt.base.Root;
import sunsoft.jws.visual.rt.type.AMRef;
import sunsoft.jws.visual.rt.type.Converter;
import sunsoft.jws.visual.rt.type.ListParser;
import sunsoft.jws.visual.rt.type.ParseException;

public class OpAction
extends Converter
implements Cloneable {
    public static final int ATTRIBUTE = 0;
    public static final int MESSAGE = 1;
    public static final int CODE = 2;
    public static final int SHOW = 1;
    public static final int HIDE = 2;
    public static final int EXIT = 3;
    public static final int CONSTANT = 10;
    public static final int TARGET = 11;
    public static final int ARG = 12;
    public int actionType;
    public int actionDetail;
    public AMRef target;
    public int targetSource;
    public String name;
    public Object value;
    public int valueSource;
    public String type;
    public String targetName;
    public String code;

    public OpAction() {
        this.targetSource = 10;
        this.valueSource = 10;
    }

    public OpAction(int n, AMRef aMRef, String string, Object object) {
        this.actionType = n;
        this.target = aMRef;
        this.name = string;
        this.targetSource = 10;
        this.value = object;
        this.valueSource = 10;
    }

    void invoke(Object object, Object object2, Root root) {
        if (this.name == null) {
            return;
        }
        AttributeManager attributeManager = this.lookupTarget(object, object2, root);
        if (attributeManager == null) {
            return;
        }
        Object object3 = this.lookupValue(object, object2, root);
        this.performAction(attributeManager, object3);
    }

    private AttributeManager lookupTarget(Object object, Object object2, Root root) {
        AttributeManager attributeManager = null;
        switch (this.targetSource) {
            case 10: {
                if (this.target == null) break;
                attributeManager = this.target.getRef(root);
                break;
            }
            case 11: {
                attributeManager = (AttributeManager)object;
                break;
            }
            case 12: {
                attributeManager = (AttributeManager)object2;
            }
        }
        return attributeManager;
    }

    private Object lookupValue(Object object, Object object2, Root root) {
        Object object3 = null;
        switch (this.valueSource) {
            case 10: {
                object3 = this.value;
                break;
            }
            case 11: {
                object3 = object;
                break;
            }
            case 12: {
                object3 = object2;
            }
        }
        return object3;
    }

    private void performAction(AttributeManager attributeManager, Object object) {
        switch (this.actionType) {
            case 0: {
                if (this.name == null) break;
                attributeManager.set(this.name, object);
                break;
            }
            case 1: {
                if (this.name == null) break;
                attributeManager.postMessage(new Message(attributeManager, this.targetName, this.type, this.name, object));
                break;
            }
            case 2: {
                System.out.println("CODE: " + this.code);
            }
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void genInitCode(StringBuffer stringBuffer, String string) {
        String string2;
        stringBuffer.append("    ");
        stringBuffer.append(string);
        stringBuffer.append(".actionType = ");
        stringBuffer.append("OpAction.");
        stringBuffer.append(this.constantToString(this.actionType));
        stringBuffer.append(";");
        Global.newline(stringBuffer);
        if (this.target != null) {
            stringBuffer.append("    ");
            stringBuffer.append(string);
            stringBuffer.append(".target = new AMRef(");
            ListParser.quote(this.target.getName(), stringBuffer, true);
            stringBuffer.append(");");
            Global.newline(stringBuffer);
        }
        if (this.targetSource != 10) {
            stringBuffer.append("    ");
            stringBuffer.append(string);
            stringBuffer.append(".targetSource = ");
            stringBuffer.append("OpAction.");
            stringBuffer.append(this.constantToString(this.targetSource));
            stringBuffer.append(";");
            Global.newline(stringBuffer);
        }
        if (this.name != null) {
            stringBuffer.append("    ");
            stringBuffer.append(string);
            stringBuffer.append(".name = ");
            ListParser.quote(this.name, stringBuffer, true);
            stringBuffer.append(";");
            Global.newline(stringBuffer);
        }
        if (this.valueSource != 10) {
            stringBuffer.append("    ");
            stringBuffer.append(string);
            stringBuffer.append(".valueSource = ");
            stringBuffer.append("OpAction.");
            stringBuffer.append(this.constantToString(this.valueSource));
            stringBuffer.append(";");
            Global.newline(stringBuffer);
        }
        if (this.value != null && Converter.hasConverter(string2 = this.value.getClass().getName())) {
            Converter converter = Converter.getConverter(string2);
            stringBuffer.append("    ");
            stringBuffer.append(string);
            stringBuffer.append(".value = ");
            stringBuffer.append(converter.convertToCode(this.value));
            stringBuffer.append(";");
            Global.newline(stringBuffer);
        }
        if (this.type != null) {
            stringBuffer.append("    ");
            stringBuffer.append(string);
            stringBuffer.append(".type = ");
            ListParser.quote(this.type, stringBuffer, true);
            stringBuffer.append(";");
            Global.newline(stringBuffer);
        }
        if (this.targetName != null) {
            stringBuffer.append("    ");
            stringBuffer.append(string);
            stringBuffer.append(".targetName = ");
            ListParser.quote(this.targetName, stringBuffer, true);
            stringBuffer.append(";");
            Global.newline(stringBuffer);
        }
    }

    private String constantToString(int n) {
        switch (n) {
            case 0: {
                return "ATTRIBUTE";
            }
            case 1: {
                return "MESSAGE";
            }
            case 2: {
                return "CODE";
            }
            case 10: {
                return "CONSTANT";
            }
            case 11: {
                return "TARGET";
            }
            case 12: {
                return "ARG";
            }
        }
        return null;
    }

    private int stringToConstant(String string) {
        if (string.equals("ATTRIBUTE")) {
            return 0;
        }
        if (string.equals("MESSAGE")) {
            return 1;
        }
        if (string.equals("CODE")) {
            return 2;
        }
        if (string.equals("CONSTANT")) {
            return 10;
        }
        if (string.equals("TARGET")) {
            return 11;
        }
        if (string.equals("ARG")) {
            return 12;
        }
        return -1;
    }

    @Override
    public void convertToString(Object object, StringBuffer stringBuffer) {
        OpAction opAction = (OpAction)object;
        stringBuffer.append("{");
        OpAction.newline(stringBuffer);
        OpAction.incrIndent();
        OpAction.indent(stringBuffer);
        stringBuffer.append("actionType ");
        stringBuffer.append(this.constantToString(opAction.actionType));
        OpAction.newline(stringBuffer);
        if (opAction.actionDetail != 0) {
            OpAction.indent(stringBuffer);
            stringBuffer.append("actionDetail ");
            stringBuffer.append(Integer.toString(opAction.actionDetail));
            OpAction.newline(stringBuffer);
        }
        if (opAction.target != null) {
            OpAction.indent(stringBuffer);
            stringBuffer.append("target ");
            stringBuffer.append(opAction.target.getName());
            OpAction.newline(stringBuffer);
        }
        if (opAction.targetSource != 10) {
            OpAction.indent(stringBuffer);
            stringBuffer.append("targetSource ");
            stringBuffer.append(this.constantToString(opAction.targetSource));
            OpAction.newline(stringBuffer);
        }
        if (opAction.name != null) {
            OpAction.indent(stringBuffer);
            stringBuffer.append("name ");
            ListParser.quote(opAction.name, stringBuffer, false);
            OpAction.newline(stringBuffer);
        }
        if (opAction.value != null) {
            OpAction.indent(stringBuffer);
            stringBuffer.append("value ");
            String string = this.value.getClass().getName();
            if (Converter.hasConverter(string)) {
                Converter converter = Converter.getConverter(string);
                ListParser.quote(converter.convertToString(this.value), stringBuffer, false);
            } else {
                stringBuffer.append("null");
            }
            OpAction.newline(stringBuffer);
            OpAction.indent(stringBuffer);
            stringBuffer.append("valueType ");
            stringBuffer.append(string);
            OpAction.newline(stringBuffer);
        }
        if (opAction.valueSource != 10) {
            OpAction.indent(stringBuffer);
            stringBuffer.append("valueSource ");
            stringBuffer.append(this.constantToString(opAction.valueSource));
            OpAction.newline(stringBuffer);
        }
        if (opAction.type != null) {
            OpAction.indent(stringBuffer);
            stringBuffer.append("type ");
            ListParser.quote(opAction.type, stringBuffer, false);
            OpAction.newline(stringBuffer);
        }
        if (opAction.targetName != null) {
            OpAction.indent(stringBuffer);
            stringBuffer.append("targetName ");
            ListParser.quote(opAction.targetName, stringBuffer, false);
            OpAction.newline(stringBuffer);
        }
        if (opAction.code != null) {
            OpAction.indent(stringBuffer);
            stringBuffer.append("code ");
            ListParser.list(opAction.code, stringBuffer);
            OpAction.newline(stringBuffer);
        }
        OpAction.decrIndent();
        OpAction.indent(stringBuffer);
        stringBuffer.append("}");
    }

    @Override
    public Object convertFromString(String string) {
        OpAction opAction = new OpAction();
        this.convertFromString(string, opAction);
        return opAction;
    }

    public void convertFromString(String string, OpAction opAction) {
        Hashtable hashtable = ListParser.makeListTable(string);
        String string2 = (String)hashtable.get("actionType");
        opAction.actionType = this.stringToConstant(string2);
        string2 = (String)hashtable.get("actionDetail");
        if (string2 != null) {
            try {
                opAction.actionDetail = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(Global.fmtMsg("sunsoft.jws.visual.rt.type.OpAction.NumberFormatException", string2));
            }
        }
        if ((string2 = (String)hashtable.get("target")) != null) {
            opAction.target = new AMRef(string2);
        }
        if ((string2 = (String)hashtable.get("targetSource")) != null) {
            opAction.targetSource = this.stringToConstant(string2);
        }
        opAction.name = (String)hashtable.get("name");
        string2 = (String)hashtable.get("value");
        if (string2 != null) {
            if (string2.equals("null")) {
                opAction.value = null;
            } else {
                String string3 = (String)hashtable.get("valueType");
                if (string3 == null) {
                    throw new ParseException(Global.fmtMsg("sunsoft.jws.visual.rt.type.OpAction.ValWithoutType", string));
                }
                if (!Converter.hasConverter(string3)) {
                    throw new ParseException(Global.fmtMsg("sunsoft.jws.visual.rt.type.OpAction.NoConverter", string3));
                }
                opAction.value = Converter.getConverter(string3).convertFromString(string2);
            }
        }
        if ((string2 = (String)hashtable.get("valueSource")) != null) {
            opAction.valueSource = this.stringToConstant(string2);
        }
        opAction.type = (String)hashtable.get("type");
        opAction.targetName = (String)hashtable.get("targetName");
        opAction.code = (String)hashtable.get("code");
    }

    @Override
    public boolean viewableAsString() {
        return false;
    }

    static {
        Converter.addConverter("sunsoft.jws.visual.rt.type.OpAction", "sunsoft.jws.visual.rt.type.OpAction");
    }
}

