/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.domain.pools;

import com.sun.solaris.domain.pools.AbstractObjective;
import com.sun.solaris.domain.pools.ComponentMove;
import com.sun.solaris.domain.pools.KVExpression;
import com.sun.solaris.domain.pools.Move;
import com.sun.solaris.domain.pools.PSETData;
import com.sun.solaris.domain.pools.Poold;
import com.sun.solaris.domain.pools.ResultTuple;
import com.sun.solaris.service.locality.LocalityDomain;
import com.sun.solaris.service.locality.LocalityGroup;
import com.sun.solaris.service.logging.Severity;
import com.sun.solaris.service.pools.Component;
import com.sun.solaris.service.pools.Configuration;
import com.sun.solaris.service.pools.Element;
import com.sun.solaris.service.pools.PoolsException;
import com.sun.solaris.service.pools.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

final class LocalityObjective
extends AbstractObjective {
    static final String name = "locality";
    private LocalityDomain ldom;
    private Set allLGroups;
    private Map<Integer, LocalityGroup> allCPUData = new HashMap<Integer, LocalityGroup>();
    private Map<Resource, PSETData> allPSETData = new HashMap<Resource, PSETData>();

    LocalityObjective() {
    }

    private void getCPUData() {
        this.allLGroups = this.ldom.getGroups();
        for (LocalityGroup localityGroup : this.allLGroups) {
            int[] nArray = localityGroup.getCPUIDs();
            for (int i = 0; i < nArray.length; ++i) {
                this.allCPUData.put(new Integer(nArray[i]), localityGroup);
            }
        }
    }

    public void prepare(LocalityDomain localityDomain, Resource resource) throws PoolsException {
        this.ldom = localityDomain;
    }

    @Override
    public double calculate(Configuration configuration, Move move, Element element) throws PoolsException {
        PSETData pSETData;
        KVExpression kVExpression = (KVExpression)this.getExpression();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Resource resource = (Resource)element;
        ComponentMove componentMove = (ComponentMove)move;
        Poold.MON_LOG.log((Level)Severity.DEBUG, "Calculating objective type: locality for: " + element);
        if (kVExpression.getValue().compareTo("none") == 0) {
            return d;
        }
        if (this.ldom.getMaxLatency() == 0) {
            return d;
        }
        if (!element.equals(move.getFrom()) && !element.equals(move.getTo())) {
            return d;
        }
        if (this.allCPUData.isEmpty()) {
            this.getCPUData();
        }
        if (this.allPSETData.containsKey(resource)) {
            pSETData = this.allPSETData.get(resource);
        } else {
            pSETData = new PSETData(this.allLGroups, this.allCPUData, resource);
            this.allPSETData.put(resource, pSETData);
        }
        List list = componentMove.getComponents();
        Component component = (Component)list.get(0);
        int n = (int)component.getLongProperty("cpu.sys_id");
        LocalityGroup localityGroup = this.allCPUData.get(new Integer(n));
        HashMap hashMap = (HashMap)pSETData.getResults();
        ResultTuple resultTuple = (ResultTuple)hashMap.get(localityGroup);
        d3 = pSETData.getAsIsTotal();
        d2 = element.equals(move.getFrom()) ? resultTuple.getFromResult() : resultTuple.getToResult();
        d = d2 - d3;
        if (kVExpression.getValue().compareTo("loose") == 0) {
            d = 0.0 - d;
        }
        Poold.MON_LOG.log((Level)Severity.DEBUG, "ret: " + d);
        return d;
    }
}

