/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;

public class CharacterBinding
extends TupleBinding<Character> {
    private static final int CHAR_SIZE = 2;

    @Override
    public Character entryToObject(TupleInput tupleInput) {
        return Character.valueOf(tupleInput.readChar());
    }

    @Override
    public void objectToEntry(Character c, TupleOutput tupleOutput) {
        tupleOutput.writeChar(c.charValue());
    }

    @Override
    protected TupleOutput getTupleOutput(Character c) {
        return CharacterBinding.sizedOutput();
    }

    public static char entryToChar(DatabaseEntry databaseEntry) {
        return CharacterBinding.entryToInput(databaseEntry).readChar();
    }

    public static void charToEntry(char c, DatabaseEntry databaseEntry) {
        CharacterBinding.outputToEntry(CharacterBinding.sizedOutput().writeChar(c), databaseEntry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[2]);
    }
}

