/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.FloatBinding;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;

public class SortedFloatBinding
extends TupleBinding<Float> {
    @Override
    public Float entryToObject(TupleInput tupleInput) {
        return Float.valueOf(tupleInput.readSortedFloat());
    }

    @Override
    public void objectToEntry(Float f, TupleOutput tupleOutput) {
        tupleOutput.writeSortedFloat(f.floatValue());
    }

    @Override
    protected TupleOutput getTupleOutput(Float f) {
        return FloatBinding.sizedOutput();
    }

    public static float entryToFloat(DatabaseEntry databaseEntry) {
        return SortedFloatBinding.entryToInput(databaseEntry).readSortedFloat();
    }

    public static void floatToEntry(float f, DatabaseEntry databaseEntry) {
        SortedFloatBinding.outputToEntry(FloatBinding.sizedOutput().writeSortedFloat(f), databaseEntry);
    }
}

