/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.Cursor;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.ForeignKeyDeleteAction;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.SecondaryConfig;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.db.Sequence;
import com.sleepycat.db.SequenceConfig;
import com.sleepycat.db.Transaction;
import com.sleepycat.db.TransactionConfig;
import com.sleepycat.persist.DatabaseNamer;
import com.sleepycat.persist.IndexNotAvailableException;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SecondaryIndex;
import com.sleepycat.persist.StoreConfig;
import com.sleepycat.persist.StoreExistsException;
import com.sleepycat.persist.StoreNotFoundException;
import com.sleepycat.persist.evolve.EvolveConfig;
import com.sleepycat.persist.evolve.EvolveEvent;
import com.sleepycat.persist.evolve.EvolveInternal;
import com.sleepycat.persist.evolve.EvolveListener;
import com.sleepycat.persist.evolve.EvolveStats;
import com.sleepycat.persist.evolve.IncompatibleClassException;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.ComplexFormat;
import com.sleepycat.persist.impl.CompositeKeyFormat;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistCatalog;
import com.sleepycat.persist.impl.PersistComparator;
import com.sleepycat.persist.impl.PersistEntityBinding;
import com.sleepycat.persist.impl.PersistKeyAssigner;
import com.sleepycat.persist.impl.PersistKeyBinding;
import com.sleepycat.persist.impl.PersistKeyCreator;
import com.sleepycat.persist.impl.RefreshException;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.model.DeleteAction;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.model.PrimaryKeyMetadata;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKeyMetadata;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.util.RuntimeExceptionWrapper;
import com.sleepycat.util.keyrange.KeyRange;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class Store {
    public static final String NAME_SEPARATOR = "#";
    private static final String NAME_PREFIX = "persist#";
    private static final String DB_NAME_PREFIX = "com.sleepycat.persist.";
    private static final String CATALOG_DB = "com.sleepycat.persist.formats";
    private static final String SEQUENCE_DB = "com.sleepycat.persist.sequences";
    private static Map<Environment, Map<String, PersistCatalog>> catalogPool = new WeakHashMap<Environment, Map<String, PersistCatalog>>();
    private static SyncHook syncHook;
    public static boolean expectFlush;
    private final Environment env;
    private final boolean rawAccess;
    private volatile PersistCatalog catalog;
    private EntityModel model;
    private final StoreConfig storeConfig;
    private final String storeName;
    private final String storePrefix;
    private final Map<String, InternalPrimaryIndex> priIndexMap;
    private final Map<String, InternalSecondaryIndex> secIndexMap;
    private final Map<String, DatabaseConfig> priConfigMap;
    private final Map<String, SecondaryConfig> secConfigMap;
    private final Map<String, PersistKeyBinding> keyBindingMap;
    private Database sequenceDb;
    private final Map<String, Sequence> sequenceMap;
    private final Map<String, SequenceConfig> sequenceConfigMap;
    private final IdentityHashMap<Database, Object> deferredWriteDatabases;
    private final Map<String, Set<String>> inverseRelatedEntityMap;
    private final TransactionConfig autoCommitTxnConfig;
    private final TransactionConfig autoCommitNoWaitTxnConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store(Environment environment, String string, StoreConfig storeConfig, boolean bl) throws StoreExistsException, StoreNotFoundException, IncompatibleClassException, DatabaseException {
        ArrayList<Format> arrayList;
        this.env = environment;
        this.storeName = string;
        this.rawAccess = bl;
        if (environment == null || string == null) {
            throw new NullPointerException("env and storeName parameters must not be null");
        }
        this.storeConfig = storeConfig != null ? storeConfig.clone() : StoreConfig.DEFAULT;
        this.autoCommitTxnConfig = new TransactionConfig();
        this.autoCommitNoWaitTxnConfig = new TransactionConfig();
        this.autoCommitNoWaitTxnConfig.setNoWait(true);
        this.model = storeConfig.getModel();
        this.storePrefix = NAME_PREFIX + string + NAME_SEPARATOR;
        this.priIndexMap = new HashMap<String, InternalPrimaryIndex>();
        this.secIndexMap = new HashMap<String, InternalSecondaryIndex>();
        this.priConfigMap = new HashMap<String, DatabaseConfig>();
        this.secConfigMap = new HashMap<String, SecondaryConfig>();
        this.keyBindingMap = new HashMap<String, PersistKeyBinding>();
        this.sequenceMap = new HashMap<String, Sequence>();
        this.sequenceConfigMap = new HashMap<String, SequenceConfig>();
        this.deferredWriteDatabases = new IdentityHashMap();
        if (bl) {
            if (this.model != null) {
                throw new IllegalArgumentException("A model may not be specified when opening a RawStore");
            }
            arrayList = new DatabaseConfig();
            ((DatabaseConfig)((Object)arrayList)).setReadOnly(true);
            ((DatabaseConfig)((Object)arrayList)).setTransactional(this.storeConfig.getTransactional());
            this.catalog = new PersistCatalog(environment, this.storePrefix, this.storePrefix + CATALOG_DB, (DatabaseConfig)((Object)arrayList), null, storeConfig.getMutations(), bl, this);
        } else {
            arrayList = catalogPool;
            synchronized (arrayList) {
                Object object = catalogPool.get(environment);
                if (object == null) {
                    object = new HashMap<String, PersistCatalog>();
                    catalogPool.put(environment, (Map<String, PersistCatalog>)object);
                }
                this.catalog = object.get(string);
                if (this.catalog != null) {
                    this.catalog.openExisting();
                } else {
                    DatabaseConfig object2 = new DatabaseConfig();
                    object2.setAllowCreate(this.storeConfig.getAllowCreate());
                    object2.setExclusiveCreate(this.storeConfig.getExclusiveCreate());
                    object2.setReadOnly(this.storeConfig.getReadOnly());
                    object2.setTransactional(this.storeConfig.getTransactional());
                    DbCompat.setTypeBtree(object2);
                    this.catalog = new PersistCatalog(environment, this.storePrefix, this.storePrefix + CATALOG_DB, object2, this.model, storeConfig.getMutations(), bl, this);
                    object.put(string, this.catalog);
                }
            }
        }
        this.model = this.catalog.getResolvedModel();
        this.inverseRelatedEntityMap = new HashMap<String, Set<String>>();
        arrayList = new ArrayList<Format>();
        this.catalog.getEntityFormats(arrayList);
        for (Format format : arrayList) {
            EntityMetadata entityMetadata = format.getEntityMetadata();
            for (SecondaryKeyMetadata secondaryKeyMetadata : entityMetadata.getSecondaryKeys().values()) {
                String string2 = secondaryKeyMetadata.getRelatedEntity();
                if (string2 == null) continue;
                Set<String> set = this.inverseRelatedEntityMap.get(string2);
                if (set == null) {
                    set = new HashSet<String>();
                    this.inverseRelatedEntityMap.put(string2, set);
                }
                set.add(entityMetadata.getClassName());
            }
        }
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public StoreConfig getConfig() {
        return this.storeConfig.clone();
    }

    public String getStoreName() {
        return this.storeName;
    }

    public boolean isReplicaUpgradeMode() {
        return this.catalog.isReplicaUpgradeMode();
    }

    public EntityModel getModel() {
        return this.model;
    }

    public Mutations getMutations() {
        return this.catalog.getMutations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <PK, E> PrimaryIndex<PK, E> getPrimaryIndex(Class<PK> clazz, String string, Class<E> clazz2, String string2) throws DatabaseException, IndexNotAvailableException {
        assert (this.rawAccess && clazz2 == RawObject.class || !this.rawAccess && clazz2 != RawObject.class);
        assert (this.rawAccess && string == null || !this.rawAccess && string != null);
        this.checkOpen();
        InternalPrimaryIndex<PK, E> internalPrimaryIndex = this.priIndexMap.get(string2);
        if (internalPrimaryIndex == null) {
            Object object;
            EntityMetadata entityMetadata = this.checkEntityClass(string2);
            PrimaryKeyMetadata primaryKeyMetadata = entityMetadata.getPrimaryKey();
            if (string == null) {
                string = primaryKeyMetadata.getClassName();
            } else {
                object = SimpleCatalog.keyClassName(primaryKeyMetadata.getClassName());
                if (!string.equals(object)) {
                    throw new IllegalArgumentException("Wrong primary key class: " + string + " Correct class is: " + (String)object);
                }
            }
            object = new PersistEntityBinding(this.catalog, string2, this.rawAccess);
            PersistKeyBinding persistKeyBinding = this.getKeyBinding(string);
            String string3 = primaryKeyMetadata.getSequenceName();
            if (!this.storeConfig.getReadOnly() && string3 != null) {
                ((PersistEntityBinding)object).keyAssigner = new PersistKeyAssigner(persistKeyBinding, (PersistEntityBinding)object, this.getSequence(string3));
            }
            Transaction transaction = null;
            DatabaseConfig databaseConfig = this.getPrimaryConfig(entityMetadata);
            if (databaseConfig.getTransactional() && DbCompat.getThreadTransaction(this.env) == null) {
                transaction = this.env.beginTransaction(null, this.autoCommitNoWaitTxnConfig);
            }
            PrimaryOpenState primaryOpenState = new PrimaryOpenState(string2);
            boolean bl = databaseConfig.getAllowCreate();
            boolean bl2 = false;
            try {
                Object object2;
                if (this.catalog.isReadOnly()) {
                    databaseConfig.setAllowCreate(false);
                }
                Database database = null;
                String string4 = this.catalog.getDatabaseClassName(string2);
                if (string4 != null) {
                    object2 = this.parseDbName(this.storePrefix + string4);
                    database = DbCompat.openDatabase(this.env, transaction, object2[0], object2[1], databaseConfig);
                }
                if (database == null) {
                    throw new IndexNotAvailableException("PrimaryIndex not yet available on this Replica, entity class: " + string2);
                }
                primaryOpenState.addDatabase(database);
                internalPrimaryIndex = new InternalPrimaryIndex<PK, E>(database, clazz, persistKeyBinding, clazz2, (PersistEntityBinding)object);
                this.priIndexMap.put(string2, internalPrimaryIndex);
                if (DbCompat.getDeferredWrite(databaseConfig)) {
                    this.deferredWriteDatabases.put(database, null);
                }
                if (!databaseConfig.getReadOnly()) {
                    this.openSecondaryIndexes(transaction, entityMetadata, primaryOpenState);
                    object2 = this.inverseRelatedEntityMap.get(string2);
                    if (object2 != null) {
                        Iterator iterator = object2.iterator();
                        while (iterator.hasNext()) {
                            String string5 = (String)iterator.next();
                            this.getRelatedIndex(string5);
                        }
                    }
                }
                bl2 = true;
            }
            finally {
                databaseConfig.setAllowCreate(bl);
                if (bl2) {
                    if (transaction != null) {
                        transaction.commit();
                    }
                } else {
                    if (transaction != null) {
                        transaction.abort();
                    }
                    primaryOpenState.undoState();
                }
            }
        }
        return internalPrimaryIndex;
    }

    private PrimaryIndex getRelatedIndex(String string) throws DatabaseException {
        PrimaryIndex primaryIndex = this.priIndexMap.get(string);
        if (primaryIndex == null) {
            String string2;
            Class clazz;
            Class clazz2;
            EntityMetadata entityMetadata = this.checkEntityClass(string);
            if (this.rawAccess) {
                clazz2 = RawObject.class;
                clazz = Object.class;
                string2 = null;
            } else {
                try {
                    clazz2 = this.catalog.resolveClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalArgumentException("Related entity class not found: " + string);
                }
                string2 = SimpleCatalog.keyClassName(entityMetadata.getPrimaryKey().getClassName());
                clazz = this.catalog.resolveKeyClass(string2);
            }
            primaryIndex = this.getPrimaryIndex(clazz, string2, clazz2, string);
        }
        return primaryIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <SK, PK, E1, E2 extends E1> SecondaryIndex<SK, PK, E2> getSecondaryIndex(PrimaryIndex<PK, E1> primaryIndex, Class<E2> clazz, String string, Class<SK> clazz2, String string2, String string3) throws DatabaseException, IndexNotAvailableException {
        InternalSecondaryIndex<SK, PK, E2> internalSecondaryIndex;
        String string4;
        assert (this.rawAccess && string2 == null || !this.rawAccess && string2 != null);
        this.checkOpen();
        EntityMetadata entityMetadata = null;
        SecondaryKeyMetadata secondaryKeyMetadata = null;
        if (clazz != primaryIndex.getEntityClass()) {
            entityMetadata = this.model.getEntityMetadata(string);
            assert (entityMetadata != null);
            secondaryKeyMetadata = this.checkSecKey(entityMetadata, string3);
            string4 = clazz.getName();
            if (!string4.equals(internalSecondaryIndex = secondaryKeyMetadata.getDeclaringClassName())) {
                throw new IllegalArgumentException("Key for subclass " + string4 + " is declared in a different class: " + Store.makeSecName((String)((Object)internalSecondaryIndex), string3));
            }
            try {
                this.catalog.getFormat(clazz, false);
            }
            catch (RefreshException refreshException) {
                refreshException.refresh();
                try {
                    this.catalog.getFormat(clazz, false);
                }
                catch (RefreshException refreshException2) {
                    throw DbCompat.unexpectedException(refreshException2);
                }
            }
        }
        if ((internalSecondaryIndex = this.secIndexMap.get(string4 = Store.makeSecName(string, string3))) == null) {
            String string5;
            if (entityMetadata == null) {
                entityMetadata = this.model.getEntityMetadata(string);
                assert (entityMetadata != null);
            }
            if (secondaryKeyMetadata == null) {
                secondaryKeyMetadata = this.checkSecKey(entityMetadata, string3);
            }
            if (string2 == null) {
                string2 = this.getSecKeyClass(secondaryKeyMetadata);
            } else {
                string5 = this.getSecKeyClass(secondaryKeyMetadata);
                if (!string2.equals(string5)) {
                    throw new IllegalArgumentException("Wrong secondary key class: " + string2 + " Correct class is: " + string5);
                }
            }
            string5 = this.catalog.getDatabaseClassName(string);
            String string6 = this.catalog.getDatabaseKeyName(string, string3);
            if (string5 != null && string6 != null) {
                Transaction transaction = null;
                if (this.getPrimaryConfig(entityMetadata).getTransactional() && DbCompat.getThreadTransaction(this.env) == null) {
                    transaction = this.env.beginTransaction(null, this.autoCommitNoWaitTxnConfig);
                }
                boolean bl = false;
                try {
                    internalSecondaryIndex = this.openSecondaryIndex(transaction, primaryIndex, clazz, entityMetadata, clazz2, string2, secondaryKeyMetadata, string4, Store.makeSecName(string5, string6), this.catalog.isReadOnly(), null);
                    bl = true;
                }
                finally {
                    if (bl) {
                        if (transaction != null) {
                            transaction.commit();
                        }
                    } else if (transaction != null) {
                        transaction.abort();
                    }
                }
            }
            if (internalSecondaryIndex == null) {
                throw new IndexNotAvailableException("SecondaryIndex not yet available on this Replica, entity class: " + string + ", key name: " + string3);
            }
        }
        return internalSecondaryIndex;
    }

    private void openSecondaryIndexes(Transaction transaction, EntityMetadata entityMetadata, PrimaryOpenState primaryOpenState) throws DatabaseException {
        String string = entityMetadata.getClassName();
        PrimaryIndex primaryIndex = this.priIndexMap.get(string);
        assert (primaryIndex != null);
        Class clazz = primaryIndex.getEntityClass();
        for (SecondaryKeyMetadata secondaryKeyMetadata : entityMetadata.getSecondaryKeys().values()) {
            String string2 = secondaryKeyMetadata.getKeyName();
            String string3 = Store.makeSecName(string, string2);
            SecondaryIndex secondaryIndex = this.secIndexMap.get(string3);
            if (secondaryIndex != null) continue;
            String string4 = this.getSecKeyClass(secondaryKeyMetadata);
            Class clazz2 = this.catalog.resolveKeyClass(string4);
            String string5 = this.catalog.getDatabaseClassName(string);
            String string6 = this.catalog.getDatabaseKeyName(string, string2);
            if (string5 == null || string6 == null) continue;
            this.openSecondaryIndex(transaction, primaryIndex, clazz, entityMetadata, clazz2, string4, secondaryKeyMetadata, string3, Store.makeSecName(string5, string6), this.storeConfig.getSecondaryBulkLoad() || this.catalog.isReadOnly(), primaryOpenState);
        }
    }

    private <SK, PK, E1, E2 extends E1> InternalSecondaryIndex<SK, PK, E2> openSecondaryIndex(Transaction transaction, PrimaryIndex<PK, E1> primaryIndex, Class<E2> clazz, EntityMetadata entityMetadata, Class<SK> clazz2, String string, SecondaryKeyMetadata secondaryKeyMetadata, String string2, String string3, boolean bl, PrimaryOpenState primaryOpenState) throws DatabaseException {
        Object object;
        assert (!this.secIndexMap.containsKey(string2));
        String[] stringArray = this.parseDbName(this.storePrefix + string3);
        SecondaryConfig secondaryConfig = this.getSecondaryConfig(string2, entityMetadata, string, secondaryKeyMetadata);
        Database database = primaryIndex.getDatabase();
        DatabaseConfig databaseConfig = database.getConfig();
        String string4 = secondaryKeyMetadata.getRelatedEntity();
        if (string4 != null) {
            object = this.getRelatedIndex(string4);
            secondaryConfig.setForeignKeyDatabase(((PrimaryIndex)object).getDatabase());
        }
        if (secondaryConfig.getTransactional() != databaseConfig.getTransactional() || DbCompat.getDeferredWrite(secondaryConfig) != DbCompat.getDeferredWrite(databaseConfig) || secondaryConfig.getReadOnly() != databaseConfig.getReadOnly()) {
            throw new IllegalArgumentException("One of these properties was changed to be inconsistent with the associated primary database:  Transactional, DeferredWrite, ReadOnly");
        }
        object = this.getKeyBinding(string);
        SecondaryDatabase secondaryDatabase = this.openSecondaryDatabase(transaction, stringArray, primaryIndex, secondaryKeyMetadata.getKeyName(), secondaryConfig, bl);
        if (secondaryDatabase == null) {
            assert (bl);
            return null;
        }
        InternalSecondaryIndex<SK, PK, E1> internalSecondaryIndex = new InternalSecondaryIndex<SK, PK, E1>(secondaryDatabase, primaryIndex, clazz2, (PersistKeyBinding)object, this.getKeyCreator(secondaryConfig));
        this.secIndexMap.put(string2, internalSecondaryIndex);
        if (DbCompat.getDeferredWrite(secondaryConfig)) {
            this.deferredWriteDatabases.put(secondaryDatabase, null);
        }
        if (primaryOpenState != null) {
            primaryOpenState.addDatabase(secondaryDatabase);
            primaryOpenState.addSecondaryName(string2);
        }
        return internalSecondaryIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecondaryDatabase openSecondaryDatabase(Transaction transaction, String[] stringArray, PrimaryIndex primaryIndex, String string, SecondaryConfig secondaryConfig, boolean bl) throws DatabaseException {
        assert (secondaryConfig.getAllowPopulate());
        assert (!secondaryConfig.getExclusiveCreate());
        Database database = primaryIndex.getDatabase();
        ComplexFormat complexFormat = (ComplexFormat)((PersistEntityBinding)primaryIndex.getEntityBinding()).entityFormat;
        boolean bl2 = secondaryConfig.getAllowCreate();
        Comparator comparator = secondaryConfig.getDuplicateComparator();
        try {
            SecondaryDatabase secondaryDatabase;
            if (bl) {
                secondaryConfig.setAllowCreate(false);
            }
            if (secondaryConfig.getAllowCreate()) {
                secondaryConfig.setExclusiveCreate(true);
                secondaryDatabase = DbCompat.openSecondaryDatabase(this.env, transaction, stringArray[0], stringArray[1], database, secondaryConfig);
                if (secondaryDatabase != null) {
                    boolean bl3 = false;
                    if (secondaryConfig.getDuplicateComparator() != null && complexFormat.setSecKeyCorrectlyOrdered(string)) {
                        this.catalog.flush(transaction);
                        bl3 = true;
                    }
                    assert (!expectFlush || bl3);
                    SecondaryDatabase secondaryDatabase2 = secondaryDatabase;
                    return secondaryDatabase2;
                }
            }
            secondaryConfig.setAllowCreate(false);
            secondaryConfig.setAllowPopulate(false);
            secondaryConfig.setExclusiveCreate(false);
            if (secondaryConfig.getDuplicateComparator() != null && complexFormat.isSecKeyIncorrectlyOrdered(string)) {
                secondaryConfig.setDuplicateComparator(null);
            }
            SecondaryDatabase secondaryDatabase3 = secondaryDatabase = DbCompat.openSecondaryDatabase(this.env, transaction, stringArray[0], stringArray[1], database, secondaryConfig);
            return secondaryDatabase3;
        }
        finally {
            secondaryConfig.setAllowPopulate(true);
            secondaryConfig.setExclusiveCreate(false);
            secondaryConfig.setAllowCreate(bl2);
            secondaryConfig.setDuplicateComparator(comparator);
        }
    }

    synchronized void checkEntitySubclassSecondaries(EntityMetadata entityMetadata, String string) throws DatabaseException {
        if (this.storeConfig.getSecondaryBulkLoad()) {
            return;
        }
        String string2 = entityMetadata.getClassName();
        for (SecondaryKeyMetadata secondaryKeyMetadata : entityMetadata.getSecondaryKeys().values()) {
            String string3 = secondaryKeyMetadata.getKeyName();
            String string4 = Store.makeSecName(string2, string3);
            if (this.secIndexMap.containsKey(string4)) continue;
            throw new IllegalArgumentException("Entity subclasses defining a secondary key must be registered by calling EntityModel.registerClass or EntityStore.getSubclassIndex before storing an instance of the subclass: " + string);
        }
    }

    public void truncateClass(Class clazz) throws DatabaseException {
        this.truncateClass(null, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void truncateClass(Transaction transaction, Class clazz) throws DatabaseException {
        this.checkOpen();
        this.checkWriteAllowed();
        this.closeClass(clazz);
        String string = clazz.getName();
        EntityMetadata entityMetadata = this.checkEntityClass(string);
        boolean bl = false;
        if (this.storeConfig.getTransactional() && transaction == null && DbCompat.getThreadTransaction(this.env) == null) {
            transaction = this.env.beginTransaction(null, this.autoCommitTxnConfig);
            bl = true;
        }
        boolean bl2 = false;
        try {
            boolean bl3 = this.truncateIfExists(transaction, this.storePrefix + string);
            if (bl3) {
                Object var8_8 = null;
                for (SecondaryKeyMetadata secondaryKeyMetadata : entityMetadata.getSecondaryKeys().values()) {
                    this.removeIfExists(transaction, this.storePrefix + Store.makeSecName(string, secondaryKeyMetadata.getKeyName()));
                }
                if (var8_8 != null) {
                    throw var8_8;
                }
            }
            bl2 = true;
        }
        finally {
            if (bl) {
                if (bl2) {
                    transaction.commit();
                } else {
                    transaction.abort();
                }
            }
        }
    }

    private boolean truncateIfExists(Transaction transaction, String string) throws DatabaseException {
        String[] stringArray = this.parseDbName(string);
        return DbCompat.truncateDatabase(this.env, transaction, stringArray[0], stringArray[1]);
    }

    private boolean removeIfExists(Transaction transaction, String string) throws DatabaseException {
        String[] stringArray = this.parseDbName(string);
        return DbCompat.removeDatabase(this.env, transaction, stringArray[0], stringArray[1]);
    }

    public synchronized void closeClass(Class clazz) throws DatabaseException {
        this.checkOpen();
        String string = clazz.getName();
        EntityMetadata entityMetadata = this.checkEntityClass(string);
        PrimaryIndex primaryIndex = this.priIndexMap.get(string);
        if (primaryIndex != null) {
            DatabaseException databaseException = null;
            for (SecondaryKeyMetadata secondaryKeyMetadata : entityMetadata.getSecondaryKeys().values()) {
                String string2 = Store.makeSecName(string, secondaryKeyMetadata.getKeyName());
                SecondaryIndex secondaryIndex = this.secIndexMap.get(string2);
                if (secondaryIndex == null) continue;
                SecondaryDatabase secondaryDatabase = secondaryIndex.getDatabase();
                databaseException = this.closeDb(secondaryDatabase, databaseException);
                databaseException = this.closeDb(secondaryIndex.getKeysDatabase(), databaseException);
                this.secIndexMap.remove(string2);
                this.deferredWriteDatabases.remove(secondaryDatabase);
            }
            Database database = primaryIndex.getDatabase();
            databaseException = this.closeDb(database, databaseException);
            this.priIndexMap.remove(string);
            this.deferredWriteDatabases.remove(database);
            if (databaseException != null) {
                throw databaseException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws DatabaseException {
        DatabaseException databaseException;
        block17: {
            if (this.catalog == null) {
                return;
            }
            databaseException = null;
            try {
                if (this.rawAccess) {
                    boolean bl = this.catalog.close();
                    assert (bl);
                } else {
                    Map<Environment, Map<String, PersistCatalog>> map = catalogPool;
                    synchronized (map) {
                        Map<String, PersistCatalog> object = catalogPool.get(this.env);
                        assert (object != null);
                        if (this.catalog.close()) {
                            object.remove(this.storeName);
                        }
                    }
                }
                this.catalog = null;
            }
            catch (DatabaseException databaseException2) {
                if (databaseException != null) break block17;
                databaseException = databaseException2;
            }
        }
        for (Sequence sequence : this.sequenceMap.values()) {
            try {
                sequence.close();
            }
            catch (DatabaseException databaseException2) {
                if (databaseException != null) continue;
                databaseException = databaseException2;
            }
        }
        databaseException = this.closeDb(this.sequenceDb, databaseException);
        for (SecondaryIndex secondaryIndex : this.secIndexMap.values()) {
            databaseException = this.closeDb(secondaryIndex.getDatabase(), databaseException);
            databaseException = this.closeDb(secondaryIndex.getKeysDatabase(), databaseException);
        }
        for (PrimaryIndex primaryIndex : this.priIndexMap.values()) {
            databaseException = this.closeDb(primaryIndex.getDatabase(), databaseException);
        }
        if (databaseException != null) {
            throw databaseException;
        }
    }

    public synchronized Sequence getSequence(String string) throws DatabaseException {
        this.checkOpen();
        if (this.storeConfig.getReadOnly()) {
            throw new IllegalStateException("Store is read-only");
        }
        Sequence sequence = this.sequenceMap.get(string);
        if (sequence == null) {
            String[] stringArray;
            if (this.sequenceDb == null) {
                stringArray = this.parseDbName(this.storePrefix + SEQUENCE_DB);
                DatabaseConfig databaseConfig = new DatabaseConfig();
                databaseConfig.setTransactional(this.storeConfig.getTransactional());
                databaseConfig.setAllowCreate(true);
                DbCompat.setTypeBtree(databaseConfig);
                this.sequenceDb = DbCompat.openDatabase(this.env, null, stringArray[0], stringArray[1], databaseConfig);
                assert (this.sequenceDb != null);
            }
            stringArray = new DatabaseEntry();
            StringBinding.stringToEntry(string, (DatabaseEntry)stringArray);
            sequence = this.sequenceDb.openSequence(null, (DatabaseEntry)stringArray, this.getSequenceConfig(string));
            this.sequenceMap.put(string, sequence);
        }
        return sequence;
    }

    public synchronized SequenceConfig getSequenceConfig(String string) {
        this.checkOpen();
        SequenceConfig sequenceConfig = this.sequenceConfigMap.get(string);
        if (sequenceConfig == null) {
            sequenceConfig = new SequenceConfig();
            sequenceConfig.setInitialValue(1L);
            sequenceConfig.setRange(1L, Long.MAX_VALUE);
            sequenceConfig.setCacheSize(100);
            sequenceConfig.setAutoCommitNoSync(true);
            sequenceConfig.setAllowCreate(!this.storeConfig.getReadOnly());
            this.sequenceConfigMap.put(string, sequenceConfig);
        }
        return sequenceConfig;
    }

    public synchronized void setSequenceConfig(String string, SequenceConfig sequenceConfig) {
        this.checkOpen();
        if (sequenceConfig.getExclusiveCreate() || sequenceConfig.getAllowCreate() == this.storeConfig.getReadOnly()) {
            throw new IllegalArgumentException("One of these properties was illegally changed: AllowCreate, ExclusiveCreate");
        }
        if (this.sequenceMap.containsKey(string)) {
            throw new IllegalStateException("Cannot set config after Sequence is open");
        }
        this.sequenceConfigMap.put(string, sequenceConfig);
    }

    public synchronized DatabaseConfig getPrimaryConfig(Class clazz) {
        this.checkOpen();
        String string = clazz.getName();
        EntityMetadata entityMetadata = this.checkEntityClass(string);
        return this.getPrimaryConfig(entityMetadata).cloneConfig();
    }

    private synchronized DatabaseConfig getPrimaryConfig(EntityMetadata entityMetadata) {
        String string = entityMetadata.getClassName();
        DatabaseConfig databaseConfig = this.priConfigMap.get(string);
        if (databaseConfig == null) {
            databaseConfig = new DatabaseConfig();
            databaseConfig.setTransactional(this.storeConfig.getTransactional());
            databaseConfig.setAllowCreate(!this.storeConfig.getReadOnly());
            databaseConfig.setReadOnly(this.storeConfig.getReadOnly());
            DbCompat.setTypeBtree(databaseConfig);
            this.setBtreeComparator(databaseConfig, entityMetadata.getPrimaryKey().getClassName());
            this.priConfigMap.put(string, databaseConfig);
        }
        return databaseConfig;
    }

    public synchronized void setPrimaryConfig(Class clazz, DatabaseConfig databaseConfig) {
        this.checkOpen();
        String string = clazz.getName();
        if (this.priIndexMap.containsKey(string)) {
            throw new IllegalStateException("Cannot set config after DB is open");
        }
        EntityMetadata entityMetadata = this.checkEntityClass(string);
        DatabaseConfig databaseConfig2 = this.getPrimaryConfig(entityMetadata);
        if (databaseConfig.getExclusiveCreate() || databaseConfig.getAllowCreate() == databaseConfig.getReadOnly() || databaseConfig.getSortedDuplicates() || databaseConfig.getBtreeComparator() != databaseConfig2.getBtreeComparator()) {
            throw new IllegalArgumentException("One of these properties was illegally changed: AllowCreate, ExclusiveCreate, SortedDuplicates, Temporary or BtreeComparator, ");
        }
        if (!DbCompat.isTypeBtree(databaseConfig)) {
            throw new IllegalArgumentException("Only type BTREE allowed");
        }
        this.priConfigMap.put(string, databaseConfig);
    }

    public synchronized SecondaryConfig getSecondaryConfig(Class clazz, String string) {
        this.checkOpen();
        String string2 = clazz.getName();
        EntityMetadata entityMetadata = this.checkEntityClass(string2);
        SecondaryKeyMetadata secondaryKeyMetadata = this.checkSecKey(entityMetadata, string);
        String string3 = this.getSecKeyClass(secondaryKeyMetadata);
        String string4 = Store.makeSecName(clazz.getName(), string);
        return (SecondaryConfig)this.getSecondaryConfig(string4, entityMetadata, string3, secondaryKeyMetadata).cloneConfig();
    }

    private SecondaryConfig getSecondaryConfig(String string, EntityMetadata entityMetadata, String string2, SecondaryKeyMetadata secondaryKeyMetadata) {
        SecondaryConfig secondaryConfig = this.secConfigMap.get(string);
        if (secondaryConfig == null) {
            DatabaseConfig databaseConfig = this.getPrimaryConfig(entityMetadata);
            secondaryConfig = new SecondaryConfig();
            secondaryConfig.setTransactional(databaseConfig.getTransactional());
            secondaryConfig.setAllowCreate(!databaseConfig.getReadOnly());
            secondaryConfig.setReadOnly(databaseConfig.getReadOnly());
            DbCompat.setTypeBtree(secondaryConfig);
            secondaryConfig.setAllowPopulate(true);
            Relationship relationship = secondaryKeyMetadata.getRelationship();
            secondaryConfig.setSortedDuplicates(relationship == Relationship.MANY_TO_ONE || relationship == Relationship.MANY_TO_MANY);
            this.setBtreeComparator(secondaryConfig, string2);
            secondaryConfig.setDuplicateComparator(databaseConfig.getBtreeComparator());
            PersistKeyCreator persistKeyCreator = new PersistKeyCreator(this.catalog, entityMetadata, string2, secondaryKeyMetadata, this.rawAccess);
            if (relationship == Relationship.ONE_TO_MANY || relationship == Relationship.MANY_TO_MANY) {
                secondaryConfig.setMultiKeyCreator(persistKeyCreator);
            } else {
                secondaryConfig.setKeyCreator(persistKeyCreator);
            }
            DeleteAction deleteAction = secondaryKeyMetadata.getDeleteAction();
            if (deleteAction != null) {
                ForeignKeyDeleteAction foreignKeyDeleteAction;
                switch (deleteAction) {
                    case ABORT: {
                        foreignKeyDeleteAction = ForeignKeyDeleteAction.ABORT;
                        break;
                    }
                    case CASCADE: {
                        foreignKeyDeleteAction = ForeignKeyDeleteAction.CASCADE;
                        break;
                    }
                    case NULLIFY: {
                        foreignKeyDeleteAction = ForeignKeyDeleteAction.NULLIFY;
                        break;
                    }
                    default: {
                        throw DbCompat.unexpectedState(deleteAction.toString());
                    }
                }
                secondaryConfig.setForeignKeyDeleteAction(foreignKeyDeleteAction);
                if (deleteAction == DeleteAction.NULLIFY) {
                    secondaryConfig.setForeignMultiKeyNullifier(persistKeyCreator);
                }
            }
            this.secConfigMap.put(string, secondaryConfig);
        }
        return secondaryConfig;
    }

    public synchronized void setSecondaryConfig(Class clazz, String string, SecondaryConfig secondaryConfig) {
        this.checkOpen();
        String string2 = clazz.getName();
        EntityMetadata entityMetadata = this.checkEntityClass(string2);
        SecondaryKeyMetadata secondaryKeyMetadata = this.checkSecKey(entityMetadata, string);
        String string3 = this.getSecKeyClass(secondaryKeyMetadata);
        String string4 = Store.makeSecName(clazz.getName(), string);
        if (this.secIndexMap.containsKey(string4)) {
            throw new IllegalStateException("Cannot set config after DB is open");
        }
        SecondaryConfig secondaryConfig2 = this.getSecondaryConfig(string4, entityMetadata, string3, secondaryKeyMetadata);
        if (secondaryConfig.getExclusiveCreate() || secondaryConfig.getAllowCreate() == secondaryConfig.getReadOnly() || secondaryConfig.getSortedDuplicates() != secondaryConfig2.getSortedDuplicates() || secondaryConfig.getBtreeComparator() != secondaryConfig2.getBtreeComparator() || secondaryConfig.getDuplicateComparator() != null || secondaryConfig.getAllowPopulate() != secondaryConfig2.getAllowPopulate() || secondaryConfig.getKeyCreator() != secondaryConfig2.getKeyCreator() || secondaryConfig.getMultiKeyCreator() != secondaryConfig2.getMultiKeyCreator() || secondaryConfig.getForeignKeyNullifier() != secondaryConfig2.getForeignKeyNullifier() || secondaryConfig.getForeignMultiKeyNullifier() != secondaryConfig2.getForeignMultiKeyNullifier() || secondaryConfig.getForeignKeyDeleteAction() != secondaryConfig2.getForeignKeyDeleteAction() || secondaryConfig.getForeignKeyDatabase() != null) {
            throw new IllegalArgumentException("One of these properties was illegally changed:  AllowCreate, ExclusiveCreate, SortedDuplicates, BtreeComparator, DuplicateComparator, Temporary, AllowPopulate, KeyCreator, MultiKeyCreator, ForeignKeyNullifer, ForeignMultiKeyNullifier, ForeignKeyDeleteAction, ForeignKeyDatabase");
        }
        if (!DbCompat.isTypeBtree(secondaryConfig)) {
            throw new IllegalArgumentException("Only type BTREE allowed");
        }
        this.secConfigMap.put(string4, secondaryConfig);
    }

    private static String makeSecName(String string, String string2) {
        return string + NAME_SEPARATOR + string2;
    }

    static String makePriDbName(String string, String string2) {
        return string + string2;
    }

    static String makeSecDbName(String string, String string2, String string3) {
        return string + Store.makeSecName(string2, string3);
    }

    public String[] parseDbName(String string) {
        return Store.parseDbName(string, this.storeConfig.getDatabaseNamer());
    }

    public static String[] parseDbName(String string, DatabaseNamer databaseNamer) {
        String[] stringArray = new String[2];
        String[] stringArray2 = string.split(NAME_SEPARATOR);
        assert (stringArray2.length == 3 || stringArray2.length == 4) : string;
        assert (stringArray2[0].equals("persist")) : string;
        String string2 = stringArray2[1];
        String string3 = stringArray2[2];
        String string4 = stringArray2.length > 3 ? stringArray2[3] : null;
        stringArray[0] = databaseNamer.getFileName(string2, string3, string4);
        stringArray[1] = null;
        return stringArray;
    }

    String getDbNameMessage(String[] stringArray) {
        return "file: " + stringArray[0];
    }

    private void checkOpen() {
        if (this.catalog == null) {
            throw new IllegalStateException("Store has been closed");
        }
    }

    private void checkWriteAllowed() {
        if (this.catalog.isReadOnly()) {
            throw new IllegalStateException("Store is read-only or is operating as a Replica");
        }
    }

    private EntityMetadata checkEntityClass(String string) {
        EntityMetadata entityMetadata = this.model.getEntityMetadata(string);
        if (entityMetadata == null) {
            throw new IllegalArgumentException("Class could not be loaded or is not an entity class: " + string);
        }
        return entityMetadata;
    }

    private SecondaryKeyMetadata checkSecKey(EntityMetadata entityMetadata, String string) {
        SecondaryKeyMetadata secondaryKeyMetadata = entityMetadata.getSecondaryKeys().get(string);
        if (secondaryKeyMetadata == null) {
            throw new IllegalArgumentException("Not a secondary key: " + Store.makeSecName(entityMetadata.getClassName(), string));
        }
        return secondaryKeyMetadata;
    }

    private String getSecKeyClass(SecondaryKeyMetadata secondaryKeyMetadata) {
        String string = secondaryKeyMetadata.getElementClassName();
        if (string == null) {
            string = secondaryKeyMetadata.getClassName();
        }
        return SimpleCatalog.keyClassName(string);
    }

    private PersistKeyBinding getKeyBinding(String string) {
        PersistKeyBinding persistKeyBinding = this.keyBindingMap.get(string);
        if (persistKeyBinding == null) {
            persistKeyBinding = new PersistKeyBinding((Catalog)this.catalog, string, this.rawAccess);
            this.keyBindingMap.put(string, persistKeyBinding);
        }
        return persistKeyBinding;
    }

    private PersistKeyCreator getKeyCreator(SecondaryConfig secondaryConfig) {
        PersistKeyCreator persistKeyCreator = (PersistKeyCreator)secondaryConfig.getKeyCreator();
        if (persistKeyCreator != null) {
            return persistKeyCreator;
        }
        persistKeyCreator = (PersistKeyCreator)secondaryConfig.getMultiKeyCreator();
        assert (persistKeyCreator != null);
        return persistKeyCreator;
    }

    private void setBtreeComparator(DatabaseConfig databaseConfig, String string) {
        if (!this.rawAccess) {
            Class clazz;
            PersistKeyBinding persistKeyBinding = this.getKeyBinding(string);
            Format format = persistKeyBinding.keyFormat;
            if (format instanceof CompositeKeyFormat && Comparable.class.isAssignableFrom(clazz = format.getType())) {
                databaseConfig.setBtreeComparator(new PersistComparator(persistKeyBinding));
            }
        }
    }

    private DatabaseException closeDb(Database database, DatabaseException databaseException) {
        block3: {
            if (database != null) {
                try {
                    database.close();
                }
                catch (DatabaseException databaseException2) {
                    if (databaseException != null) break block3;
                    databaseException = databaseException2;
                }
            }
        }
        return databaseException;
    }

    public EvolveStats evolve(EvolveConfig evolveConfig) throws DatabaseException {
        this.checkOpen();
        this.checkWriteAllowed();
        if (this.catalog.isReplicaUpgradeMode() || this.catalog.isMetadataStale(null)) {
            this.attemptRefresh();
        }
        PersistCatalog persistCatalog = this.catalog;
        ArrayList<Format> arrayList = new ArrayList<Format>();
        Set<String> set = evolveConfig.getClassesToEvolve();
        if (set.isEmpty()) {
            persistCatalog.getEntityFormats(arrayList);
        } else {
            for (String object : set) {
                Format format = persistCatalog.getFormat(object);
                if (format == null) {
                    throw new IllegalArgumentException("Class to evolve is not persistent: " + object);
                }
                if (!format.isEntity()) {
                    throw new IllegalArgumentException("Class to evolve is not an entity class: " + object);
                }
                arrayList.add(format);
            }
        }
        EvolveEvent evolveEvent = EvolveInternal.newEvent();
        for (Format format : arrayList) {
            if (!format.getEvolveNeeded()) continue;
            this.evolveIndex(format, evolveEvent, evolveConfig.getEvolveListener());
            format.setEvolveNeeded(false);
            persistCatalog.flush(null);
        }
        return evolveEvent.getStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evolveIndex(Format format, EvolveEvent evolveEvent, EvolveListener evolveListener) throws DatabaseException {
        Class clazz = format.getType();
        String string = format.getClassName();
        EntityMetadata entityMetadata = this.model.getEntityMetadata(string);
        String string2 = entityMetadata.getPrimaryKey().getClassName();
        string2 = SimpleCatalog.keyClassName(string2);
        DatabaseConfig databaseConfig = this.getPrimaryConfig(entityMetadata);
        PrimaryIndex primaryIndex = this.getPrimaryIndex(Object.class, string2, clazz, string);
        Database database = primaryIndex.getDatabase();
        EntityBinding entityBinding = primaryIndex.getEntityBinding();
        DatabaseEntry databaseEntry = new DatabaseEntry();
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        CursorConfig cursorConfig = null;
        Transaction transaction = null;
        if (databaseConfig.getTransactional()) {
            transaction = this.env.beginTransaction(null, this.autoCommitTxnConfig);
            cursorConfig = CursorConfig.READ_COMMITTED;
        }
        Cursor cursor = null;
        int n = 0;
        try {
            cursor = database.openCursor(transaction, cursorConfig);
            OperationStatus operationStatus = cursor.getFirst(databaseEntry, databaseEntry2, null);
            while (operationStatus == OperationStatus.SUCCESS) {
                boolean bl = false;
                if (this.evolveNeeded(databaseEntry, databaseEntry2, entityBinding)) {
                    cursor.putCurrent(databaseEntry2);
                    bl = true;
                    ++n;
                }
                EvolveInternal.updateEvent(evolveEvent, string, 1, bl ? 1 : 0);
                if (evolveListener != null && !evolveListener.evolveProgress(evolveEvent)) {
                    break;
                }
                if (transaction != null && n >= 1) {
                    cursor.close();
                    cursor = null;
                    transaction.commit();
                    transaction = null;
                    transaction = this.env.beginTransaction(null, this.autoCommitTxnConfig);
                    cursor = database.openCursor(transaction, cursorConfig);
                    DatabaseEntry databaseEntry3 = KeyRange.copy(databaseEntry);
                    operationStatus = cursor.getSearchKeyRange(databaseEntry, databaseEntry2, null);
                    if (operationStatus != OperationStatus.SUCCESS || !KeyRange.equalBytes(databaseEntry, databaseEntry3)) continue;
                    operationStatus = cursor.getNext(databaseEntry, databaseEntry2, null);
                    continue;
                }
                operationStatus = cursor.getNext(databaseEntry, databaseEntry2, null);
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (transaction != null) {
                if (n > 0) {
                    transaction.commit();
                } else {
                    transaction.abort();
                }
            }
        }
    }

    private boolean evolveNeeded(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, EntityBinding entityBinding) {
        Object e = entityBinding.entryToObject(databaseEntry, databaseEntry2);
        DatabaseEntry databaseEntry3 = new DatabaseEntry();
        entityBinding.objectToData(e, databaseEntry3);
        if (databaseEntry2.equals(databaseEntry3)) {
            return false;
        }
        byte[] byArray = databaseEntry3.getData();
        int n = databaseEntry3.getOffset();
        int n2 = databaseEntry3.getSize();
        databaseEntry2.setData(byArray, n, n2);
        return true;
    }

    public static void setSyncHook(SyncHook syncHook) {
        Store.syncHook = syncHook;
    }

    public boolean attemptRefresh() {
        PersistCatalog persistCatalog = this.catalog;
        PersistCatalog persistCatalog2 = this.refresh(persistCatalog, -1, null);
        return persistCatalog != persistCatalog2;
    }

    synchronized PersistCatalog refresh(PersistCatalog persistCatalog, int n, RefreshException refreshException) {
        if (persistCatalog != this.catalog) {
            return this.catalog;
        }
        try {
            this.catalog = new PersistCatalog(persistCatalog, this.storePrefix);
        }
        catch (DatabaseException databaseException) {
            throw RuntimeExceptionWrapper.wrapIfNeeded(databaseException);
        }
        if (n >= this.catalog.getNFormats()) {
            throw DbCompat.unexpectedException("Catalog could not be refreshed, may indicate corruption, errorFormatId=" + n + " nFormats=" + this.catalog.getNFormats() + ", .", refreshException);
        }
        for (InternalPrimaryIndex object : this.priIndexMap.values()) {
            object.refresh(this.catalog);
        }
        for (InternalSecondaryIndex internalSecondaryIndex : this.secIndexMap.values()) {
            internalSecondaryIndex.refresh(this.catalog);
        }
        for (PersistKeyBinding persistKeyBinding : this.keyBindingMap.values()) {
            persistKeyBinding.refresh(this.catalog);
        }
        for (SecondaryConfig secondaryConfig : this.secConfigMap.values()) {
            PersistKeyCreator persistKeyCreator = this.getKeyCreator(secondaryConfig);
            persistKeyCreator.refresh(this.catalog);
        }
        return this.catalog;
    }

    TransactionConfig getAutoCommitTxnConfig() {
        return this.autoCommitTxnConfig;
    }

    private class InternalSecondaryIndex<SK, PK, E>
    extends SecondaryIndex<SK, PK, E> {
        private final PersistKeyCreator keyCreator;

        InternalSecondaryIndex(SecondaryDatabase secondaryDatabase, PrimaryIndex<PK, E> primaryIndex, Class<SK> clazz, PersistKeyBinding persistKeyBinding, PersistKeyCreator persistKeyCreator) throws DatabaseException {
            super(secondaryDatabase, null, primaryIndex, clazz, persistKeyBinding);
            this.keyCreator = persistKeyCreator;
        }

        void refresh(PersistCatalog persistCatalog) {
            this.keyCreator.refresh(persistCatalog);
        }
    }

    private class InternalPrimaryIndex<PK, E>
    extends PrimaryIndex<PK, E> {
        private final PersistEntityBinding entityBinding;

        InternalPrimaryIndex(Database database, Class<PK> clazz, PersistKeyBinding persistKeyBinding, Class<E> clazz2, PersistEntityBinding persistEntityBinding) throws DatabaseException {
            super(database, clazz, persistKeyBinding, clazz2, persistEntityBinding);
            this.entityBinding = persistEntityBinding;
        }

        void refresh(PersistCatalog persistCatalog) {
            this.entityBinding.refresh(persistCatalog);
        }
    }

    public static interface SyncHook {
        public void onSync(Database var1);
    }

    private class PrimaryOpenState {
        private String entityClassName;
        private IdentityHashMap<Database, Object> databases;
        private Set<String> secNames;

        PrimaryOpenState(String string) {
            this.entityClassName = string;
            this.databases = new IdentityHashMap();
            this.secNames = new HashSet<String>();
        }

        void addDatabase(Database database) {
            this.databases.put(database, null);
        }

        void addSecondaryName(String string) {
            this.secNames.add(string);
        }

        void undoState() {
            for (Database object : this.databases.keySet()) {
                try {
                    object.close();
                }
                catch (Exception exception) {}
            }
            Store.this.priIndexMap.remove(this.entityClassName);
            for (String string : this.secNames) {
                Store.this.secIndexMap.remove(string);
            }
            for (Database database : this.databases.keySet()) {
                Store.this.deferredWriteDatabases.remove(database);
            }
        }
    }
}

