/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.domain.pools;

import com.sun.solaris.domain.pools.Expression;
import com.sun.solaris.domain.pools.Move;
import com.sun.solaris.domain.pools.Objective;
import com.sun.solaris.domain.pools.Poold;
import com.sun.solaris.service.pools.Configuration;
import com.sun.solaris.service.pools.Element;
import com.sun.solaris.service.pools.PoolsException;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

abstract class AbstractObjective
implements Objective {
    private static Map objectives;
    private Expression exp;

    AbstractObjective() {
    }

    @Override
    public abstract double calculate(Configuration var1, Move var2, Element var3) throws PoolsException;

    @Override
    public void setExpression(Expression expression) {
        this.exp = expression;
    }

    @Override
    public Expression getExpression() {
        return this.exp;
    }

    public static Objective getInstance(String string, Expression expression) throws IllegalArgumentException {
        Class clazz;
        Objective objective = null;
        Map map = null;
        AbstractObjective.initMapIfNecessary();
        map = (Map)objectives.get(string);
        if (map != null && (clazz = (Class)map.get(expression.getName())) != null) {
            try {
                objective = (Objective)clazz.newInstance();
            }
            catch (Exception exception) {
                Poold.utility.die(Poold.OPT_LOG, exception, true);
            }
            objective.setExpression(expression);
        }
        if (objective == null) {
            throw new IllegalArgumentException("unrecognized objective name for " + string + ": " + expression.toString());
        }
        return objective;
    }

    public String toString() {
        return this.exp.toString();
    }

    private static void initMapIfNecessary() {
        if (objectives == null) {
            objectives = new HashMap();
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream("/usr/lib/pool/poold.properties"));
            }
            catch (IOException iOException) {
                Poold.utility.die(Poold.CONF_LOG, iOException);
            }
            AbstractObjective.registerObjectives(properties, objectives, "system");
            AbstractObjective.registerObjectives(properties, objectives, "pset");
        }
    }

    private static void registerObjectives(Properties properties, Map map, String string) {
        HashMap hashMap = new HashMap();
        String string2 = properties.getProperty(string + ".objectives");
        String[] stringArray = string2.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].trim();
            try {
                Class<?> clazz = Class.forName(string3);
                Field field = clazz.getDeclaredField("name");
                String string4 = (String)field.get(null);
                hashMap.put(string4, clazz);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Poold.utility.die(Poold.CONF_LOG, classNotFoundException);
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Poold.utility.die(Poold.CONF_LOG, noSuchFieldException);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                Poold.utility.die(Poold.CONF_LOG, illegalAccessException);
            }
        }
        map.put(string, hashMap);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Objective)) {
            return false;
        }
        Objective objective = (Objective)object;
        return this.getExpression().equals(objective.getExpression());
    }

    public int hashCode() {
        return this.getExpression().hashCode();
    }
}

