/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.domain.pools;

import com.sun.solaris.domain.pools.AbstractStatistic;
import com.sun.solaris.domain.pools.AggregateStatistic;
import com.sun.solaris.service.pools.UnsignedInt64;
import java.util.Date;
import java.util.Iterator;

final class DoubleStatistic
extends AbstractStatistic
implements AggregateStatistic {
    public DoubleStatistic(Double d) {
        super(d);
    }

    public DoubleStatistic(Double d, Date date, Date date2) {
        super(d, date, date2);
    }

    @Override
    public Double getDoubleValue() {
        return (Double)this.getValue();
    }

    @Override
    public Long getLongValue() {
        return new Long(((Double)this.getValue()).longValue());
    }

    @Override
    public UnsignedInt64 getUnsignedInt64Value() {
        return new UnsignedInt64(Long.toString(((Double)this.getValue()).longValue()));
    }

    @Override
    public AggregateStatistic add(AggregateStatistic aggregateStatistic) {
        Double d = this.getDoubleValue();
        Double d2 = aggregateStatistic.getDoubleValue();
        return new DoubleStatistic(new Double(d + d2), this.getStart(), this.getEnd());
    }

    @Override
    public AggregateStatistic subtract(AggregateStatistic aggregateStatistic) {
        Double d = this.getDoubleValue();
        Double d2 = aggregateStatistic.getDoubleValue();
        return new DoubleStatistic(new Double(d - d2), this.getStart(), this.getEnd());
    }

    @Override
    public AggregateStatistic getSnapshotForInterval(Iterator iterator, Date date, Date date2) throws IllegalArgumentException {
        double d = 0.0;
        int n = 0;
        Date date3 = date;
        Date date4 = date2;
        while (iterator.hasNext()) {
            DoubleStatistic doubleStatistic = (DoubleStatistic)iterator.next();
            if (date != null && doubleStatistic.getStart().compareTo(date) < 0) continue;
            if (date3 == null) {
                date3 = doubleStatistic.getStart();
            }
            if (date2 != null && doubleStatistic.getEnd().compareTo(date2) > 0) continue;
            date4 = doubleStatistic.getEnd();
            d += doubleStatistic.getDoubleValue().doubleValue();
            ++n;
        }
        if (n == 0) {
            throw new IllegalArgumentException("Cannot derive a snapshot from an empty iterator");
        }
        return new DoubleStatistic(new Double(d / (double)n), date3, date4);
    }
}

