/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.domain.pools;

import com.sun.solaris.domain.pools.Expression;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class KVOpExpression
extends Expression {
    private char op;
    private int val;
    private static final Pattern pattern = Pattern.compile("\\s*((\\d+)\\s*:)?\\s*(\\w+)\\s*([~<>])\\s*(\\d+)\\s*");
    private static final String[] keys = new String[]{"utilization"};
    static final char GT = '>';
    static final char LT = '<';
    static final char NT = '~';

    private KVOpExpression(long l, String string, String string2, int n) {
        super(l, string);
        this.op = string2.charAt(0);
        this.val = n;
    }

    static Expression valueOf(String string) throws IllegalArgumentException {
        KVOpExpression kVOpExpression = null;
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            long l = 1L;
            int n = Integer.parseInt(matcher.group(5));
            if (matcher.group(2) != null) {
                l = KVOpExpression.validateImportance(matcher.group(2));
            }
            KVOpExpression.validateKeyword(keys, matcher.group(3));
            if (n > 100 || n < 0) {
                throw new IllegalArgumentException("expression value " + n + " is outside the legal range (0-100)");
            }
            kVOpExpression = new KVOpExpression(l, matcher.group(3), matcher.group(4), n);
        }
        return kVOpExpression;
    }

    char getOp() {
        return this.op;
    }

    int getValue() {
        return this.val;
    }

    public String toString() {
        return "(" + this.getImportance() + ", " + this.getName() + ", '" + this.op + "', " + this.val + ")";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KVOpExpression)) {
            return false;
        }
        KVOpExpression kVOpExpression = (KVOpExpression)object;
        return this.getName().compareTo(kVOpExpression.getName()) == 0 && this.op == kVOpExpression.getOp() && this.val == kVOpExpression.getValue();
    }

    public int hashCode() {
        return this.getName().hashCode() + this.op + this.val;
    }

    @Override
    public boolean contradicts(Expression expression) {
        if (!(expression instanceof KVOpExpression)) {
            return false;
        }
        KVOpExpression kVOpExpression = (KVOpExpression)expression;
        if (this.getName().compareTo(kVOpExpression.getName()) != 0) {
            return false;
        }
        if (this.getOp() != kVOpExpression.getOp()) {
            if (this.getOp() != '~' && kVOpExpression.getOp() != '~') {
                if (this.getOp() == '>' ? this.getValue() < kVOpExpression.getValue() : this.getValue() > kVOpExpression.getValue()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }
}

