/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.domain.pools;

import com.sun.solaris.domain.pools.AbstractStatistic;
import com.sun.solaris.domain.pools.AggregateStatistic;
import com.sun.solaris.service.pools.UnsignedInt64;
import java.util.Date;
import java.util.Iterator;

final class LongStatistic
extends AbstractStatistic
implements AggregateStatistic {
    public LongStatistic(Long l, Date date, Date date2) {
        super(l, date, date2);
    }

    @Override
    public Double getDoubleValue() {
        return new Double(((Long)this.getValue()).longValue());
    }

    @Override
    public Long getLongValue() {
        return (Long)this.getValue();
    }

    @Override
    public UnsignedInt64 getUnsignedInt64Value() {
        return new UnsignedInt64(Long.toString((Long)this.getValue()));
    }

    @Override
    public AggregateStatistic add(AggregateStatistic aggregateStatistic) {
        Long l = this.getLongValue();
        Long l2 = aggregateStatistic.getLongValue();
        return new LongStatistic(new Long(l + l2), this.getStart(), this.getEnd());
    }

    @Override
    public AggregateStatistic subtract(AggregateStatistic aggregateStatistic) {
        Long l = this.getLongValue();
        Long l2 = aggregateStatistic.getLongValue();
        return new LongStatistic(new Long(l - l2), this.getStart(), this.getEnd());
    }

    @Override
    public AggregateStatistic getSnapshotForInterval(Iterator iterator, Date date, Date date2) throws IllegalArgumentException {
        long l = 0L;
        int n = 0;
        Date date3 = date;
        Date date4 = date2;
        while (iterator.hasNext()) {
            LongStatistic longStatistic = (LongStatistic)iterator.next();
            if (date != null && longStatistic.getStart().compareTo(date) < 0) continue;
            if (date3 == null) {
                date3 = longStatistic.getStart();
            }
            if (date2 != null && longStatistic.getEnd().compareTo(date2) > 0) continue;
            date4 = longStatistic.getEnd();
            l += longStatistic.getLongValue().longValue();
            ++n;
        }
        if (n == 0) {
            throw new IllegalArgumentException("Cannot derive a snapshot from an empty iterator");
        }
        return new LongStatistic(new Long(l / (long)n), date3, date4);
    }
}

