/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.domain.pools;

import com.sun.solaris.domain.pools.LGroupData;
import com.sun.solaris.domain.pools.ResultTuple;
import com.sun.solaris.service.locality.LocalityGroup;
import com.sun.solaris.service.pools.Element;
import com.sun.solaris.service.pools.PoolsException;
import com.sun.solaris.service.pools.Resource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class PSETData {
    private Resource pset;
    private Map<LocalityGroup, LGroupData> lgroupdata = new HashMap<LocalityGroup, LGroupData>();
    private Map<LocalityGroup, ResultTuple> results = new HashMap<LocalityGroup, ResultTuple>();
    double AsIsTotal = 0.0;
    int numlg = 0;

    double getAsIsTotal() {
        return this.AsIsTotal;
    }

    Map<LocalityGroup, ResultTuple> getResults() {
        return this.results;
    }

    private void countLgroups(Map map) throws PoolsException {
        LGroupData lGroupData;
        LocalityGroup localityGroup;
        Object object2;
        List list = this.pset.getComponents(null);
        for (Object object2 : list) {
            int n = (int)((Element)object2).getLongProperty("cpu.sys_id");
            if (!map.containsKey(new Integer(n)) || !this.lgroupdata.containsKey(localityGroup = (LocalityGroup)map.get(new Integer(n)))) continue;
            lGroupData = this.lgroupdata.get(localityGroup);
            lGroupData.incNumcpu();
        }
        object2 = this.lgroupdata.keySet();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            localityGroup = (LocalityGroup)iterator.next();
            lGroupData = this.lgroupdata.get(localityGroup);
            if (lGroupData.getNumcpu() <= 0) continue;
            ++this.numlg;
        }
        if (this.numlg == 0) {
            throw new PoolsException();
        }
    }

    private double calcQ(double d, int n) {
        double d2 = d * (double)(n * n + n) / 2.0;
        return d2;
    }

    private void calcqA() throws PoolsException {
        Set<LocalityGroup> set = this.results.keySet();
        for (LocalityGroup localityGroup : set) {
            double d;
            if (!this.lgroupdata.containsKey(localityGroup)) continue;
            LGroupData lGroupData = this.lgroupdata.get(localityGroup);
            ResultTuple resultTuple = this.results.get(localityGroup);
            if (lGroupData.getNumcpu() == 0) {
                d = (this.AsIsTotal + resultTuple.getToResult()) / (double)(this.numlg + 1);
                resultTuple.setToResult(d);
            }
            if (lGroupData.getNumcpu() == 1) {
                d = (this.AsIsTotal + resultTuple.getFromResult()) / (double)(this.numlg - 1);
                resultTuple.setFromResult(d);
            }
            if (lGroupData.getNumcpu() > 1) {
                d = (this.AsIsTotal - resultTuple.getAsIsResult() + resultTuple.getToResult()) / (double)this.numlg;
                resultTuple.setToResult(d);
                double d2 = (this.AsIsTotal - resultTuple.getAsIsResult() + resultTuple.getFromResult()) / (double)this.numlg;
                resultTuple.setFromResult(d2);
            }
            this.results.put(localityGroup, resultTuple);
        }
    }

    private void calcResults(Set set) throws PoolsException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object;
            int n = 0;
            double d = 0.0;
            LocalityGroup localityGroup = (LocalityGroup)iterator.next();
            if (localityGroup.getCPUIDs().length == 0) continue;
            if (this.lgroupdata.containsKey(localityGroup)) {
                object = this.lgroupdata.get(localityGroup);
                n = ((LGroupData)object).getNumcpu();
                d = ((LGroupData)object).getFactor();
            }
            object = new ResultTuple(this.calcQ(d, n), this.calcQ(d, n - 1), this.calcQ(d, n + 1));
            this.AsIsTotal += ((ResultTuple)object).getAsIsResult();
            this.results.put(localityGroup, (ResultTuple)object);
        }
        this.calcqA();
        this.AsIsTotal /= (double)this.numlg;
    }

    PSETData(Set set, Map map, Resource resource) throws PoolsException {
        this.pset = resource;
        for (LocalityGroup localityGroup : set) {
            if (localityGroup.getCPUIDs().length == 0) continue;
            LGroupData lGroupData = new LGroupData(localityGroup);
            this.lgroupdata.put(localityGroup, lGroupData);
        }
        this.countLgroups(map);
        this.calcResults(set);
    }
}

