/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.domain.pools;

import com.sun.solaris.domain.pools.ConfigurationException;
import com.sun.solaris.domain.pools.DRM;
import com.sun.solaris.domain.pools.LogDRM;
import com.sun.solaris.domain.pools.Monitor;
import com.sun.solaris.domain.pools.PooldException;
import com.sun.solaris.domain.pools.Solver;
import com.sun.solaris.domain.pools.StaleMonitorException;
import com.sun.solaris.domain.pools.SystemMonitor;
import com.sun.solaris.domain.pools.SystemSolver;
import com.sun.solaris.service.exception.SuccinctStackTraceFormatter;
import com.sun.solaris.service.logging.Facility;
import com.sun.solaris.service.logging.Severity;
import com.sun.solaris.service.logging.SyslogHandler;
import com.sun.solaris.service.logging.SysloglikeFormatter;
import com.sun.solaris.service.pools.Configuration;
import com.sun.solaris.service.pools.PoolInternal;
import com.sun.solaris.service.pools.PoolsException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

final class Poold {
    private Configuration conf;
    private Monitor monitor;
    private DRM drm;
    private Solver solver;
    public static final String POOLD_PROPERTIES_PATH = "/usr/lib/pool/poold.properties";
    public static final Logger BASE_LOG = Logger.getLogger("com.sun.solaris.domain.pools.poold");
    public static final Logger CONF_LOG = Logger.getLogger("com.sun.solaris.domain.pools.poold.Configuration");
    public static final Logger MON_LOG = Logger.getLogger("com.sun.solaris.domain.pools.poold.Monitoring");
    public static final Logger OPT_LOG = Logger.getLogger("com.sun.solaris.domain.pools.poold.Optimization");
    private static Poold instance;
    private Thread mainThread;
    private static final int E_PO_FAILURE = 2;
    private AtomicBoolean firstInitialization = new AtomicBoolean(true);
    private AtomicBoolean shouldRun = new AtomicBoolean(true);

    private Poold(Severity severity) {
        logHelper.preinitialize(severity);
        try {
            this.conf = new Configuration(PoolInternal.pool_dynamic_location(), 1);
            this.conf.close();
        }
        catch (PoolsException poolsException) {
            utility.die(CONF_LOG, new PooldException("cannot open dynamic pools configuration read-write (" + poolsException.getMessage() + ")").initCause(poolsException), false);
        }
        try {
            this.conf = new Configuration(PoolInternal.pool_dynamic_location(), 0);
        }
        catch (PoolsException poolsException) {
            utility.die(CONF_LOG, poolsException);
        }
        this.monitor = new SystemMonitor();
        this.drm = new LogDRM();
        this.solver = new SystemSolver(this.monitor);
    }

    public static Poold getInstanceWithConsoleLogging(Severity severity) {
        if (instance == null) {
            instance = new Poold(severity);
            return instance;
        }
        if (!logHelper.usingConsole && severity == null || severity != null && logHelper.getSeverity().equals(severity)) {
            return instance;
        }
        throw new IllegalArgumentException();
    }

    private void initialize() {
        try {
            logHelper.initialize(this.conf);
            if (this.firstInitialization.get()) {
                CONF_LOG.log((Level)Severity.INFO, "starting");
            }
            boolean bl = true;
            while (bl && this.shouldRun.get()) {
                bl = false;
                try {
                    this.monitor.initialize(this.conf);
                    CONF_LOG.log((Level)Severity.DEBUG, "configuring solver...");
                    this.solver.initialize(this.conf);
                    CONF_LOG.log((Level)Severity.INFO, "configuration complete");
                }
                catch (PoolsException poolsException) {
                    CONF_LOG.log((Level)Severity.INFO, "The system is too busy to initialize, attempting initialization again");
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    bl = true;
                }
                catch (StaleMonitorException staleMonitorException) {
                    CONF_LOG.log((Level)Severity.INFO, "The system is too busy to initialize, attempting initialization again");
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    bl = true;
                }
            }
            if (this.firstInitialization.get()) {
                this.firstInitialization.set(false);
            }
        }
        catch (ConfigurationException configurationException) {
            utility.die(CONF_LOG, configurationException);
        }
    }

    private void execute() throws Exception {
        int n = 0;
        boolean bl = false;
        while (this.shouldRun.get()) {
            try {
                n = this.conf.update();
                assert (!bl || bl && n != 0);
                if (n != 0) {
                    CONF_LOG.log((Level)Severity.DEBUG, "configuration change detected");
                    if (!bl) {
                        CONF_LOG.log((Level)Severity.INFO, "configuration changed externally");
                    }
                    CONF_LOG.log((Level)Severity.INFO, "reconfiguring...");
                }
                bl = false;
            }
            catch (PoolsException poolsException) {
                utility.die(CONF_LOG, poolsException);
            }
            if (n != 0) {
                this.initialize();
            }
            boolean bl2 = false;
            while (this.shouldRun.get() && !bl2) {
                try {
                    this.monitor.getNext();
                    bl2 = true;
                    if (this.solver.examine(this.monitor)) {
                        MON_LOG.log((Level)Severity.INFO, "reconfiguration required");
                        bl = this.solver.solve();
                        continue;
                    }
                    MON_LOG.log((Level)Severity.INFO, "all evaluated objectives satisfied");
                }
                catch (StaleMonitorException staleMonitorException) {
                    bl = true;
                    break;
                }
                catch (InterruptedException interruptedException) {
                    MON_LOG.log((Level)Severity.INFO, "interrupted");
                    break;
                }
            }
            if (!this.shouldRun.get()) break;
            System.runFinalization();
        }
        BASE_LOG.log((Level)Severity.NOTICE, "exiting");
    }

    private void cleanup() {
        this.conf.close();
        logHelper.close();
        instance = null;
    }

    public void run() {
        this.mainThread = Thread.currentThread();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Poold.this.cleanup();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        try {
            this.initialize();
            this.execute();
        }
        catch (Throwable throwable) {
            utility.die(BASE_LOG, throwable);
        }
    }

    public void shutdown() {
        this.shouldRun.set(false);
        if (!this.firstInitialization.get() && this.mainThread != null) {
            this.mainThread.interrupt();
        }
    }

    public static void main(String[] stringArray) throws IllegalArgumentException {
        Severity severity = null;
        if (stringArray.length > 0) {
            if (stringArray[0].compareTo("-l") == 0 && stringArray.length == 2) {
                severity = (Severity)Severity.parse(stringArray[1]);
            } else {
                throw new IllegalArgumentException("usage: poold [-l level]");
            }
        }
        Poold poold = Poold.getInstanceWithConsoleLogging(severity);
        poold.run();
    }

    static class utility {
        utility() {
        }

        public static void die(Logger logger, Throwable throwable) {
            utility.die(logger, throwable, true);
        }

        public static void die(Logger logger, Throwable throwable, boolean bl) {
            try {
                LogRecord logRecord = throwable instanceof PooldException ? new LogRecord(((PooldException)throwable).getSeverity(), throwable.getMessage()) : new LogRecord(Severity.ERR, throwable.getMessage());
                if (logRecord.getMessage() == null) {
                    logRecord.setMessage("exception " + throwable.getClass().getName());
                }
                if (bl) {
                    logRecord.setThrown(throwable);
                }
                logRecord.setLoggerName(logger.getName());
                logger.log(logRecord);
                if (logHelper.handler != null) {
                    logHelper.handler.flush();
                }
                if (throwable instanceof PooldException) {
                    System.exit(((PooldException)throwable).getExitCode());
                } else {
                    System.exit(2);
                }
            }
            catch (Exception exception) {
                SuccinctStackTraceFormatter.printStackTrace(exception);
                System.exit(-1);
            }
        }

        public static void warn(Logger logger, Throwable throwable, boolean bl) {
            try {
                LogRecord logRecord = throwable instanceof PooldException ? new LogRecord(((PooldException)throwable).getSeverity(), throwable.getMessage()) : new LogRecord(Severity.WARNING, throwable.getMessage());
                if (logRecord.getMessage() == null) {
                    logRecord.setMessage("exception " + throwable.getClass().getName());
                }
                if (bl) {
                    logRecord.setThrown(throwable);
                }
                logRecord.setLoggerName(logger.getName());
                logger.log(logRecord);
                if (logHelper.handler != null) {
                    logHelper.handler.flush();
                }
            }
            catch (Exception exception) {
                SuccinctStackTraceFormatter.printStackTrace(exception);
                System.exit(-1);
            }
        }
    }

    private static class logHelper {
        public static final String DEF_LOG_LOC = "/var/log/pool/poold";
        public static final String SYSLOG_LOG_LOC = "SYSLOG";
        public static final Severity DEF_SEVERITY = Severity.INFO;
        public static final String PROPERTY_NAME_LOG_LOC = "system.poold.log-location";
        public static final String PROPERTY_NAME_LOG_LEVEL = "system.poold.log-level";
        private static String location;
        private static Handler handler;
        private static Severity severity;
        private static boolean preinitialized;
        private static boolean usingConsole;
        private static final boolean loggingDebugging = false;

        private logHelper() {
        }

        private static void preinitialize(Severity severity) {
            if (preinitialized) {
                return;
            }
            Properties properties = new Properties();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                properties.load(new FileInputStream(Poold.POOLD_PROPERTIES_PATH));
                properties.store(byteArrayOutputStream, "");
                LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                MON_LOG.log((Level)Severity.WARNING, "could not read logging properties from poold.properties: " + iOException);
            }
            if (severity == null) {
                location = SYSLOG_LOG_LOC;
                handler = SyslogHandler.getInstance("poold", Facility.DAEMON);
                logHelper.severity = DEF_SEVERITY;
                handler.setLevel(logHelper.severity);
                BASE_LOG.addHandler(handler);
            }
            if (severity != null) {
                Logger logger = Logger.getLogger("");
                Handler[] handlerArray = logger.getHandlers();
                ConsoleHandler consoleHandler = null;
                for (int i = 0; i < handlerArray.length && consoleHandler == null; ++i) {
                    if (!(handlerArray[i] instanceof ConsoleHandler)) continue;
                    consoleHandler = (ConsoleHandler)handlerArray[i];
                }
                if (consoleHandler == null) {
                    consoleHandler = new ConsoleHandler();
                    consoleHandler.setFormatter(new SysloglikeFormatter());
                    consoleHandler.setLevel(severity);
                    logger.addHandler(consoleHandler);
                }
                logHelper.severity = severity;
                BASE_LOG.log((Level)Severity.DEBUG, "logging with level " + logHelper.severity);
                usingConsole = true;
            }
            preinitialized = true;
        }

        public static void initializeWithConfiguration(Configuration configuration) throws ConfigurationException {
            Severity severity;
            String string;
            String string2 = null;
            try {
                string = configuration.getStringProperty(PROPERTY_NAME_LOG_LOC);
            }
            catch (PoolsException poolsException) {
                string = DEF_LOG_LOC;
            }
            try {
                string2 = configuration.getStringProperty(PROPERTY_NAME_LOG_LEVEL);
                severity = Severity.getSeverityWithName(string2);
                assert (severity != null);
            }
            catch (PoolsException poolsException) {
                severity = DEF_SEVERITY;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (ConfigurationException)new ConfigurationException("invalid system.poold.log-levelvalue: " + string2).initCause(illegalArgumentException);
            }
            Handler handler = null;
            if (logHelper.handler != null) {
                BASE_LOG.removeHandler(logHelper.handler);
                logHelper.handler.close();
                logHelper.handler = null;
            }
            if (string.toUpperCase().equals(SYSLOG_LOG_LOC.toUpperCase())) {
                handler = SyslogHandler.getInstance("poold", Facility.DAEMON);
            } else {
                if (!string.startsWith("/")) {
                    throw new ConfigurationException("system.poold.log-location value is not an absolute path");
                }
                try {
                    handler = new FileHandler(string, 0, 1, true);
                    handler.setFormatter(new SysloglikeFormatter());
                }
                catch (IOException iOException) {
                    utility.die(CONF_LOG, new PooldException(string + ": can't write").initCause(iOException), false);
                }
            }
            if (!logHelper.severity.equals(severity) || !location.equals(string)) {
                CONF_LOG.log((Level)Severity.DEBUG, "logging with level " + logHelper.severity);
            }
            logHelper.severity = severity;
            logHelper.handler = handler;
            location = string;
            logHelper.handler.setLevel(logHelper.severity);
            BASE_LOG.addHandler(logHelper.handler);
        }

        public static void initialize(Configuration configuration) throws ConfigurationException {
            if (usingConsole) {
                return;
            }
            logHelper.initializeWithConfiguration(configuration);
        }

        public static Severity getSeverity() {
            return severity;
        }

        public static void close() {
            if (handler != null) {
                BASE_LOG.removeHandler(handler);
                handler.close();
            }
        }

        static {
            preinitialized = false;
        }
    }
}

