/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.domain.pools;

import com.sun.solaris.domain.pools.AggregateStatistic;
import com.sun.solaris.domain.pools.DoubleStatistic;
import com.sun.solaris.domain.pools.KVOpExpression;
import com.sun.solaris.domain.pools.StatisticEvent;
import com.sun.solaris.domain.pools.StatisticList;
import com.sun.solaris.domain.pools.StatisticListener;
import java.text.DecimalFormat;
import java.util.Iterator;

class StatisticOperations
implements StatisticListener {
    public static final int ZONEC = 16;
    public static final int ZONEB = 256;
    public static final int ZONEA = 4096;
    public static final int ZONEZ = 65536;
    public static final int ZONET = 1;
    public static final int ZONELT = 0;
    public static final int ZONEGT = 1;
    private final StatisticList statistics;
    private double mean;
    private double sd;
    private AggregateStatistic total;

    public StatisticOperations(StatisticList statisticList) {
        this.statistics = statisticList;
        this.total = new DoubleStatistic(new Double(0.0));
    }

    private void calc_sd() {
        this.sd = 0.0;
        Iterator iterator = this.statistics.iterator();
        while (iterator.hasNext()) {
            Double d = (Double)((DoubleStatistic)((AggregateStatistic)iterator.next())).getValue();
            this.sd += Math.pow(d - this.mean, 2.0);
        }
        this.sd /= (double)this.statistics.size();
        this.sd = Math.sqrt(this.sd);
    }

    public String toZoneString(KVOpExpression kVOpExpression, double d) {
        if (this.isValid()) {
            DecimalFormat decimalFormat = new DecimalFormat("00.00");
            double d2 = kVOpExpression.getValue();
            if (kVOpExpression.getOp() == '<') {
                d2 -= 3.0 * this.sd;
            } else if (kVOpExpression.getOp() == '>') {
                d2 += 3.0 * this.sd;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(kVOpExpression.toString());
            stringBuffer.append("\nsample = " + this.statistics.size());
            stringBuffer.append("\n\ttarget: " + decimalFormat.format(d2));
            stringBuffer.append("\n\tvalue: " + decimalFormat.format(d));
            stringBuffer.append("\n\tsd: " + decimalFormat.format(this.sd));
            stringBuffer.append("\n\tZones:");
            stringBuffer.append("\n\t\tC:" + decimalFormat.format(d2 - this.sd));
            stringBuffer.append("-" + decimalFormat.format(d2 + this.sd));
            stringBuffer.append("\n\t\tB:" + decimalFormat.format(d2 - 2.0 * this.sd));
            stringBuffer.append("-" + decimalFormat.format(d2 + 2.0 * this.sd));
            stringBuffer.append("\n\t\tA:" + decimalFormat.format(d2 - 3.0 * this.sd));
            stringBuffer.append("-" + decimalFormat.format(d2 + 3.0 * this.sd));
            return stringBuffer.toString();
        }
        return "Still sampling...";
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat("00.00");
        if (this.isValid()) {
            return "sample = " + this.statistics.size() + "\n\tmean: " + decimalFormat.format(this.mean) + "\n\tsd: " + decimalFormat.format(this.sd) + "\n\tZones:" + "\n\t\tC:" + decimalFormat.format(this.mean - this.sd) + "-" + decimalFormat.format(this.mean + this.sd) + "\n\t\tB:" + decimalFormat.format(this.mean - 2.0 * this.sd) + "-" + decimalFormat.format(this.mean + 2.0 * this.sd) + "\n\t\tA:" + decimalFormat.format(this.mean - 3.0 * this.sd) + "-" + decimalFormat.format(this.mean + 3.0 * this.sd);
        }
        return "Still sampling...";
    }

    public boolean isValid() {
        return this.statistics.size() >= 5;
    }

    private final void process() {
        this.mean = (Double)((DoubleStatistic)this.total).getValue() / (double)this.statistics.size();
        this.calc_sd();
    }

    public int getZone(KVOpExpression kVOpExpression, double d) {
        if (!this.isValid()) {
            return 16;
        }
        double d2 = kVOpExpression.getValue();
        if (kVOpExpression.getOp() == '<') {
            d2 -= 3.0 * this.sd;
        } else if (kVOpExpression.getOp() == '>') {
            d2 += 3.0 * this.sd;
        }
        return this.getZone(d2, d);
    }

    public int getZoneMean(double d) {
        if (!this.isValid()) {
            return 16;
        }
        return this.getZone(this.mean, d);
    }

    private int getZone(double d, double d2) {
        if (!this.isValid()) {
            return 16;
        }
        return d2 < d - 3.0 * this.sd ? 65536 : (d2 > d + 3.0 * this.sd ? 65537 : (d2 < d - 2.0 * this.sd ? 4096 : (d2 > d + 2.0 * this.sd ? 4097 : (d2 < d - this.sd ? 256 : (d2 > d + this.sd ? 257 : (d2 < d ? 16 : 17))))));
    }

    public double getGap(KVOpExpression kVOpExpression, double d) {
        if (!this.isValid()) {
            return 0.0;
        }
        double d2 = kVOpExpression.getValue();
        if (kVOpExpression.getOp() == '<') {
            d2 -= 3.0 * this.sd;
        } else if (kVOpExpression.getOp() == '>') {
            d2 += 3.0 * this.sd;
        }
        if (d - d2 < -100.0) {
            return -100.0;
        }
        if (d - d2 > 100.0) {
            return 100.0;
        }
        return d - d2;
    }

    @Override
    public void onStatisticAdd(StatisticEvent statisticEvent) {
        this.total = this.total.add(statisticEvent.getTarget());
        this.process();
    }

    @Override
    public void onStatisticRemove(StatisticEvent statisticEvent) {
        this.total = this.total.subtract(statisticEvent.getTarget());
        this.process();
    }
}

