/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.service.logging;

import java.util.HashMap;
import java.util.logging.Level;

public final class Severity
extends Level {
    private static final int LOG_EMERG = 0;
    private static final int LOG_ALERT = 1;
    private static final int LOG_CRIT = 2;
    private static final int LOG_ERR = 3;
    private static final int LOG_WARNING = 4;
    private static final int LOG_NOTICE = 5;
    private static final int LOG_INFO = 6;
    private static final int LOG_DEBUG = 7;
    private static final HashMap severityMap = new HashMap();
    public static final Severity EMERG = new Severity(0, Level.SEVERE.intValue() - 1, "EMERG");
    public static final Severity ALERT = new Severity(1, Level.SEVERE.intValue() - 2, "ALERT");
    public static final Severity CRIT = new Severity(2, Level.SEVERE.intValue() - 3, "CRIT");
    public static final Severity ERR = new Severity(3, Level.SEVERE.intValue() - 4, "ERR");
    public static final Severity WARNING = new Severity(4, Level.WARNING.intValue() - 1, "WARNING");
    public static final Severity NOTICE = new Severity(5, Level.INFO.intValue() - 1, "NOTICE");
    public static final Severity INFO = new Severity(6, Level.INFO.intValue() - 2, "INFO");
    public static final Severity DEBUG = new Severity(7, Level.FINE.intValue() - 1, "DEBUG");
    private static final Level SEVERE;
    private static final Level CONFIG;
    private static final Level FINE;
    private static final Level FINER;
    private static final Level FINEST;
    private int severity;

    private Severity(int n, int n2, String string) {
        super(string, n2);
        this.severity = n;
        Severity severity = severityMap.put(string, this);
        assert (severity == null);
    }

    public static Severity severityForLevel(Level level) {
        if (level instanceof Severity) {
            return (Severity)level;
        }
        if (level.intValue() >= Level.SEVERE.intValue()) {
            return ERR;
        }
        if (level.intValue() >= Level.WARNING.intValue()) {
            return WARNING;
        }
        if (level.intValue() >= Level.INFO.intValue()) {
            return INFO;
        }
        if (level.intValue() >= Level.CONFIG.intValue()) {
            return INFO;
        }
        if (level.intValue() >= Level.FINE.intValue()) {
            return DEBUG;
        }
        return null;
    }

    public int getNative() {
        return this.severity;
    }

    public static Level parse(String string) {
        Severity severity = (Severity)severityMap.get(string.toUpperCase());
        if (severity == null) {
            throw new IllegalArgumentException();
        }
        return severity;
    }

    public static Severity getSeverityWithName(String string) {
        return (Severity)Severity.parse(string);
    }

    static {
        severityMap.put("WARN", WARNING);
        severityMap.put("ERROR", ERR);
        SEVERE = null;
        CONFIG = null;
        FINE = null;
        FINER = null;
        FINEST = null;
    }
}

