/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.service.logging;

import com.sun.solaris.service.exception.SuccinctStackTraceFormatter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SysloglikeFormatter
extends Formatter {
    private Date date = new Date();
    private static final String dateFormat = "MMM d kk:mm:ss";
    private DateFormat dateFormatter;
    private Object[] args = new Object[]{this.date};
    private String lineSeparator = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty("line.separator");
        }
    });
    private boolean useClassName = false;
    private boolean useLoggerName = false;
    private boolean useShortLoggerName = true;
    private boolean useMethodName = false;
    private boolean useTwoLineStyle = false;

    @Override
    public synchronized String format(LogRecord logRecord) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        this.date.setTime(logRecord.getMillis());
        StringBuffer stringBuffer2 = new StringBuffer();
        if (this.dateFormatter == null) {
            this.dateFormatter = new SimpleDateFormat(dateFormat);
        }
        stringBuffer.append(this.dateFormatter.format(this.date));
        if (logRecord.getSourceClassName() != null && this.useClassName) {
            stringBuffer.append(" ");
            stringBuffer.append(logRecord.getSourceClassName());
        } else if (this.useLoggerName) {
            if (logRecord.getLoggerName() != null) {
                stringBuffer.append(" ");
                stringBuffer.append(logRecord.getLoggerName());
            }
        } else if (this.useShortLoggerName && (string = logRecord.getLoggerName()) != null) {
            stringBuffer.append(" ");
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        if (logRecord.getSourceMethodName() != null && this.useMethodName) {
            stringBuffer.append(" ");
            stringBuffer.append(logRecord.getSourceMethodName());
        }
        if (this.useTwoLineStyle) {
            stringBuffer.append(this.lineSeparator);
        } else {
            stringBuffer.append(" ");
        }
        string = this.formatMessage(logRecord);
        string = string.replaceAll("\n", this.lineSeparator + "    ");
        stringBuffer.append(logRecord.getLevel()).toString();
        stringBuffer.append(": ");
        stringBuffer.append(string);
        if (logRecord.getThrown() != null) {
            stringBuffer.append(" ");
            stringBuffer.append(SuccinctStackTraceFormatter.formatWithDescription(logRecord.getThrown(), "with tracing information: ").toString());
        }
        stringBuffer.append(this.lineSeparator);
        return stringBuffer.toString();
    }
}

