/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.service.pools;

import com.sun.solaris.service.pools.Component;
import com.sun.solaris.service.pools.Configuration;
import com.sun.solaris.service.pools.Element;
import com.sun.solaris.service.pools.PoolInternal;
import com.sun.solaris.service.pools.PoolsException;
import com.sun.solaris.service.pools.Value;
import java.util.ArrayList;
import java.util.List;

public class Resource
extends Element {
    private final String type;
    private final String name;
    private final String key;

    Resource(Configuration configuration, long l) throws PoolsException {
        this._conf = configuration;
        Value value = this.getProperty("type", l);
        this.type = value.getString();
        value.close();
        value = this.getProperty(this.type + ".name", l);
        this.name = value.getString();
        value.close();
        this.key = this.type + "." + this.name;
    }

    long getResource() throws PoolsException {
        return this._conf.checkResource(this.type, this.name);
    }

    public void transfer(Resource resource, long l) throws PoolsException {
        if (PoolInternal.pool_resource_transfer(this._conf.getConf(), resource.getResource(), this.getResource(), l) != 0) {
            throw new PoolsException();
        }
    }

    public void transfer(Resource resource, List list) throws PoolsException {
        if (PoolInternal.pool_resource_xtransfer(this._conf.getConf(), resource.getResource(), this.getResource(), list) != 0) {
            throw new PoolsException();
        }
    }

    public List getComponents(List list) throws PoolsException {
        List list2 = PoolInternal.pool_query_resource_components(this._conf.getConf(), this.getResource(), list);
        if (list2 == null) {
            if (PoolInternal.pool_error() == 4) {
                return new ArrayList();
            }
            throw new PoolsException();
        }
        ArrayList<Component> arrayList = new ArrayList<Component>(list2.size());
        for (int i = 0; i < list2.size(); ++i) {
            arrayList.add(new Component(this._conf, (Long)list2.get(i)));
        }
        return arrayList;
    }

    @Override
    public String getInformation(int n) throws PoolsException {
        return PoolInternal.pool_resource_info(this._conf.getConf(), this.getResource(), n);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.type);
        stringBuffer.append(" ");
        stringBuffer.append(this.name);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Resource)) {
            return false;
        }
        Resource resource = (Resource)object;
        return this.type.compareTo(resource.getType()) == 0 && this.name.compareTo(resource.getName()) == 0;
    }

    public int hashCode() {
        return this.type.hashCode() + this.name.hashCode();
    }

    @Override
    protected long getElem() throws PoolsException {
        long l = PoolInternal.pool_resource_to_elem(this._conf.getConf(), this.getResource());
        if (l == 0L) {
            throw new PoolsException();
        }
        return l;
    }

    String getType() {
        return this.type;
    }

    String getName() {
        return this.name;
    }

    @Override
    String getKey() {
        return this.key;
    }
}

