/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.domain.pools;

import com.sun.solaris.domain.pools.Statistic;
import com.sun.solaris.service.pools.UnsignedInt64;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

abstract class AbstractStatistic
implements Statistic {
    private final Object value;
    private final Date start;
    private final Date end;
    private static final DateFormat df = new SimpleDateFormat("kk:mm:ss");

    protected AbstractStatistic(Object object) {
        this(object, null, null);
    }

    protected AbstractStatistic(Object object, Date date, Date date2) {
        this.value = object;
        this.start = date;
        this.end = date2;
    }

    @Override
    public Date getStart() {
        return this.start;
    }

    @Override
    public Date getEnd() {
        return this.end;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public abstract Long getLongValue();

    @Override
    public abstract Double getDoubleValue();

    @Override
    public abstract UnsignedInt64 getUnsignedInt64Value();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.value);
        if (this.start != null && this.end != null) {
            stringBuffer.append(" from ");
            stringBuffer.append(df.format(this.start));
            stringBuffer.append(" to ");
            stringBuffer.append(df.format(this.end));
        }
        return stringBuffer.toString();
    }
}

