/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.domain.pools;

import com.sun.solaris.domain.pools.AbstractObjective;
import com.sun.solaris.domain.pools.Monitor;
import com.sun.solaris.domain.pools.Move;
import com.sun.solaris.domain.pools.Poold;
import com.sun.solaris.domain.pools.Solver;
import com.sun.solaris.domain.pools.StaleMonitorException;
import com.sun.solaris.domain.pools.WorkloadDependentObjective;
import com.sun.solaris.service.logging.Severity;
import com.sun.solaris.service.pools.Configuration;
import com.sun.solaris.service.pools.Element;
import com.sun.solaris.service.pools.PoolsException;
import com.sun.solaris.service.pools.Resource;
import com.sun.solaris.service.pools.Value;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

final class WeightedLoadObjective
extends AbstractObjective
implements WorkloadDependentObjective {
    static final String name = "wt-load";
    Map calcMap;

    WeightedLoadObjective() {
    }

    @Override
    public boolean examine(Configuration configuration, Solver solver, Element element) throws PoolsException, StaleMonitorException {
        Monitor monitor = solver.getMonitor();
        Value value = new Value("type", "pset");
        LinkedList<Value> linkedList = new LinkedList<Value>();
        this.calcMap = new HashMap();
        linkedList.add(value);
        List list = configuration.getResources(linkedList);
        value.close();
        Iterator iterator = list.iterator();
        Calculation.totalUtil = 0.0;
        Calculation.resQ = 0;
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            Object object = resource.getComponents(null);
            try {
                Calculation calculation = new Calculation(resource, (List)object, monitor.getUtilization(resource), resource.getLongProperty("pset.min"), resource.getLongProperty("pset.max"));
                this.calcMap.put(resource, calculation);
            }
            catch (StaleMonitorException staleMonitorException) {
                Poold.MON_LOG.log((Level)Severity.INFO, resource.toString() + " not participating in " + this.toString() + " calculatation as it has no " + "available statistics.");
            }
        }
        for (Object object : this.calcMap.values()) {
            if (Math.ceil(((Calculation)object).getShare()) != (double)((Calculation)object).comp.size() && ((Calculation)object).getShare() >= (double)((Calculation)object).min) {
                Poold.MON_LOG.log((Level)Severity.INFO, element.toString() + " utilization objective not satisfied " + this.toString() + " with desired share " + ((Calculation)object).getShare() + " and actual share " + ((Calculation)object).comp.size());
                return true;
            }
            if ((double)Calculation.resQ == Calculation.totalUtil) {
                Poold.MON_LOG.log((Level)Severity.DEBUG, "Utlization 100%");
                return true;
            }
            Poold.MON_LOG.log((Level)Severity.DEBUG, "Utlization ok: " + object);
        }
        return false;
    }

    @Override
    public double calculate(Configuration configuration, Move move, Element element) throws PoolsException {
        double d = 0.0;
        Poold.OPT_LOG.log((Level)Severity.DEBUG, "Calculating objective type: wt-load");
        if (move.getQty() == 0L) {
            return 0.0;
        }
        Calculation calculation = (Calculation)this.calcMap.get(move.getFrom());
        Calculation calculation2 = (Calculation)this.calcMap.get(move.getTo());
        if (calculation2.getShare() < (double)calculation2.comp.size() && calculation.getShare() == (double)calculation.comp.size()) {
            return -1.0;
        }
        double d2 = calculation.getGap(move.getQty());
        double d3 = calculation2.getGap(move.getQty());
        d = (d3 - d2) / (double)Calculation.resQ;
        Poold.MON_LOG.log((Level)Severity.DEBUG, "ret: " + d + " src: " + calculation.toString() + " srcSize: " + calculation.comp.size() + " srcGap " + d2 + " tgt: " + calculation2.toString() + " tgtSize: " + calculation2.comp.size() + " tgtGap " + d3);
        return d;
    }

    static class Calculation {
        Resource res;
        List comp;
        double util;
        long min;
        long max;
        static double totalUtil;
        static int resQ;

        public Calculation(Resource resource, List list, double d, long l, long l2) {
            this.res = resource;
            this.comp = list;
            this.min = l;
            this.max = l2;
            this.util = d / 100.0 * (double)list.size();
            totalUtil += Math.max((double)l, this.util);
            resQ += list.size();
        }

        double getShare() {
            if (this.util == 0.0) {
                return 0.0;
            }
            return this.util / totalUtil * (double)resQ;
        }

        public double getGap(long l) {
            double d = (this.getShare() + (double)l - (double)this.comp.size()) / (double)this.comp.size();
            Poold.OPT_LOG.log((Level)Severity.DEBUG, "Calc (" + this.getShare() + " + " + l + " - " + this.comp.size() + ")/" + this.comp.size() + " = " + d);
            return d;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("res: " + this.res.toString());
            stringBuffer.append(" components: " + this.comp.toString());
            stringBuffer.append(" len: " + this.comp.size());
            stringBuffer.append(" min: " + this.min);
            stringBuffer.append(" max: " + this.max);
            stringBuffer.append(" util: " + this.util);
            stringBuffer.append(" total resource: " + resQ);
            stringBuffer.append(" total utilization: " + totalUtil);
            stringBuffer.append(" share: " + this.getShare());
            return stringBuffer.toString();
        }
    }
}

